/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(self["webpackChunk_N_E"] = self["webpackChunk_N_E"] || []).push([["node_modules_react-slick_lib_index_js"],{

/***/ "./node_modules/enquire.js/src/MediaQuery.js":
/*!***************************************************!*\
  !*** ./node_modules/enquire.js/src/MediaQuery.js ***!
  \***************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

eval(__webpack_require__.ts("var QueryHandler = __webpack_require__(/*! ./QueryHandler */ \"./node_modules/enquire.js/src/QueryHandler.js\");\nvar each = (__webpack_require__(/*! ./Util */ \"./node_modules/enquire.js/src/Util.js\").each);\n\n/**\n * Represents a single media query, manages it's state and registered handlers for this query\n *\n * @constructor\n * @param {string} query the media query string\n * @param {boolean} [isUnconditional=false] whether the media query should run regardless of whether the conditions are met. Primarily for helping older browsers deal with mobile-first design\n */\nfunction MediaQuery(query, isUnconditional) {\n    this.query = query;\n    this.isUnconditional = isUnconditional;\n    this.handlers = [];\n    this.mql = window.matchMedia(query);\n\n    var self = this;\n    this.listener = function(mql) {\n        // Chrome passes an MediaQueryListEvent object, while other browsers pass MediaQueryList directly\n        self.mql = mql.currentTarget || mql;\n        self.assess();\n    };\n    this.mql.addListener(this.listener);\n}\n\nMediaQuery.prototype = {\n\n    constuctor : MediaQuery,\n\n    /**\n     * add a handler for this query, triggering if already active\n     *\n     * @param {object} handler\n     * @param {function} handler.match callback for when query is activated\n     * @param {function} [handler.unmatch] callback for when query is deactivated\n     * @param {function} [handler.setup] callback for immediate execution when a query handler is registered\n     * @param {boolean} [handler.deferSetup=false] should the setup callback be deferred until the first time the handler is matched?\n     */\n    addHandler : function(handler) {\n        var qh = new QueryHandler(handler);\n        this.handlers.push(qh);\n\n        this.matches() && qh.on();\n    },\n\n    /**\n     * removes the given handler from the collection, and calls it's destroy methods\n     *\n     * @param {object || function} handler the handler to remove\n     */\n    removeHandler : function(handler) {\n        var handlers = this.handlers;\n        each(handlers, function(h, i) {\n            if(h.equals(handler)) {\n                h.destroy();\n                return !handlers.splice(i,1); //remove from array and exit each early\n            }\n        });\n    },\n\n    /**\n     * Determine whether the media query should be considered a match\n     *\n     * @return {Boolean} true if media query can be considered a match, false otherwise\n     */\n    matches : function() {\n        return this.mql.matches || this.isUnconditional;\n    },\n\n    /**\n     * Clears all handlers and unbinds events\n     */\n    clear : function() {\n        each(this.handlers, function(handler) {\n            handler.destroy();\n        });\n        this.mql.removeListener(this.listener);\n        this.handlers.length = 0; //clear array\n    },\n\n    /*\n        * Assesses the query, turning on all handlers if it matches, turning them off if it doesn't match\n        */\n    assess : function() {\n        var action = this.matches() ? 'on' : 'off';\n\n        each(this.handlers, function(handler) {\n            handler[action]();\n        });\n    }\n};\n\nmodule.exports = MediaQuery;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/enquire.js/src/MediaQuery.js\n"));

/***/ }),

/***/ "./node_modules/enquire.js/src/MediaQueryDispatch.js":
/*!***********************************************************!*\
  !*** ./node_modules/enquire.js/src/MediaQueryDispatch.js ***!
  \***********************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

eval(__webpack_require__.ts("var MediaQuery = __webpack_require__(/*! ./MediaQuery */ \"./node_modules/enquire.js/src/MediaQuery.js\");\nvar Util = __webpack_require__(/*! ./Util */ \"./node_modules/enquire.js/src/Util.js\");\nvar each = Util.each;\nvar isFunction = Util.isFunction;\nvar isArray = Util.isArray;\n\n/**\n * Allows for registration of query handlers.\n * Manages the query handler's state and is responsible for wiring up browser events\n *\n * @constructor\n */\nfunction MediaQueryDispatch () {\n    if(!window.matchMedia) {\n        throw new Error('matchMedia not present, legacy browsers require a polyfill');\n    }\n\n    this.queries = {};\n    this.browserIsIncapable = !window.matchMedia('only all').matches;\n}\n\nMediaQueryDispatch.prototype = {\n\n    constructor : MediaQueryDispatch,\n\n    /**\n     * Registers a handler for the given media query\n     *\n     * @param {string} q the media query\n     * @param {object || Array || Function} options either a single query handler object, a function, or an array of query handlers\n     * @param {function} options.match fired when query matched\n     * @param {function} [options.unmatch] fired when a query is no longer matched\n     * @param {function} [options.setup] fired when handler first triggered\n     * @param {boolean} [options.deferSetup=false] whether setup should be run immediately or deferred until query is first matched\n     * @param {boolean} [shouldDegrade=false] whether this particular media query should always run on incapable browsers\n     */\n    register : function(q, options, shouldDegrade) {\n        var queries         = this.queries,\n            isUnconditional = shouldDegrade && this.browserIsIncapable;\n\n        if(!queries[q]) {\n            queries[q] = new MediaQuery(q, isUnconditional);\n        }\n\n        //normalise to object in an array\n        if(isFunction(options)) {\n            options = { match : options };\n        }\n        if(!isArray(options)) {\n            options = [options];\n        }\n        each(options, function(handler) {\n            if (isFunction(handler)) {\n                handler = { match : handler };\n            }\n            queries[q].addHandler(handler);\n        });\n\n        return this;\n    },\n\n    /**\n     * unregisters a query and all it's handlers, or a specific handler for a query\n     *\n     * @param {string} q the media query to target\n     * @param {object || function} [handler] specific handler to unregister\n     */\n    unregister : function(q, handler) {\n        var query = this.queries[q];\n\n        if(query) {\n            if(handler) {\n                query.removeHandler(handler);\n            }\n            else {\n                query.clear();\n                delete this.queries[q];\n            }\n        }\n\n        return this;\n    }\n};\n\nmodule.exports = MediaQueryDispatch;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/enquire.js/src/MediaQueryDispatch.js\n"));

/***/ }),

/***/ "./node_modules/enquire.js/src/QueryHandler.js":
/*!*****************************************************!*\
  !*** ./node_modules/enquire.js/src/QueryHandler.js ***!
  \*****************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

eval(__webpack_require__.ts("/**\n * Delegate to handle a media query being matched and unmatched.\n *\n * @param {object} options\n * @param {function} options.match callback for when the media query is matched\n * @param {function} [options.unmatch] callback for when the media query is unmatched\n * @param {function} [options.setup] one-time callback triggered the first time a query is matched\n * @param {boolean} [options.deferSetup=false] should the setup callback be run immediately, rather than first time query is matched?\n * @constructor\n */\nfunction QueryHandler(options) {\n    this.options = options;\n    !options.deferSetup && this.setup();\n}\n\nQueryHandler.prototype = {\n\n    constructor : QueryHandler,\n\n    /**\n     * coordinates setup of the handler\n     *\n     * @function\n     */\n    setup : function() {\n        if(this.options.setup) {\n            this.options.setup();\n        }\n        this.initialised = true;\n    },\n\n    /**\n     * coordinates setup and triggering of the handler\n     *\n     * @function\n     */\n    on : function() {\n        !this.initialised && this.setup();\n        this.options.match && this.options.match();\n    },\n\n    /**\n     * coordinates the unmatch event for the handler\n     *\n     * @function\n     */\n    off : function() {\n        this.options.unmatch && this.options.unmatch();\n    },\n\n    /**\n     * called when a handler is to be destroyed.\n     * delegates to the destroy or unmatch callbacks, depending on availability.\n     *\n     * @function\n     */\n    destroy : function() {\n        this.options.destroy ? this.options.destroy() : this.off();\n    },\n\n    /**\n     * determines equality by reference.\n     * if object is supplied compare options, if function, compare match callback\n     *\n     * @function\n     * @param {object || function} [target] the target for comparison\n     */\n    equals : function(target) {\n        return this.options === target || this.options.match === target;\n    }\n\n};\n\nmodule.exports = QueryHandler;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/enquire.js/src/QueryHandler.js\n"));

/***/ }),

/***/ "./node_modules/enquire.js/src/Util.js":
/*!*********************************************!*\
  !*** ./node_modules/enquire.js/src/Util.js ***!
  \*********************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

eval(__webpack_require__.ts("/**\n * Helper function for iterating over a collection\n *\n * @param collection\n * @param fn\n */\nfunction each(collection, fn) {\n    var i      = 0,\n        length = collection.length,\n        cont;\n\n    for(i; i < length; i++) {\n        cont = fn(collection[i], i);\n        if(cont === false) {\n            break; //allow early exit\n        }\n    }\n}\n\n/**\n * Helper function for determining whether target object is an array\n *\n * @param target the object under test\n * @return {Boolean} true if array, false otherwise\n */\nfunction isArray(target) {\n    return Object.prototype.toString.apply(target) === '[object Array]';\n}\n\n/**\n * Helper function for determining whether target object is a function\n *\n * @param target the object under test\n * @return {Boolean} true if function, false otherwise\n */\nfunction isFunction(target) {\n    return typeof target === 'function';\n}\n\nmodule.exports = {\n    isFunction : isFunction,\n    isArray : isArray,\n    each : each\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5xdWlyZS5qcy9zcmMvVXRpbC5qcy5qcyIsIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQSxXQUFXLFlBQVk7QUFDdkI7QUFDQTtBQUNBLG1CQUFtQjtBQUNuQjtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQSxZQUFZLFNBQVM7QUFDckI7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQSxZQUFZLFNBQVM7QUFDckI7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZXMiOlsid2VicGFjazovL19OX0UvLi9ub2RlX21vZHVsZXMvZW5xdWlyZS5qcy9zcmMvVXRpbC5qcz8wMTA1Il0sInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogSGVscGVyIGZ1bmN0aW9uIGZvciBpdGVyYXRpbmcgb3ZlciBhIGNvbGxlY3Rpb25cbiAqXG4gKiBAcGFyYW0gY29sbGVjdGlvblxuICogQHBhcmFtIGZuXG4gKi9cbmZ1bmN0aW9uIGVhY2goY29sbGVjdGlvbiwgZm4pIHtcbiAgICB2YXIgaSAgICAgID0gMCxcbiAgICAgICAgbGVuZ3RoID0gY29sbGVjdGlvbi5sZW5ndGgsXG4gICAgICAgIGNvbnQ7XG5cbiAgICBmb3IoaTsgaSA8IGxlbmd0aDsgaSsrKSB7XG4gICAgICAgIGNvbnQgPSBmbihjb2xsZWN0aW9uW2ldLCBpKTtcbiAgICAgICAgaWYoY29udCA9PT0gZmFsc2UpIHtcbiAgICAgICAgICAgIGJyZWFrOyAvL2FsbG93IGVhcmx5IGV4aXRcbiAgICAgICAgfVxuICAgIH1cbn1cblxuLyoqXG4gKiBIZWxwZXIgZnVuY3Rpb24gZm9yIGRldGVybWluaW5nIHdoZXRoZXIgdGFyZ2V0IG9iamVjdCBpcyBhbiBhcnJheVxuICpcbiAqIEBwYXJhbSB0YXJnZXQgdGhlIG9iamVjdCB1bmRlciB0ZXN0XG4gKiBAcmV0dXJuIHtCb29sZWFufSB0cnVlIGlmIGFycmF5LCBmYWxzZSBvdGhlcndpc2VcbiAqL1xuZnVuY3Rpb24gaXNBcnJheSh0YXJnZXQpIHtcbiAgICByZXR1cm4gT2JqZWN0LnByb3RvdHlwZS50b1N0cmluZy5hcHBseSh0YXJnZXQpID09PSAnW29iamVjdCBBcnJheV0nO1xufVxuXG4vKipcbiAqIEhlbHBlciBmdW5jdGlvbiBmb3IgZGV0ZXJtaW5pbmcgd2hldGhlciB0YXJnZXQgb2JqZWN0IGlzIGEgZnVuY3Rpb25cbiAqXG4gKiBAcGFyYW0gdGFyZ2V0IHRoZSBvYmplY3QgdW5kZXIgdGVzdFxuICogQHJldHVybiB7Qm9vbGVhbn0gdHJ1ZSBpZiBmdW5jdGlvbiwgZmFsc2Ugb3RoZXJ3aXNlXG4gKi9cbmZ1bmN0aW9uIGlzRnVuY3Rpb24odGFyZ2V0KSB7XG4gICAgcmV0dXJuIHR5cGVvZiB0YXJnZXQgPT09ICdmdW5jdGlvbic7XG59XG5cbm1vZHVsZS5leHBvcnRzID0ge1xuICAgIGlzRnVuY3Rpb24gOiBpc0Z1bmN0aW9uLFxuICAgIGlzQXJyYXkgOiBpc0FycmF5LFxuICAgIGVhY2ggOiBlYWNoXG59O1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/enquire.js/src/Util.js\n"));

/***/ }),

/***/ "./node_modules/enquire.js/src/index.js":
/*!**********************************************!*\
  !*** ./node_modules/enquire.js/src/index.js ***!
  \**********************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

eval(__webpack_require__.ts("var MediaQueryDispatch = __webpack_require__(/*! ./MediaQueryDispatch */ \"./node_modules/enquire.js/src/MediaQueryDispatch.js\");\nmodule.exports = new MediaQueryDispatch();\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5xdWlyZS5qcy9zcmMvaW5kZXguanMuanMiLCJtYXBwaW5ncyI6IkFBQUEseUJBQXlCLG1CQUFPLENBQUMsaUZBQXNCO0FBQ3ZEIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vX05fRS8uL25vZGVfbW9kdWxlcy9lbnF1aXJlLmpzL3NyYy9pbmRleC5qcz83YjFiIl0sInNvdXJjZXNDb250ZW50IjpbInZhciBNZWRpYVF1ZXJ5RGlzcGF0Y2ggPSByZXF1aXJlKCcuL01lZGlhUXVlcnlEaXNwYXRjaCcpO1xubW9kdWxlLmV4cG9ydHMgPSBuZXcgTWVkaWFRdWVyeURpc3BhdGNoKCk7XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/enquire.js/src/index.js\n"));

/***/ }),

/***/ "./node_modules/json2mq/index.js":
/*!***************************************!*\
  !*** ./node_modules/json2mq/index.js ***!
  \***************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

eval(__webpack_require__.ts("var camel2hyphen = __webpack_require__(/*! string-convert/camel2hyphen */ \"./node_modules/string-convert/camel2hyphen.js\");\n\nvar isDimension = function (feature) {\n  var re = /[height|width]$/;\n  return re.test(feature);\n};\n\nvar obj2mq = function (obj) {\n  var mq = '';\n  var features = Object.keys(obj);\n  features.forEach(function (feature, index) {\n    var value = obj[feature];\n    feature = camel2hyphen(feature);\n    // Add px to dimension features\n    if (isDimension(feature) && typeof value === 'number') {\n      value = value + 'px';\n    }\n    if (value === true) {\n      mq += feature;\n    } else if (value === false) {\n      mq += 'not ' + feature;\n    } else {\n      mq += '(' + feature + ': ' + value + ')';\n    }\n    if (index < features.length-1) {\n      mq += ' and '\n    }\n  });\n  return mq;\n};\n\nvar json2mq = function (query) {\n  var mq = '';\n  if (typeof query === 'string') {\n    return query;\n  }\n  // Handling array of media queries\n  if (query instanceof Array) {\n    query.forEach(function (q, index) {\n      mq += obj2mq(q);\n      if (index < query.length-1) {\n        mq += ', '\n      }\n    });\n    return mq;\n  }\n  // Handling single media query\n  return obj2mq(query);\n};\n\nmodule.exports = json2mq;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/json2mq/index.js\n"));

/***/ }),

/***/ "./node_modules/lodash.debounce/index.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash.debounce/index.js ***!
  \***********************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

eval(__webpack_require__.ts("/**\n * lodash (Custom Build) <https://lodash.com/>\n * Build: `lodash modularize exports=\"npm\" -o ./`\n * Copyright jQuery Foundation and other contributors <https://jquery.org/>\n * Released under MIT license <https://lodash.com/license>\n * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>\n * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors\n */\n\n/** Used as the `TypeError` message for \"Functions\" methods. */\nvar FUNC_ERROR_TEXT = 'Expected a function';\n\n/** Used as references for various `Number` constants. */\nvar NAN = 0 / 0;\n\n/** `Object#toString` result references. */\nvar symbolTag = '[object Symbol]';\n\n/** Used to match leading and trailing whitespace. */\nvar reTrim = /^\\s+|\\s+$/g;\n\n/** Used to detect bad signed hexadecimal string values. */\nvar reIsBadHex = /^[-+]0x[0-9a-f]+$/i;\n\n/** Used to detect binary string values. */\nvar reIsBinary = /^0b[01]+$/i;\n\n/** Used to detect octal string values. */\nvar reIsOctal = /^0o[0-7]+$/i;\n\n/** Built-in method references without a dependency on `root`. */\nvar freeParseInt = parseInt;\n\n/** Detect free variable `global` from Node.js. */\nvar freeGlobal = typeof __webpack_require__.g == 'object' && __webpack_require__.g && __webpack_require__.g.Object === Object && __webpack_require__.g;\n\n/** Detect free variable `self`. */\nvar freeSelf = typeof self == 'object' && self && self.Object === Object && self;\n\n/** Used as a reference to the global object. */\nvar root = freeGlobal || freeSelf || Function('return this')();\n\n/** Used for built-in method references. */\nvar objectProto = Object.prototype;\n\n/**\n * Used to resolve the\n * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)\n * of values.\n */\nvar objectToString = objectProto.toString;\n\n/* Built-in method references for those with the same name as other `lodash` methods. */\nvar nativeMax = Math.max,\n    nativeMin = Math.min;\n\n/**\n * Gets the timestamp of the number of milliseconds that have elapsed since\n * the Unix epoch (1 January 1970 00:00:00 UTC).\n *\n * @static\n * @memberOf _\n * @since 2.4.0\n * @category Date\n * @returns {number} Returns the timestamp.\n * @example\n *\n * _.defer(function(stamp) {\n *   console.log(_.now() - stamp);\n * }, _.now());\n * // => Logs the number of milliseconds it took for the deferred invocation.\n */\nvar now = function() {\n  return root.Date.now();\n};\n\n/**\n * Creates a debounced function that delays invoking `func` until after `wait`\n * milliseconds have elapsed since the last time the debounced function was\n * invoked. The debounced function comes with a `cancel` method to cancel\n * delayed `func` invocations and a `flush` method to immediately invoke them.\n * Provide `options` to indicate whether `func` should be invoked on the\n * leading and/or trailing edge of the `wait` timeout. The `func` is invoked\n * with the last arguments provided to the debounced function. Subsequent\n * calls to the debounced function return the result of the last `func`\n * invocation.\n *\n * **Note:** If `leading` and `trailing` options are `true`, `func` is\n * invoked on the trailing edge of the timeout only if the debounced function\n * is invoked more than once during the `wait` timeout.\n *\n * If `wait` is `0` and `leading` is `false`, `func` invocation is deferred\n * until to the next tick, similar to `setTimeout` with a timeout of `0`.\n *\n * See [David Corbacho's article](https://css-tricks.com/debouncing-throttling-explained-examples/)\n * for details over the differences between `_.debounce` and `_.throttle`.\n *\n * @static\n * @memberOf _\n * @since 0.1.0\n * @category Function\n * @param {Function} func The function to debounce.\n * @param {number} [wait=0] The number of milliseconds to delay.\n * @param {Object} [options={}] The options object.\n * @param {boolean} [options.leading=false]\n *  Specify invoking on the leading edge of the timeout.\n * @param {number} [options.maxWait]\n *  The maximum time `func` is allowed to be delayed before it's invoked.\n * @param {boolean} [options.trailing=true]\n *  Specify invoking on the trailing edge of the timeout.\n * @returns {Function} Returns the new debounced function.\n * @example\n *\n * // Avoid costly calculations while the window size is in flux.\n * jQuery(window).on('resize', _.debounce(calculateLayout, 150));\n *\n * // Invoke `sendMail` when clicked, debouncing subsequent calls.\n * jQuery(element).on('click', _.debounce(sendMail, 300, {\n *   'leading': true,\n *   'trailing': false\n * }));\n *\n * // Ensure `batchLog` is invoked once after 1 second of debounced calls.\n * var debounced = _.debounce(batchLog, 250, { 'maxWait': 1000 });\n * var source = new EventSource('/stream');\n * jQuery(source).on('message', debounced);\n *\n * // Cancel the trailing debounced invocation.\n * jQuery(window).on('popstate', debounced.cancel);\n */\nfunction debounce(func, wait, options) {\n  var lastArgs,\n      lastThis,\n      maxWait,\n      result,\n      timerId,\n      lastCallTime,\n      lastInvokeTime = 0,\n      leading = false,\n      maxing = false,\n      trailing = true;\n\n  if (typeof func != 'function') {\n    throw new TypeError(FUNC_ERROR_TEXT);\n  }\n  wait = toNumber(wait) || 0;\n  if (isObject(options)) {\n    leading = !!options.leading;\n    maxing = 'maxWait' in options;\n    maxWait = maxing ? nativeMax(toNumber(options.maxWait) || 0, wait) : maxWait;\n    trailing = 'trailing' in options ? !!options.trailing : trailing;\n  }\n\n  function invokeFunc(time) {\n    var args = lastArgs,\n        thisArg = lastThis;\n\n    lastArgs = lastThis = undefined;\n    lastInvokeTime = time;\n    result = func.apply(thisArg, args);\n    return result;\n  }\n\n  function leadingEdge(time) {\n    // Reset any `maxWait` timer.\n    lastInvokeTime = time;\n    // Start the timer for the trailing edge.\n    timerId = setTimeout(timerExpired, wait);\n    // Invoke the leading edge.\n    return leading ? invokeFunc(time) : result;\n  }\n\n  function remainingWait(time) {\n    var timeSinceLastCall = time - lastCallTime,\n        timeSinceLastInvoke = time - lastInvokeTime,\n        result = wait - timeSinceLastCall;\n\n    return maxing ? nativeMin(result, maxWait - timeSinceLastInvoke) : result;\n  }\n\n  function shouldInvoke(time) {\n    var timeSinceLastCall = time - lastCallTime,\n        timeSinceLastInvoke = time - lastInvokeTime;\n\n    // Either this is the first call, activity has stopped and we're at the\n    // trailing edge, the system time has gone backwards and we're treating\n    // it as the trailing edge, or we've hit the `maxWait` limit.\n    return (lastCallTime === undefined || (timeSinceLastCall >= wait) ||\n      (timeSinceLastCall < 0) || (maxing && timeSinceLastInvoke >= maxWait));\n  }\n\n  function timerExpired() {\n    var time = now();\n    if (shouldInvoke(time)) {\n      return trailingEdge(time);\n    }\n    // Restart the timer.\n    timerId = setTimeout(timerExpired, remainingWait(time));\n  }\n\n  function trailingEdge(time) {\n    timerId = undefined;\n\n    // Only invoke if we have `lastArgs` which means `func` has been\n    // debounced at least once.\n    if (trailing && lastArgs) {\n      return invokeFunc(time);\n    }\n    lastArgs = lastThis = undefined;\n    return result;\n  }\n\n  function cancel() {\n    if (timerId !== undefined) {\n      clearTimeout(timerId);\n    }\n    lastInvokeTime = 0;\n    lastArgs = lastCallTime = lastThis = timerId = undefined;\n  }\n\n  function flush() {\n    return timerId === undefined ? result : trailingEdge(now());\n  }\n\n  function debounced() {\n    var time = now(),\n        isInvoking = shouldInvoke(time);\n\n    lastArgs = arguments;\n    lastThis = this;\n    lastCallTime = time;\n\n    if (isInvoking) {\n      if (timerId === undefined) {\n        return leadingEdge(lastCallTime);\n      }\n      if (maxing) {\n        // Handle invocations in a tight loop.\n        timerId = setTimeout(timerExpired, wait);\n        return invokeFunc(lastCallTime);\n      }\n    }\n    if (timerId === undefined) {\n      timerId = setTimeout(timerExpired, wait);\n    }\n    return result;\n  }\n  debounced.cancel = cancel;\n  debounced.flush = flush;\n  return debounced;\n}\n\n/**\n * Checks if `value` is the\n * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)\n * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)\n *\n * @static\n * @memberOf _\n * @since 0.1.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is an object, else `false`.\n * @example\n *\n * _.isObject({});\n * // => true\n *\n * _.isObject([1, 2, 3]);\n * // => true\n *\n * _.isObject(_.noop);\n * // => true\n *\n * _.isObject(null);\n * // => false\n */\nfunction isObject(value) {\n  var type = typeof value;\n  return !!value && (type == 'object' || type == 'function');\n}\n\n/**\n * Checks if `value` is object-like. A value is object-like if it's not `null`\n * and has a `typeof` result of \"object\".\n *\n * @static\n * @memberOf _\n * @since 4.0.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is object-like, else `false`.\n * @example\n *\n * _.isObjectLike({});\n * // => true\n *\n * _.isObjectLike([1, 2, 3]);\n * // => true\n *\n * _.isObjectLike(_.noop);\n * // => false\n *\n * _.isObjectLike(null);\n * // => false\n */\nfunction isObjectLike(value) {\n  return !!value && typeof value == 'object';\n}\n\n/**\n * Checks if `value` is classified as a `Symbol` primitive or object.\n *\n * @static\n * @memberOf _\n * @since 4.0.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.\n * @example\n *\n * _.isSymbol(Symbol.iterator);\n * // => true\n *\n * _.isSymbol('abc');\n * // => false\n */\nfunction isSymbol(value) {\n  return typeof value == 'symbol' ||\n    (isObjectLike(value) && objectToString.call(value) == symbolTag);\n}\n\n/**\n * Converts `value` to a number.\n *\n * @static\n * @memberOf _\n * @since 4.0.0\n * @category Lang\n * @param {*} value The value to process.\n * @returns {number} Returns the number.\n * @example\n *\n * _.toNumber(3.2);\n * // => 3.2\n *\n * _.toNumber(Number.MIN_VALUE);\n * // => 5e-324\n *\n * _.toNumber(Infinity);\n * // => Infinity\n *\n * _.toNumber('3.2');\n * // => 3.2\n */\nfunction toNumber(value) {\n  if (typeof value == 'number') {\n    return value;\n  }\n  if (isSymbol(value)) {\n    return NAN;\n  }\n  if (isObject(value)) {\n    var other = typeof value.valueOf == 'function' ? value.valueOf() : value;\n    value = isObject(other) ? (other + '') : other;\n  }\n  if (typeof value != 'string') {\n    return value === 0 ? value : +value;\n  }\n  value = value.replace(reTrim, '');\n  var isBinary = reIsBinary.test(value);\n  return (isBinary || reIsOctal.test(value))\n    ? freeParseInt(value.slice(2), isBinary ? 2 : 8)\n    : (reIsBadHex.test(value) ? NAN : +value);\n}\n\nmodule.exports = debounce;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/lodash.debounce/index.js\n"));

/***/ }),

/***/ "./node_modules/react-slick/lib/arrows.js":
/*!************************************************!*\
  !*** ./node_modules/react-slick/lib/arrows.js ***!
  \************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval(__webpack_require__.ts("\n\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\n\nObject.defineProperty(exports, \"__esModule\", ({\n  value: true\n}));\nexports.PrevArrow = exports.NextArrow = void 0;\n\nvar _react = _interopRequireDefault(__webpack_require__(/*! react */ \"./node_modules/react/index.js\"));\n\nvar _classnames = _interopRequireDefault(__webpack_require__(/*! classnames */ \"./node_modules/classnames/index.js\"));\n\nvar _innerSliderUtils = __webpack_require__(/*! ./utils/innerSliderUtils */ \"./node_modules/react-slick/lib/utils/innerSliderUtils.js\");\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { \"default\": obj }; }\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\n\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\n\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\n\nvar PrevArrow = /*#__PURE__*/function (_React$PureComponent) {\n  _inherits(PrevArrow, _React$PureComponent);\n\n  var _super = _createSuper(PrevArrow);\n\n  function PrevArrow() {\n    _classCallCheck(this, PrevArrow);\n\n    return _super.apply(this, arguments);\n  }\n\n  _createClass(PrevArrow, [{\n    key: \"clickHandler\",\n    value: function clickHandler(options, e) {\n      if (e) {\n        e.preventDefault();\n      }\n\n      this.props.clickHandler(options, e);\n    }\n  }, {\n    key: \"render\",\n    value: function render() {\n      var prevClasses = {\n        \"slick-arrow\": true,\n        \"slick-prev\": true\n      };\n      var prevHandler = this.clickHandler.bind(this, {\n        message: \"previous\"\n      });\n\n      if (!this.props.infinite && (this.props.currentSlide === 0 || this.props.slideCount <= this.props.slidesToShow)) {\n        prevClasses[\"slick-disabled\"] = true;\n        prevHandler = null;\n      }\n\n      var prevArrowProps = {\n        key: \"0\",\n        \"data-role\": \"none\",\n        className: (0, _classnames[\"default\"])(prevClasses),\n        style: {\n          display: \"block\"\n        },\n        onClick: prevHandler\n      };\n      var customProps = {\n        currentSlide: this.props.currentSlide,\n        slideCount: this.props.slideCount\n      };\n      var prevArrow;\n\n      if (this.props.prevArrow) {\n        prevArrow = /*#__PURE__*/_react[\"default\"].cloneElement(this.props.prevArrow, _objectSpread(_objectSpread({}, prevArrowProps), customProps));\n      } else {\n        prevArrow = /*#__PURE__*/_react[\"default\"].createElement(\"button\", _extends({\n          key: \"0\",\n          type: \"button\"\n        }, prevArrowProps), \" \", \"Previous\");\n      }\n\n      return prevArrow;\n    }\n  }]);\n\n  return PrevArrow;\n}(_react[\"default\"].PureComponent);\n\nexports.PrevArrow = PrevArrow;\n\nvar NextArrow = /*#__PURE__*/function (_React$PureComponent2) {\n  _inherits(NextArrow, _React$PureComponent2);\n\n  var _super2 = _createSuper(NextArrow);\n\n  function NextArrow() {\n    _classCallCheck(this, NextArrow);\n\n    return _super2.apply(this, arguments);\n  }\n\n  _createClass(NextArrow, [{\n    key: \"clickHandler\",\n    value: function clickHandler(options, e) {\n      if (e) {\n        e.preventDefault();\n      }\n\n      this.props.clickHandler(options, e);\n    }\n  }, {\n    key: \"render\",\n    value: function render() {\n      var nextClasses = {\n        \"slick-arrow\": true,\n        \"slick-next\": true\n      };\n      var nextHandler = this.clickHandler.bind(this, {\n        message: \"next\"\n      });\n\n      if (!(0, _innerSliderUtils.canGoNext)(this.props)) {\n        nextClasses[\"slick-disabled\"] = true;\n        nextHandler = null;\n      }\n\n      var nextArrowProps = {\n        key: \"1\",\n        \"data-role\": \"none\",\n        className: (0, _classnames[\"default\"])(nextClasses),\n        style: {\n          display: \"block\"\n        },\n        onClick: nextHandler\n      };\n      var customProps = {\n        currentSlide: this.props.currentSlide,\n        slideCount: this.props.slideCount\n      };\n      var nextArrow;\n\n      if (this.props.nextArrow) {\n        nextArrow = /*#__PURE__*/_react[\"default\"].cloneElement(this.props.nextArrow, _objectSpread(_objectSpread({}, nextArrowProps), customProps));\n      } else {\n        nextArrow = /*#__PURE__*/_react[\"default\"].createElement(\"button\", _extends({\n          key: \"1\",\n          type: \"button\"\n        }, nextArrowProps), \" \", \"Next\");\n      }\n\n      return nextArrow;\n    }\n  }]);\n\n  return NextArrow;\n}(_react[\"default\"].PureComponent);\n\nexports.NextArrow = NextArrow;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/react-slick/lib/arrows.js\n"));

/***/ }),

/***/ "./node_modules/react-slick/lib/default-props.js":
/*!*******************************************************!*\
  !*** ./node_modules/react-slick/lib/default-props.js ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval(__webpack_require__.ts("\n\nObject.defineProperty(exports, \"__esModule\", ({\n  value: true\n}));\nexports[\"default\"] = void 0;\n\nvar _react = _interopRequireDefault(__webpack_require__(/*! react */ \"./node_modules/react/index.js\"));\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { \"default\": obj }; }\n\nvar defaultProps = {\n  accessibility: true,\n  adaptiveHeight: false,\n  afterChange: null,\n  appendDots: function appendDots(dots) {\n    return /*#__PURE__*/_react[\"default\"].createElement(\"ul\", {\n      style: {\n        display: \"block\"\n      }\n    }, dots);\n  },\n  arrows: true,\n  autoplay: false,\n  autoplaySpeed: 3000,\n  beforeChange: null,\n  centerMode: false,\n  centerPadding: \"50px\",\n  className: \"\",\n  cssEase: \"ease\",\n  customPaging: function customPaging(i) {\n    return /*#__PURE__*/_react[\"default\"].createElement(\"button\", null, i + 1);\n  },\n  dots: false,\n  dotsClass: \"slick-dots\",\n  draggable: true,\n  easing: \"linear\",\n  edgeFriction: 0.35,\n  fade: false,\n  focusOnSelect: false,\n  infinite: true,\n  initialSlide: 0,\n  lazyLoad: null,\n  nextArrow: null,\n  onEdge: null,\n  onInit: null,\n  onLazyLoadError: null,\n  onReInit: null,\n  pauseOnDotsHover: false,\n  pauseOnFocus: false,\n  pauseOnHover: true,\n  prevArrow: null,\n  responsive: null,\n  rows: 1,\n  rtl: false,\n  slide: \"div\",\n  slidesPerRow: 1,\n  slidesToScroll: 1,\n  slidesToShow: 1,\n  speed: 500,\n  swipe: true,\n  swipeEvent: null,\n  swipeToSlide: false,\n  touchMove: true,\n  touchThreshold: 5,\n  useCSS: true,\n  useTransform: true,\n  variableWidth: false,\n  vertical: false,\n  waitForAnimate: true\n};\nvar _default = defaultProps;\nexports[\"default\"] = _default;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/react-slick/lib/default-props.js\n"));

/***/ }),

/***/ "./node_modules/react-slick/lib/dots.js":
/*!**********************************************!*\
  !*** ./node_modules/react-slick/lib/dots.js ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval(__webpack_require__.ts("\n\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\n\nObject.defineProperty(exports, \"__esModule\", ({\n  value: true\n}));\nexports.Dots = void 0;\n\nvar _react = _interopRequireDefault(__webpack_require__(/*! react */ \"./node_modules/react/index.js\"));\n\nvar _classnames = _interopRequireDefault(__webpack_require__(/*! classnames */ \"./node_modules/classnames/index.js\"));\n\nvar _innerSliderUtils = __webpack_require__(/*! ./utils/innerSliderUtils */ \"./node_modules/react-slick/lib/utils/innerSliderUtils.js\");\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { \"default\": obj }; }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\n\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\n\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\n\nvar getDotCount = function getDotCount(spec) {\n  var dots;\n\n  if (spec.infinite) {\n    dots = Math.ceil(spec.slideCount / spec.slidesToScroll);\n  } else {\n    dots = Math.ceil((spec.slideCount - spec.slidesToShow) / spec.slidesToScroll) + 1;\n  }\n\n  return dots;\n};\n\nvar Dots = /*#__PURE__*/function (_React$PureComponent) {\n  _inherits(Dots, _React$PureComponent);\n\n  var _super = _createSuper(Dots);\n\n  function Dots() {\n    _classCallCheck(this, Dots);\n\n    return _super.apply(this, arguments);\n  }\n\n  _createClass(Dots, [{\n    key: \"clickHandler\",\n    value: function clickHandler(options, e) {\n      // In Autoplay the focus stays on clicked button even after transition\n      // to next slide. That only goes away by click somewhere outside\n      e.preventDefault();\n      this.props.clickHandler(options);\n    }\n  }, {\n    key: \"render\",\n    value: function render() {\n      var _this$props = this.props,\n          onMouseEnter = _this$props.onMouseEnter,\n          onMouseOver = _this$props.onMouseOver,\n          onMouseLeave = _this$props.onMouseLeave,\n          infinite = _this$props.infinite,\n          slidesToScroll = _this$props.slidesToScroll,\n          slidesToShow = _this$props.slidesToShow,\n          slideCount = _this$props.slideCount,\n          currentSlide = _this$props.currentSlide;\n      var dotCount = getDotCount({\n        slideCount: slideCount,\n        slidesToScroll: slidesToScroll,\n        slidesToShow: slidesToShow,\n        infinite: infinite\n      });\n      var mouseEvents = {\n        onMouseEnter: onMouseEnter,\n        onMouseOver: onMouseOver,\n        onMouseLeave: onMouseLeave\n      };\n      var dots = [];\n\n      for (var i = 0; i < dotCount; i++) {\n        var _rightBound = (i + 1) * slidesToScroll - 1;\n\n        var rightBound = infinite ? _rightBound : (0, _innerSliderUtils.clamp)(_rightBound, 0, slideCount - 1);\n\n        var _leftBound = rightBound - (slidesToScroll - 1);\n\n        var leftBound = infinite ? _leftBound : (0, _innerSliderUtils.clamp)(_leftBound, 0, slideCount - 1);\n        var className = (0, _classnames[\"default\"])({\n          \"slick-active\": infinite ? currentSlide >= leftBound && currentSlide <= rightBound : currentSlide === leftBound\n        });\n        var dotOptions = {\n          message: \"dots\",\n          index: i,\n          slidesToScroll: slidesToScroll,\n          currentSlide: currentSlide\n        };\n        var onClick = this.clickHandler.bind(this, dotOptions);\n        dots = dots.concat( /*#__PURE__*/_react[\"default\"].createElement(\"li\", {\n          key: i,\n          className: className\n        }, /*#__PURE__*/_react[\"default\"].cloneElement(this.props.customPaging(i), {\n          onClick: onClick\n        })));\n      }\n\n      return /*#__PURE__*/_react[\"default\"].cloneElement(this.props.appendDots(dots), _objectSpread({\n        className: this.props.dotsClass\n      }, mouseEvents));\n    }\n  }]);\n\n  return Dots;\n}(_react[\"default\"].PureComponent);\n\nexports.Dots = Dots;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/react-slick/lib/dots.js\n"));

/***/ }),

/***/ "./node_modules/react-slick/lib/index.js":
/*!***********************************************!*\
  !*** ./node_modules/react-slick/lib/index.js ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval(__webpack_require__.ts("\n\nObject.defineProperty(exports, \"__esModule\", ({\n  value: true\n}));\nexports[\"default\"] = void 0;\n\nvar _slider = _interopRequireDefault(__webpack_require__(/*! ./slider */ \"./node_modules/react-slick/lib/slider.js\"));\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { \"default\": obj }; }\n\nvar _default = _slider[\"default\"];\nexports[\"default\"] = _default;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvcmVhY3Qtc2xpY2svbGliL2luZGV4LmpzLmpzIiwibWFwcGluZ3MiOiJBQUFhOztBQUViLDhDQUE2QztBQUM3QztBQUNBLENBQUMsRUFBQztBQUNGLGtCQUFrQjs7QUFFbEIscUNBQXFDLG1CQUFPLENBQUMsMERBQVU7O0FBRXZELHVDQUF1Qyx1Q0FBdUM7O0FBRTlFO0FBQ0Esa0JBQWtCIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vX05fRS8uL25vZGVfbW9kdWxlcy9yZWFjdC1zbGljay9saWIvaW5kZXguanM/YTA3NCJdLCJzb3VyY2VzQ29udGVudCI6WyJcInVzZSBzdHJpY3RcIjtcblxuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7XG4gIHZhbHVlOiB0cnVlXG59KTtcbmV4cG9ydHNbXCJkZWZhdWx0XCJdID0gdm9pZCAwO1xuXG52YXIgX3NsaWRlciA9IF9pbnRlcm9wUmVxdWlyZURlZmF1bHQocmVxdWlyZShcIi4vc2xpZGVyXCIpKTtcblxuZnVuY3Rpb24gX2ludGVyb3BSZXF1aXJlRGVmYXVsdChvYmopIHsgcmV0dXJuIG9iaiAmJiBvYmouX19lc01vZHVsZSA/IG9iaiA6IHsgXCJkZWZhdWx0XCI6IG9iaiB9OyB9XG5cbnZhciBfZGVmYXVsdCA9IF9zbGlkZXJbXCJkZWZhdWx0XCJdO1xuZXhwb3J0c1tcImRlZmF1bHRcIl0gPSBfZGVmYXVsdDsiXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/react-slick/lib/index.js\n"));

/***/ }),

/***/ "./node_modules/react-slick/lib/initial-state.js":
/*!*******************************************************!*\
  !*** ./node_modules/react-slick/lib/initial-state.js ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval(__webpack_require__.ts("\n\nObject.defineProperty(exports, \"__esModule\", ({\n  value: true\n}));\nexports[\"default\"] = void 0;\nvar initialState = {\n  animating: false,\n  autoplaying: null,\n  currentDirection: 0,\n  currentLeft: null,\n  currentSlide: 0,\n  direction: 1,\n  dragging: false,\n  edgeDragged: false,\n  initialized: false,\n  lazyLoadedList: [],\n  listHeight: null,\n  listWidth: null,\n  scrolling: false,\n  slideCount: null,\n  slideHeight: null,\n  slideWidth: null,\n  swipeLeft: null,\n  swiped: false,\n  // used by swipeEvent. differentites between touch and swipe.\n  swiping: false,\n  touchObject: {\n    startX: 0,\n    startY: 0,\n    curX: 0,\n    curY: 0\n  },\n  trackStyle: {},\n  trackWidth: 0,\n  targetSlide: 0\n};\nvar _default = initialState;\nexports[\"default\"] = _default;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvcmVhY3Qtc2xpY2svbGliL2luaXRpYWwtc3RhdGUuanMuanMiLCJtYXBwaW5ncyI6IkFBQWE7O0FBRWIsOENBQTZDO0FBQzdDO0FBQ0EsQ0FBQyxFQUFDO0FBQ0Ysa0JBQWtCO0FBQ2xCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0gsZ0JBQWdCO0FBQ2hCO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esa0JBQWtCIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vX05fRS8uL25vZGVfbW9kdWxlcy9yZWFjdC1zbGljay9saWIvaW5pdGlhbC1zdGF0ZS5qcz82MzU2Il0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuXG5PYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywgXCJfX2VzTW9kdWxlXCIsIHtcbiAgdmFsdWU6IHRydWVcbn0pO1xuZXhwb3J0c1tcImRlZmF1bHRcIl0gPSB2b2lkIDA7XG52YXIgaW5pdGlhbFN0YXRlID0ge1xuICBhbmltYXRpbmc6IGZhbHNlLFxuICBhdXRvcGxheWluZzogbnVsbCxcbiAgY3VycmVudERpcmVjdGlvbjogMCxcbiAgY3VycmVudExlZnQ6IG51bGwsXG4gIGN1cnJlbnRTbGlkZTogMCxcbiAgZGlyZWN0aW9uOiAxLFxuICBkcmFnZ2luZzogZmFsc2UsXG4gIGVkZ2VEcmFnZ2VkOiBmYWxzZSxcbiAgaW5pdGlhbGl6ZWQ6IGZhbHNlLFxuICBsYXp5TG9hZGVkTGlzdDogW10sXG4gIGxpc3RIZWlnaHQ6IG51bGwsXG4gIGxpc3RXaWR0aDogbnVsbCxcbiAgc2Nyb2xsaW5nOiBmYWxzZSxcbiAgc2xpZGVDb3VudDogbnVsbCxcbiAgc2xpZGVIZWlnaHQ6IG51bGwsXG4gIHNsaWRlV2lkdGg6IG51bGwsXG4gIHN3aXBlTGVmdDogbnVsbCxcbiAgc3dpcGVkOiBmYWxzZSxcbiAgLy8gdXNlZCBieSBzd2lwZUV2ZW50LiBkaWZmZXJlbnRpdGVzIGJldHdlZW4gdG91Y2ggYW5kIHN3aXBlLlxuICBzd2lwaW5nOiBmYWxzZSxcbiAgdG91Y2hPYmplY3Q6IHtcbiAgICBzdGFydFg6IDAsXG4gICAgc3RhcnRZOiAwLFxuICAgIGN1clg6IDAsXG4gICAgY3VyWTogMFxuICB9LFxuICB0cmFja1N0eWxlOiB7fSxcbiAgdHJhY2tXaWR0aDogMCxcbiAgdGFyZ2V0U2xpZGU6IDBcbn07XG52YXIgX2RlZmF1bHQgPSBpbml0aWFsU3RhdGU7XG5leHBvcnRzW1wiZGVmYXVsdFwiXSA9IF9kZWZhdWx0OyJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/react-slick/lib/initial-state.js\n"));

/***/ }),

/***/ "./node_modules/react-slick/lib/inner-slider.js":
/*!******************************************************!*\
  !*** ./node_modules/react-slick/lib/inner-slider.js ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval(__webpack_require__.ts("\n\nObject.defineProperty(exports, \"__esModule\", ({\n  value: true\n}));\nexports.InnerSlider = void 0;\n\nvar _react = _interopRequireDefault(__webpack_require__(/*! react */ \"./node_modules/react/index.js\"));\n\nvar _initialState = _interopRequireDefault(__webpack_require__(/*! ./initial-state */ \"./node_modules/react-slick/lib/initial-state.js\"));\n\nvar _lodash = _interopRequireDefault(__webpack_require__(/*! lodash.debounce */ \"./node_modules/lodash.debounce/index.js\"));\n\nvar _classnames = _interopRequireDefault(__webpack_require__(/*! classnames */ \"./node_modules/classnames/index.js\"));\n\nvar _innerSliderUtils = __webpack_require__(/*! ./utils/innerSliderUtils */ \"./node_modules/react-slick/lib/utils/innerSliderUtils.js\");\n\nvar _track = __webpack_require__(/*! ./track */ \"./node_modules/react-slick/lib/track.js\");\n\nvar _dots = __webpack_require__(/*! ./dots */ \"./node_modules/react-slick/lib/dots.js\");\n\nvar _arrows = __webpack_require__(/*! ./arrows */ \"./node_modules/react-slick/lib/arrows.js\");\n\nvar _resizeObserverPolyfill = _interopRequireDefault(__webpack_require__(/*! resize-observer-polyfill */ \"./node_modules/resize-observer-polyfill/dist/ResizeObserver.es.js\"));\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { \"default\": obj }; }\n\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }\n\nfunction _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\n\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\n\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nvar InnerSlider = /*#__PURE__*/function (_React$Component) {\n  _inherits(InnerSlider, _React$Component);\n\n  var _super = _createSuper(InnerSlider);\n\n  function InnerSlider(props) {\n    var _this;\n\n    _classCallCheck(this, InnerSlider);\n\n    _this = _super.call(this, props);\n\n    _defineProperty(_assertThisInitialized(_this), \"listRefHandler\", function (ref) {\n      return _this.list = ref;\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"trackRefHandler\", function (ref) {\n      return _this.track = ref;\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"adaptHeight\", function () {\n      if (_this.props.adaptiveHeight && _this.list) {\n        var elem = _this.list.querySelector(\"[data-index=\\\"\".concat(_this.state.currentSlide, \"\\\"]\"));\n\n        _this.list.style.height = (0, _innerSliderUtils.getHeight)(elem) + \"px\";\n      }\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"componentDidMount\", function () {\n      _this.props.onInit && _this.props.onInit();\n\n      if (_this.props.lazyLoad) {\n        var slidesToLoad = (0, _innerSliderUtils.getOnDemandLazySlides)(_objectSpread(_objectSpread({}, _this.props), _this.state));\n\n        if (slidesToLoad.length > 0) {\n          _this.setState(function (prevState) {\n            return {\n              lazyLoadedList: prevState.lazyLoadedList.concat(slidesToLoad)\n            };\n          });\n\n          if (_this.props.onLazyLoad) {\n            _this.props.onLazyLoad(slidesToLoad);\n          }\n        }\n      }\n\n      var spec = _objectSpread({\n        listRef: _this.list,\n        trackRef: _this.track\n      }, _this.props);\n\n      _this.updateState(spec, true, function () {\n        _this.adaptHeight();\n\n        _this.props.autoplay && _this.autoPlay(\"update\");\n      });\n\n      if (_this.props.lazyLoad === \"progressive\") {\n        _this.lazyLoadTimer = setInterval(_this.progressiveLazyLoad, 1000);\n      }\n\n      _this.ro = new _resizeObserverPolyfill[\"default\"](function () {\n        if (_this.state.animating) {\n          _this.onWindowResized(false); // don't set trackStyle hence don't break animation\n\n\n          _this.callbackTimers.push(setTimeout(function () {\n            return _this.onWindowResized();\n          }, _this.props.speed));\n        } else {\n          _this.onWindowResized();\n        }\n      });\n\n      _this.ro.observe(_this.list);\n\n      document.querySelectorAll && Array.prototype.forEach.call(document.querySelectorAll(\".slick-slide\"), function (slide) {\n        slide.onfocus = _this.props.pauseOnFocus ? _this.onSlideFocus : null;\n        slide.onblur = _this.props.pauseOnFocus ? _this.onSlideBlur : null;\n      });\n\n      if (window.addEventListener) {\n        window.addEventListener(\"resize\", _this.onWindowResized);\n      } else {\n        window.attachEvent(\"onresize\", _this.onWindowResized);\n      }\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"componentWillUnmount\", function () {\n      if (_this.animationEndCallback) {\n        clearTimeout(_this.animationEndCallback);\n      }\n\n      if (_this.lazyLoadTimer) {\n        clearInterval(_this.lazyLoadTimer);\n      }\n\n      if (_this.callbackTimers.length) {\n        _this.callbackTimers.forEach(function (timer) {\n          return clearTimeout(timer);\n        });\n\n        _this.callbackTimers = [];\n      }\n\n      if (window.addEventListener) {\n        window.removeEventListener(\"resize\", _this.onWindowResized);\n      } else {\n        window.detachEvent(\"onresize\", _this.onWindowResized);\n      }\n\n      if (_this.autoplayTimer) {\n        clearInterval(_this.autoplayTimer);\n      }\n\n      _this.ro.disconnect();\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"componentDidUpdate\", function (prevProps) {\n      _this.checkImagesLoad();\n\n      _this.props.onReInit && _this.props.onReInit();\n\n      if (_this.props.lazyLoad) {\n        var slidesToLoad = (0, _innerSliderUtils.getOnDemandLazySlides)(_objectSpread(_objectSpread({}, _this.props), _this.state));\n\n        if (slidesToLoad.length > 0) {\n          _this.setState(function (prevState) {\n            return {\n              lazyLoadedList: prevState.lazyLoadedList.concat(slidesToLoad)\n            };\n          });\n\n          if (_this.props.onLazyLoad) {\n            _this.props.onLazyLoad(slidesToLoad);\n          }\n        }\n      } // if (this.props.onLazyLoad) {\n      //   this.props.onLazyLoad([leftMostSlide])\n      // }\n\n\n      _this.adaptHeight();\n\n      var spec = _objectSpread(_objectSpread({\n        listRef: _this.list,\n        trackRef: _this.track\n      }, _this.props), _this.state);\n\n      var setTrackStyle = _this.didPropsChange(prevProps);\n\n      setTrackStyle && _this.updateState(spec, setTrackStyle, function () {\n        if (_this.state.currentSlide >= _react[\"default\"].Children.count(_this.props.children)) {\n          _this.changeSlide({\n            message: \"index\",\n            index: _react[\"default\"].Children.count(_this.props.children) - _this.props.slidesToShow,\n            currentSlide: _this.state.currentSlide\n          });\n        }\n\n        if (_this.props.autoplay) {\n          _this.autoPlay(\"update\");\n        } else {\n          _this.pause(\"paused\");\n        }\n      });\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"onWindowResized\", function (setTrackStyle) {\n      if (_this.debouncedResize) _this.debouncedResize.cancel();\n      _this.debouncedResize = (0, _lodash[\"default\"])(function () {\n        return _this.resizeWindow(setTrackStyle);\n      }, 50);\n\n      _this.debouncedResize();\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"resizeWindow\", function () {\n      var setTrackStyle = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;\n      var isTrackMounted = Boolean(_this.track && _this.track.node); // prevent warning: setting state on unmounted component (server side rendering)\n\n      if (!isTrackMounted) return;\n\n      var spec = _objectSpread(_objectSpread({\n        listRef: _this.list,\n        trackRef: _this.track\n      }, _this.props), _this.state);\n\n      _this.updateState(spec, setTrackStyle, function () {\n        if (_this.props.autoplay) _this.autoPlay(\"update\");else _this.pause(\"paused\");\n      }); // animating state should be cleared while resizing, otherwise autoplay stops working\n\n\n      _this.setState({\n        animating: false\n      });\n\n      clearTimeout(_this.animationEndCallback);\n      delete _this.animationEndCallback;\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"updateState\", function (spec, setTrackStyle, callback) {\n      var updatedState = (0, _innerSliderUtils.initializedState)(spec);\n      spec = _objectSpread(_objectSpread(_objectSpread({}, spec), updatedState), {}, {\n        slideIndex: updatedState.currentSlide\n      });\n      var targetLeft = (0, _innerSliderUtils.getTrackLeft)(spec);\n      spec = _objectSpread(_objectSpread({}, spec), {}, {\n        left: targetLeft\n      });\n      var trackStyle = (0, _innerSliderUtils.getTrackCSS)(spec);\n\n      if (setTrackStyle || _react[\"default\"].Children.count(_this.props.children) !== _react[\"default\"].Children.count(spec.children)) {\n        updatedState[\"trackStyle\"] = trackStyle;\n      }\n\n      _this.setState(updatedState, callback);\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"ssrInit\", function () {\n      if (_this.props.variableWidth) {\n        var _trackWidth = 0,\n            _trackLeft = 0;\n        var childrenWidths = [];\n        var preClones = (0, _innerSliderUtils.getPreClones)(_objectSpread(_objectSpread(_objectSpread({}, _this.props), _this.state), {}, {\n          slideCount: _this.props.children.length\n        }));\n        var postClones = (0, _innerSliderUtils.getPostClones)(_objectSpread(_objectSpread(_objectSpread({}, _this.props), _this.state), {}, {\n          slideCount: _this.props.children.length\n        }));\n\n        _this.props.children.forEach(function (child) {\n          childrenWidths.push(child.props.style.width);\n          _trackWidth += child.props.style.width;\n        });\n\n        for (var i = 0; i < preClones; i++) {\n          _trackLeft += childrenWidths[childrenWidths.length - 1 - i];\n          _trackWidth += childrenWidths[childrenWidths.length - 1 - i];\n        }\n\n        for (var _i = 0; _i < postClones; _i++) {\n          _trackWidth += childrenWidths[_i];\n        }\n\n        for (var _i2 = 0; _i2 < _this.state.currentSlide; _i2++) {\n          _trackLeft += childrenWidths[_i2];\n        }\n\n        var _trackStyle = {\n          width: _trackWidth + \"px\",\n          left: -_trackLeft + \"px\"\n        };\n\n        if (_this.props.centerMode) {\n          var currentWidth = \"\".concat(childrenWidths[_this.state.currentSlide], \"px\");\n          _trackStyle.left = \"calc(\".concat(_trackStyle.left, \" + (100% - \").concat(currentWidth, \") / 2 ) \");\n        }\n\n        return {\n          trackStyle: _trackStyle\n        };\n      }\n\n      var childrenCount = _react[\"default\"].Children.count(_this.props.children);\n\n      var spec = _objectSpread(_objectSpread(_objectSpread({}, _this.props), _this.state), {}, {\n        slideCount: childrenCount\n      });\n\n      var slideCount = (0, _innerSliderUtils.getPreClones)(spec) + (0, _innerSliderUtils.getPostClones)(spec) + childrenCount;\n      var trackWidth = 100 / _this.props.slidesToShow * slideCount;\n      var slideWidth = 100 / slideCount;\n      var trackLeft = -slideWidth * ((0, _innerSliderUtils.getPreClones)(spec) + _this.state.currentSlide) * trackWidth / 100;\n\n      if (_this.props.centerMode) {\n        trackLeft += (100 - slideWidth * trackWidth / 100) / 2;\n      }\n\n      var trackStyle = {\n        width: trackWidth + \"%\",\n        left: trackLeft + \"%\"\n      };\n      return {\n        slideWidth: slideWidth + \"%\",\n        trackStyle: trackStyle\n      };\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"checkImagesLoad\", function () {\n      var images = _this.list && _this.list.querySelectorAll && _this.list.querySelectorAll(\".slick-slide img\") || [];\n      var imagesCount = images.length,\n          loadedCount = 0;\n      Array.prototype.forEach.call(images, function (image) {\n        var handler = function handler() {\n          return ++loadedCount && loadedCount >= imagesCount && _this.onWindowResized();\n        };\n\n        if (!image.onclick) {\n          image.onclick = function () {\n            return image.parentNode.focus();\n          };\n        } else {\n          var prevClickHandler = image.onclick;\n\n          image.onclick = function () {\n            prevClickHandler();\n            image.parentNode.focus();\n          };\n        }\n\n        if (!image.onload) {\n          if (_this.props.lazyLoad) {\n            image.onload = function () {\n              _this.adaptHeight();\n\n              _this.callbackTimers.push(setTimeout(_this.onWindowResized, _this.props.speed));\n            };\n          } else {\n            image.onload = handler;\n\n            image.onerror = function () {\n              handler();\n              _this.props.onLazyLoadError && _this.props.onLazyLoadError();\n            };\n          }\n        }\n      });\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"progressiveLazyLoad\", function () {\n      var slidesToLoad = [];\n\n      var spec = _objectSpread(_objectSpread({}, _this.props), _this.state);\n\n      for (var index = _this.state.currentSlide; index < _this.state.slideCount + (0, _innerSliderUtils.getPostClones)(spec); index++) {\n        if (_this.state.lazyLoadedList.indexOf(index) < 0) {\n          slidesToLoad.push(index);\n          break;\n        }\n      }\n\n      for (var _index = _this.state.currentSlide - 1; _index >= -(0, _innerSliderUtils.getPreClones)(spec); _index--) {\n        if (_this.state.lazyLoadedList.indexOf(_index) < 0) {\n          slidesToLoad.push(_index);\n          break;\n        }\n      }\n\n      if (slidesToLoad.length > 0) {\n        _this.setState(function (state) {\n          return {\n            lazyLoadedList: state.lazyLoadedList.concat(slidesToLoad)\n          };\n        });\n\n        if (_this.props.onLazyLoad) {\n          _this.props.onLazyLoad(slidesToLoad);\n        }\n      } else {\n        if (_this.lazyLoadTimer) {\n          clearInterval(_this.lazyLoadTimer);\n          delete _this.lazyLoadTimer;\n        }\n      }\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"slideHandler\", function (index) {\n      var dontAnimate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;\n      var _this$props = _this.props,\n          asNavFor = _this$props.asNavFor,\n          beforeChange = _this$props.beforeChange,\n          onLazyLoad = _this$props.onLazyLoad,\n          speed = _this$props.speed,\n          afterChange = _this$props.afterChange; // capture currentslide before state is updated\n\n      var currentSlide = _this.state.currentSlide;\n\n      var _slideHandler = (0, _innerSliderUtils.slideHandler)(_objectSpread(_objectSpread(_objectSpread({\n        index: index\n      }, _this.props), _this.state), {}, {\n        trackRef: _this.track,\n        useCSS: _this.props.useCSS && !dontAnimate\n      })),\n          state = _slideHandler.state,\n          nextState = _slideHandler.nextState;\n\n      if (!state) return;\n      beforeChange && beforeChange(currentSlide, state.currentSlide);\n      var slidesToLoad = state.lazyLoadedList.filter(function (value) {\n        return _this.state.lazyLoadedList.indexOf(value) < 0;\n      });\n      onLazyLoad && slidesToLoad.length > 0 && onLazyLoad(slidesToLoad);\n\n      if (!_this.props.waitForAnimate && _this.animationEndCallback) {\n        clearTimeout(_this.animationEndCallback);\n        afterChange && afterChange(currentSlide);\n        delete _this.animationEndCallback;\n      }\n\n      _this.setState(state, function () {\n        // asNavForIndex check is to avoid recursive calls of slideHandler in waitForAnimate=false mode\n        if (asNavFor && _this.asNavForIndex !== index) {\n          _this.asNavForIndex = index;\n          asNavFor.innerSlider.slideHandler(index);\n        }\n\n        if (!nextState) return;\n        _this.animationEndCallback = setTimeout(function () {\n          var animating = nextState.animating,\n              firstBatch = _objectWithoutProperties(nextState, [\"animating\"]);\n\n          _this.setState(firstBatch, function () {\n            _this.callbackTimers.push(setTimeout(function () {\n              return _this.setState({\n                animating: animating\n              });\n            }, 10));\n\n            afterChange && afterChange(state.currentSlide);\n            delete _this.animationEndCallback;\n          });\n        }, speed);\n      });\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"changeSlide\", function (options) {\n      var dontAnimate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;\n\n      var spec = _objectSpread(_objectSpread({}, _this.props), _this.state);\n\n      var targetSlide = (0, _innerSliderUtils.changeSlide)(spec, options);\n      if (targetSlide !== 0 && !targetSlide) return;\n\n      if (dontAnimate === true) {\n        _this.slideHandler(targetSlide, dontAnimate);\n      } else {\n        _this.slideHandler(targetSlide);\n      }\n\n      _this.props.autoplay && _this.autoPlay(\"update\");\n\n      if (_this.props.focusOnSelect) {\n        var nodes = _this.list.querySelectorAll(\".slick-current\");\n\n        nodes[0] && nodes[0].focus();\n      }\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"clickHandler\", function (e) {\n      if (_this.clickable === false) {\n        e.stopPropagation();\n        e.preventDefault();\n      }\n\n      _this.clickable = true;\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"keyHandler\", function (e) {\n      var dir = (0, _innerSliderUtils.keyHandler)(e, _this.props.accessibility, _this.props.rtl);\n      dir !== \"\" && _this.changeSlide({\n        message: dir\n      });\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"selectHandler\", function (options) {\n      _this.changeSlide(options);\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"disableBodyScroll\", function () {\n      var preventDefault = function preventDefault(e) {\n        e = e || window.event;\n        if (e.preventDefault) e.preventDefault();\n        e.returnValue = false;\n      };\n\n      window.ontouchmove = preventDefault;\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"enableBodyScroll\", function () {\n      window.ontouchmove = null;\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"swipeStart\", function (e) {\n      if (_this.props.verticalSwiping) {\n        _this.disableBodyScroll();\n      }\n\n      var state = (0, _innerSliderUtils.swipeStart)(e, _this.props.swipe, _this.props.draggable);\n      state !== \"\" && _this.setState(state);\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"swipeMove\", function (e) {\n      var state = (0, _innerSliderUtils.swipeMove)(e, _objectSpread(_objectSpread(_objectSpread({}, _this.props), _this.state), {}, {\n        trackRef: _this.track,\n        listRef: _this.list,\n        slideIndex: _this.state.currentSlide\n      }));\n      if (!state) return;\n\n      if (state[\"swiping\"]) {\n        _this.clickable = false;\n      }\n\n      _this.setState(state);\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"swipeEnd\", function (e) {\n      var state = (0, _innerSliderUtils.swipeEnd)(e, _objectSpread(_objectSpread(_objectSpread({}, _this.props), _this.state), {}, {\n        trackRef: _this.track,\n        listRef: _this.list,\n        slideIndex: _this.state.currentSlide\n      }));\n      if (!state) return;\n      var triggerSlideHandler = state[\"triggerSlideHandler\"];\n      delete state[\"triggerSlideHandler\"];\n\n      _this.setState(state);\n\n      if (triggerSlideHandler === undefined) return;\n\n      _this.slideHandler(triggerSlideHandler);\n\n      if (_this.props.verticalSwiping) {\n        _this.enableBodyScroll();\n      }\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"touchEnd\", function (e) {\n      _this.swipeEnd(e);\n\n      _this.clickable = true;\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"slickPrev\", function () {\n      // this and fellow methods are wrapped in setTimeout\n      // to make sure initialize setState has happened before\n      // any of such methods are called\n      _this.callbackTimers.push(setTimeout(function () {\n        return _this.changeSlide({\n          message: \"previous\"\n        });\n      }, 0));\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"slickNext\", function () {\n      _this.callbackTimers.push(setTimeout(function () {\n        return _this.changeSlide({\n          message: \"next\"\n        });\n      }, 0));\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"slickGoTo\", function (slide) {\n      var dontAnimate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;\n      slide = Number(slide);\n      if (isNaN(slide)) return \"\";\n\n      _this.callbackTimers.push(setTimeout(function () {\n        return _this.changeSlide({\n          message: \"index\",\n          index: slide,\n          currentSlide: _this.state.currentSlide\n        }, dontAnimate);\n      }, 0));\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"play\", function () {\n      var nextIndex;\n\n      if (_this.props.rtl) {\n        nextIndex = _this.state.currentSlide - _this.props.slidesToScroll;\n      } else {\n        if ((0, _innerSliderUtils.canGoNext)(_objectSpread(_objectSpread({}, _this.props), _this.state))) {\n          nextIndex = _this.state.currentSlide + _this.props.slidesToScroll;\n        } else {\n          return false;\n        }\n      }\n\n      _this.slideHandler(nextIndex);\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"autoPlay\", function (playType) {\n      if (_this.autoplayTimer) {\n        clearInterval(_this.autoplayTimer);\n      }\n\n      var autoplaying = _this.state.autoplaying;\n\n      if (playType === \"update\") {\n        if (autoplaying === \"hovered\" || autoplaying === \"focused\" || autoplaying === \"paused\") {\n          return;\n        }\n      } else if (playType === \"leave\") {\n        if (autoplaying === \"paused\" || autoplaying === \"focused\") {\n          return;\n        }\n      } else if (playType === \"blur\") {\n        if (autoplaying === \"paused\" || autoplaying === \"hovered\") {\n          return;\n        }\n      }\n\n      _this.autoplayTimer = setInterval(_this.play, _this.props.autoplaySpeed + 50);\n\n      _this.setState({\n        autoplaying: \"playing\"\n      });\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"pause\", function (pauseType) {\n      if (_this.autoplayTimer) {\n        clearInterval(_this.autoplayTimer);\n        _this.autoplayTimer = null;\n      }\n\n      var autoplaying = _this.state.autoplaying;\n\n      if (pauseType === \"paused\") {\n        _this.setState({\n          autoplaying: \"paused\"\n        });\n      } else if (pauseType === \"focused\") {\n        if (autoplaying === \"hovered\" || autoplaying === \"playing\") {\n          _this.setState({\n            autoplaying: \"focused\"\n          });\n        }\n      } else {\n        // pauseType  is 'hovered'\n        if (autoplaying === \"playing\") {\n          _this.setState({\n            autoplaying: \"hovered\"\n          });\n        }\n      }\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"onDotsOver\", function () {\n      return _this.props.autoplay && _this.pause(\"hovered\");\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"onDotsLeave\", function () {\n      return _this.props.autoplay && _this.state.autoplaying === \"hovered\" && _this.autoPlay(\"leave\");\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"onTrackOver\", function () {\n      return _this.props.autoplay && _this.pause(\"hovered\");\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"onTrackLeave\", function () {\n      return _this.props.autoplay && _this.state.autoplaying === \"hovered\" && _this.autoPlay(\"leave\");\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"onSlideFocus\", function () {\n      return _this.props.autoplay && _this.pause(\"focused\");\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"onSlideBlur\", function () {\n      return _this.props.autoplay && _this.state.autoplaying === \"focused\" && _this.autoPlay(\"blur\");\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"render\", function () {\n      var className = (0, _classnames[\"default\"])(\"slick-slider\", _this.props.className, {\n        \"slick-vertical\": _this.props.vertical,\n        \"slick-initialized\": true\n      });\n\n      var spec = _objectSpread(_objectSpread({}, _this.props), _this.state);\n\n      var trackProps = (0, _innerSliderUtils.extractObject)(spec, [\"fade\", \"cssEase\", \"speed\", \"infinite\", \"centerMode\", \"focusOnSelect\", \"currentSlide\", \"lazyLoad\", \"lazyLoadedList\", \"rtl\", \"slideWidth\", \"slideHeight\", \"listHeight\", \"vertical\", \"slidesToShow\", \"slidesToScroll\", \"slideCount\", \"trackStyle\", \"variableWidth\", \"unslick\", \"centerPadding\", \"targetSlide\", \"useCSS\"]);\n      var pauseOnHover = _this.props.pauseOnHover;\n      trackProps = _objectSpread(_objectSpread({}, trackProps), {}, {\n        onMouseEnter: pauseOnHover ? _this.onTrackOver : null,\n        onMouseLeave: pauseOnHover ? _this.onTrackLeave : null,\n        onMouseOver: pauseOnHover ? _this.onTrackOver : null,\n        focusOnSelect: _this.props.focusOnSelect && _this.clickable ? _this.selectHandler : null\n      });\n      var dots;\n\n      if (_this.props.dots === true && _this.state.slideCount >= _this.props.slidesToShow) {\n        var dotProps = (0, _innerSliderUtils.extractObject)(spec, [\"dotsClass\", \"slideCount\", \"slidesToShow\", \"currentSlide\", \"slidesToScroll\", \"clickHandler\", \"children\", \"customPaging\", \"infinite\", \"appendDots\"]);\n        var pauseOnDotsHover = _this.props.pauseOnDotsHover;\n        dotProps = _objectSpread(_objectSpread({}, dotProps), {}, {\n          clickHandler: _this.changeSlide,\n          onMouseEnter: pauseOnDotsHover ? _this.onDotsLeave : null,\n          onMouseOver: pauseOnDotsHover ? _this.onDotsOver : null,\n          onMouseLeave: pauseOnDotsHover ? _this.onDotsLeave : null\n        });\n        dots = /*#__PURE__*/_react[\"default\"].createElement(_dots.Dots, dotProps);\n      }\n\n      var prevArrow, nextArrow;\n      var arrowProps = (0, _innerSliderUtils.extractObject)(spec, [\"infinite\", \"centerMode\", \"currentSlide\", \"slideCount\", \"slidesToShow\", \"prevArrow\", \"nextArrow\"]);\n      arrowProps.clickHandler = _this.changeSlide;\n\n      if (_this.props.arrows) {\n        prevArrow = /*#__PURE__*/_react[\"default\"].createElement(_arrows.PrevArrow, arrowProps);\n        nextArrow = /*#__PURE__*/_react[\"default\"].createElement(_arrows.NextArrow, arrowProps);\n      }\n\n      var verticalHeightStyle = null;\n\n      if (_this.props.vertical) {\n        verticalHeightStyle = {\n          height: _this.state.listHeight\n        };\n      }\n\n      var centerPaddingStyle = null;\n\n      if (_this.props.vertical === false) {\n        if (_this.props.centerMode === true) {\n          centerPaddingStyle = {\n            padding: \"0px \" + _this.props.centerPadding\n          };\n        }\n      } else {\n        if (_this.props.centerMode === true) {\n          centerPaddingStyle = {\n            padding: _this.props.centerPadding + \" 0px\"\n          };\n        }\n      }\n\n      var listStyle = _objectSpread(_objectSpread({}, verticalHeightStyle), centerPaddingStyle);\n\n      var touchMove = _this.props.touchMove;\n      var listProps = {\n        className: \"slick-list\",\n        style: listStyle,\n        onClick: _this.clickHandler,\n        onMouseDown: touchMove ? _this.swipeStart : null,\n        onMouseMove: _this.state.dragging && touchMove ? _this.swipeMove : null,\n        onMouseUp: touchMove ? _this.swipeEnd : null,\n        onMouseLeave: _this.state.dragging && touchMove ? _this.swipeEnd : null,\n        onTouchStart: touchMove ? _this.swipeStart : null,\n        onTouchMove: _this.state.dragging && touchMove ? _this.swipeMove : null,\n        onTouchEnd: touchMove ? _this.touchEnd : null,\n        onTouchCancel: _this.state.dragging && touchMove ? _this.swipeEnd : null,\n        onKeyDown: _this.props.accessibility ? _this.keyHandler : null\n      };\n      var innerSliderProps = {\n        className: className,\n        dir: \"ltr\",\n        style: _this.props.style\n      };\n\n      if (_this.props.unslick) {\n        listProps = {\n          className: \"slick-list\"\n        };\n        innerSliderProps = {\n          className: className\n        };\n      }\n\n      return /*#__PURE__*/_react[\"default\"].createElement(\"div\", innerSliderProps, !_this.props.unslick ? prevArrow : \"\", /*#__PURE__*/_react[\"default\"].createElement(\"div\", _extends({\n        ref: _this.listRefHandler\n      }, listProps), /*#__PURE__*/_react[\"default\"].createElement(_track.Track, _extends({\n        ref: _this.trackRefHandler\n      }, trackProps), _this.props.children)), !_this.props.unslick ? nextArrow : \"\", !_this.props.unslick ? dots : \"\");\n    });\n\n    _this.list = null;\n    _this.track = null;\n    _this.state = _objectSpread(_objectSpread({}, _initialState[\"default\"]), {}, {\n      currentSlide: _this.props.initialSlide,\n      slideCount: _react[\"default\"].Children.count(_this.props.children)\n    });\n    _this.callbackTimers = [];\n    _this.clickable = true;\n    _this.debouncedResize = null;\n\n    var ssrState = _this.ssrInit();\n\n    _this.state = _objectSpread(_objectSpread({}, _this.state), ssrState);\n    return _this;\n  }\n\n  _createClass(InnerSlider, [{\n    key: \"didPropsChange\",\n    value: function didPropsChange(prevProps) {\n      var setTrackStyle = false;\n\n      for (var _i3 = 0, _Object$keys = Object.keys(this.props); _i3 < _Object$keys.length; _i3++) {\n        var key = _Object$keys[_i3];\n\n        if (!prevProps.hasOwnProperty(key)) {\n          setTrackStyle = true;\n          break;\n        }\n\n        if (_typeof(prevProps[key]) === \"object\" || typeof prevProps[key] === \"function\") {\n          continue;\n        }\n\n        if (prevProps[key] !== this.props[key]) {\n          setTrackStyle = true;\n          break;\n        }\n      }\n\n      return setTrackStyle || _react[\"default\"].Children.count(this.props.children) !== _react[\"default\"].Children.count(prevProps.children);\n    }\n  }]);\n\n  return InnerSlider;\n}(_react[\"default\"].Component);\n\nexports.InnerSlider = InnerSlider;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/react-slick/lib/inner-slider.js\n"));

/***/ }),

/***/ "./node_modules/react-slick/lib/slider.js":
/*!************************************************!*\
  !*** ./node_modules/react-slick/lib/slider.js ***!
  \************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval(__webpack_require__.ts("\n\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\n\nObject.defineProperty(exports, \"__esModule\", ({\n  value: true\n}));\nexports[\"default\"] = void 0;\n\nvar _react = _interopRequireDefault(__webpack_require__(/*! react */ \"./node_modules/react/index.js\"));\n\nvar _innerSlider = __webpack_require__(/*! ./inner-slider */ \"./node_modules/react-slick/lib/inner-slider.js\");\n\nvar _json2mq = _interopRequireDefault(__webpack_require__(/*! json2mq */ \"./node_modules/json2mq/index.js\"));\n\nvar _defaultProps = _interopRequireDefault(__webpack_require__(/*! ./default-props */ \"./node_modules/react-slick/lib/default-props.js\"));\n\nvar _innerSliderUtils = __webpack_require__(/*! ./utils/innerSliderUtils */ \"./node_modules/react-slick/lib/utils/innerSliderUtils.js\");\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { \"default\": obj }; }\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\n\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\n\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nvar enquire = (0, _innerSliderUtils.canUseDOM)() && __webpack_require__(/*! enquire.js */ \"./node_modules/enquire.js/src/index.js\");\n\nvar Slider = /*#__PURE__*/function (_React$Component) {\n  _inherits(Slider, _React$Component);\n\n  var _super = _createSuper(Slider);\n\n  function Slider(props) {\n    var _this;\n\n    _classCallCheck(this, Slider);\n\n    _this = _super.call(this, props);\n\n    _defineProperty(_assertThisInitialized(_this), \"innerSliderRefHandler\", function (ref) {\n      return _this.innerSlider = ref;\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"slickPrev\", function () {\n      return _this.innerSlider.slickPrev();\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"slickNext\", function () {\n      return _this.innerSlider.slickNext();\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"slickGoTo\", function (slide) {\n      var dontAnimate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;\n      return _this.innerSlider.slickGoTo(slide, dontAnimate);\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"slickPause\", function () {\n      return _this.innerSlider.pause(\"paused\");\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"slickPlay\", function () {\n      return _this.innerSlider.autoPlay(\"play\");\n    });\n\n    _this.state = {\n      breakpoint: null\n    };\n    _this._responsiveMediaHandlers = [];\n    return _this;\n  }\n\n  _createClass(Slider, [{\n    key: \"media\",\n    value: function media(query, handler) {\n      // javascript handler for  css media query\n      enquire.register(query, handler);\n\n      this._responsiveMediaHandlers.push({\n        query: query,\n        handler: handler\n      });\n    } // handles responsive breakpoints\n\n  }, {\n    key: \"componentDidMount\",\n    value: function componentDidMount() {\n      var _this2 = this;\n\n      // performance monitoring\n      //if (process.env.NODE_ENV !== 'production') {\n      //const { whyDidYouUpdate } = require('why-did-you-update')\n      //whyDidYouUpdate(React)\n      //}\n      if (this.props.responsive) {\n        var breakpoints = this.props.responsive.map(function (breakpt) {\n          return breakpt.breakpoint;\n        }); // sort them in increasing order of their numerical value\n\n        breakpoints.sort(function (x, y) {\n          return x - y;\n        });\n        breakpoints.forEach(function (breakpoint, index) {\n          // media query for each breakpoint\n          var bQuery;\n\n          if (index === 0) {\n            bQuery = (0, _json2mq[\"default\"])({\n              minWidth: 0,\n              maxWidth: breakpoint\n            });\n          } else {\n            bQuery = (0, _json2mq[\"default\"])({\n              minWidth: breakpoints[index - 1] + 1,\n              maxWidth: breakpoint\n            });\n          } // when not using server side rendering\n\n\n          (0, _innerSliderUtils.canUseDOM)() && _this2.media(bQuery, function () {\n            _this2.setState({\n              breakpoint: breakpoint\n            });\n          });\n        }); // Register media query for full screen. Need to support resize from small to large\n        // convert javascript object to media query string\n\n        var query = (0, _json2mq[\"default\"])({\n          minWidth: breakpoints.slice(-1)[0]\n        });\n        (0, _innerSliderUtils.canUseDOM)() && this.media(query, function () {\n          _this2.setState({\n            breakpoint: null\n          });\n        });\n      }\n    }\n  }, {\n    key: \"componentWillUnmount\",\n    value: function componentWillUnmount() {\n      this._responsiveMediaHandlers.forEach(function (obj) {\n        enquire.unregister(obj.query, obj.handler);\n      });\n    }\n  }, {\n    key: \"render\",\n    value: function render() {\n      var _this3 = this;\n\n      var settings;\n      var newProps;\n\n      if (this.state.breakpoint) {\n        newProps = this.props.responsive.filter(function (resp) {\n          return resp.breakpoint === _this3.state.breakpoint;\n        });\n        settings = newProps[0].settings === \"unslick\" ? \"unslick\" : _objectSpread(_objectSpread(_objectSpread({}, _defaultProps[\"default\"]), this.props), newProps[0].settings);\n      } else {\n        settings = _objectSpread(_objectSpread({}, _defaultProps[\"default\"]), this.props);\n      } // force scrolling by one if centerMode is on\n\n\n      if (settings.centerMode) {\n        if (settings.slidesToScroll > 1 && \"development\" !== \"production\") {\n          console.warn(\"slidesToScroll should be equal to 1 in centerMode, you are using \".concat(settings.slidesToScroll));\n        }\n\n        settings.slidesToScroll = 1;\n      } // force showing one slide and scrolling by one if the fade mode is on\n\n\n      if (settings.fade) {\n        if (settings.slidesToShow > 1 && \"development\" !== \"production\") {\n          console.warn(\"slidesToShow should be equal to 1 when fade is true, you're using \".concat(settings.slidesToShow));\n        }\n\n        if (settings.slidesToScroll > 1 && \"development\" !== \"production\") {\n          console.warn(\"slidesToScroll should be equal to 1 when fade is true, you're using \".concat(settings.slidesToScroll));\n        }\n\n        settings.slidesToShow = 1;\n        settings.slidesToScroll = 1;\n      } // makes sure that children is an array, even when there is only 1 child\n\n\n      var children = _react[\"default\"].Children.toArray(this.props.children); // Children may contain false or null, so we should filter them\n      // children may also contain string filled with spaces (in certain cases where we use jsx strings)\n\n\n      children = children.filter(function (child) {\n        if (typeof child === \"string\") {\n          return !!child.trim();\n        }\n\n        return !!child;\n      }); // rows and slidesPerRow logic is handled here\n\n      if (settings.variableWidth && (settings.rows > 1 || settings.slidesPerRow > 1)) {\n        console.warn(\"variableWidth is not supported in case of rows > 1 or slidesPerRow > 1\");\n        settings.variableWidth = false;\n      }\n\n      var newChildren = [];\n      var currentWidth = null;\n\n      for (var i = 0; i < children.length; i += settings.rows * settings.slidesPerRow) {\n        var newSlide = [];\n\n        for (var j = i; j < i + settings.rows * settings.slidesPerRow; j += settings.slidesPerRow) {\n          var row = [];\n\n          for (var k = j; k < j + settings.slidesPerRow; k += 1) {\n            if (settings.variableWidth && children[k].props.style) {\n              currentWidth = children[k].props.style.width;\n            }\n\n            if (k >= children.length) break;\n            row.push( /*#__PURE__*/_react[\"default\"].cloneElement(children[k], {\n              key: 100 * i + 10 * j + k,\n              tabIndex: -1,\n              style: {\n                width: \"\".concat(100 / settings.slidesPerRow, \"%\"),\n                display: \"inline-block\"\n              }\n            }));\n          }\n\n          newSlide.push( /*#__PURE__*/_react[\"default\"].createElement(\"div\", {\n            key: 10 * i + j\n          }, row));\n        }\n\n        if (settings.variableWidth) {\n          newChildren.push( /*#__PURE__*/_react[\"default\"].createElement(\"div\", {\n            key: i,\n            style: {\n              width: currentWidth\n            }\n          }, newSlide));\n        } else {\n          newChildren.push( /*#__PURE__*/_react[\"default\"].createElement(\"div\", {\n            key: i\n          }, newSlide));\n        }\n      }\n\n      if (settings === \"unslick\") {\n        var className = \"regular slider \" + (this.props.className || \"\");\n        return /*#__PURE__*/_react[\"default\"].createElement(\"div\", {\n          className: className\n        }, children);\n      } else if (newChildren.length <= settings.slidesToShow) {\n        settings.unslick = true;\n      }\n\n      return /*#__PURE__*/_react[\"default\"].createElement(_innerSlider.InnerSlider, _extends({\n        style: this.props.style,\n        ref: this.innerSliderRefHandler\n      }, settings), newChildren);\n    }\n  }]);\n\n  return Slider;\n}(_react[\"default\"].Component);\n\nexports[\"default\"] = Slider;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/react-slick/lib/slider.js\n"));

/***/ }),

/***/ "./node_modules/react-slick/lib/track.js":
/*!***********************************************!*\
  !*** ./node_modules/react-slick/lib/track.js ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval(__webpack_require__.ts("\n\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\n\nObject.defineProperty(exports, \"__esModule\", ({\n  value: true\n}));\nexports.Track = void 0;\n\nvar _react = _interopRequireDefault(__webpack_require__(/*! react */ \"./node_modules/react/index.js\"));\n\nvar _classnames = _interopRequireDefault(__webpack_require__(/*! classnames */ \"./node_modules/classnames/index.js\"));\n\nvar _innerSliderUtils = __webpack_require__(/*! ./utils/innerSliderUtils */ \"./node_modules/react-slick/lib/utils/innerSliderUtils.js\");\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { \"default\": obj }; }\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\n\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\n\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\n// given specifications/props for a slide, fetch all the classes that need to be applied to the slide\nvar getSlideClasses = function getSlideClasses(spec) {\n  var slickActive, slickCenter, slickCloned;\n  var centerOffset, index;\n\n  if (spec.rtl) {\n    index = spec.slideCount - 1 - spec.index;\n  } else {\n    index = spec.index;\n  }\n\n  slickCloned = index < 0 || index >= spec.slideCount;\n\n  if (spec.centerMode) {\n    centerOffset = Math.floor(spec.slidesToShow / 2);\n    slickCenter = (index - spec.currentSlide) % spec.slideCount === 0;\n\n    if (index > spec.currentSlide - centerOffset - 1 && index <= spec.currentSlide + centerOffset) {\n      slickActive = true;\n    }\n  } else {\n    slickActive = spec.currentSlide <= index && index < spec.currentSlide + spec.slidesToShow;\n  }\n\n  var focusedSlide;\n\n  if (spec.targetSlide < 0) {\n    focusedSlide = spec.targetSlide + spec.slideCount;\n  } else if (spec.targetSlide >= spec.slideCount) {\n    focusedSlide = spec.targetSlide - spec.slideCount;\n  } else {\n    focusedSlide = spec.targetSlide;\n  }\n\n  var slickCurrent = index === focusedSlide;\n  return {\n    \"slick-slide\": true,\n    \"slick-active\": slickActive,\n    \"slick-center\": slickCenter,\n    \"slick-cloned\": slickCloned,\n    \"slick-current\": slickCurrent // dubious in case of RTL\n\n  };\n};\n\nvar getSlideStyle = function getSlideStyle(spec) {\n  var style = {};\n\n  if (spec.variableWidth === undefined || spec.variableWidth === false) {\n    style.width = spec.slideWidth;\n  }\n\n  if (spec.fade) {\n    style.position = \"relative\";\n\n    if (spec.vertical) {\n      style.top = -spec.index * parseInt(spec.slideHeight);\n    } else {\n      style.left = -spec.index * parseInt(spec.slideWidth);\n    }\n\n    style.opacity = spec.currentSlide === spec.index ? 1 : 0;\n\n    if (spec.useCSS) {\n      style.transition = \"opacity \" + spec.speed + \"ms \" + spec.cssEase + \", \" + \"visibility \" + spec.speed + \"ms \" + spec.cssEase;\n    }\n  }\n\n  return style;\n};\n\nvar getKey = function getKey(child, fallbackKey) {\n  return child.key || fallbackKey;\n};\n\nvar renderSlides = function renderSlides(spec) {\n  var key;\n  var slides = [];\n  var preCloneSlides = [];\n  var postCloneSlides = [];\n\n  var childrenCount = _react[\"default\"].Children.count(spec.children);\n\n  var startIndex = (0, _innerSliderUtils.lazyStartIndex)(spec);\n  var endIndex = (0, _innerSliderUtils.lazyEndIndex)(spec);\n\n  _react[\"default\"].Children.forEach(spec.children, function (elem, index) {\n    var child;\n    var childOnClickOptions = {\n      message: \"children\",\n      index: index,\n      slidesToScroll: spec.slidesToScroll,\n      currentSlide: spec.currentSlide\n    }; // in case of lazyLoad, whether or not we want to fetch the slide\n\n    if (!spec.lazyLoad || spec.lazyLoad && spec.lazyLoadedList.indexOf(index) >= 0) {\n      child = elem;\n    } else {\n      child = /*#__PURE__*/_react[\"default\"].createElement(\"div\", null);\n    }\n\n    var childStyle = getSlideStyle(_objectSpread(_objectSpread({}, spec), {}, {\n      index: index\n    }));\n    var slideClass = child.props.className || \"\";\n    var slideClasses = getSlideClasses(_objectSpread(_objectSpread({}, spec), {}, {\n      index: index\n    })); // push a cloned element of the desired slide\n\n    slides.push( /*#__PURE__*/_react[\"default\"].cloneElement(child, {\n      key: \"original\" + getKey(child, index),\n      \"data-index\": index,\n      className: (0, _classnames[\"default\"])(slideClasses, slideClass),\n      tabIndex: \"-1\",\n      \"aria-hidden\": !slideClasses[\"slick-active\"],\n      style: _objectSpread(_objectSpread({\n        outline: \"none\"\n      }, child.props.style || {}), childStyle),\n      onClick: function onClick(e) {\n        child.props && child.props.onClick && child.props.onClick(e);\n\n        if (spec.focusOnSelect) {\n          spec.focusOnSelect(childOnClickOptions);\n        }\n      }\n    })); // if slide needs to be precloned or postcloned\n\n    if (spec.infinite && spec.fade === false) {\n      var preCloneNo = childrenCount - index;\n\n      if (preCloneNo <= (0, _innerSliderUtils.getPreClones)(spec) && childrenCount !== spec.slidesToShow) {\n        key = -preCloneNo;\n\n        if (key >= startIndex) {\n          child = elem;\n        }\n\n        slideClasses = getSlideClasses(_objectSpread(_objectSpread({}, spec), {}, {\n          index: key\n        }));\n        preCloneSlides.push( /*#__PURE__*/_react[\"default\"].cloneElement(child, {\n          key: \"precloned\" + getKey(child, key),\n          \"data-index\": key,\n          tabIndex: \"-1\",\n          className: (0, _classnames[\"default\"])(slideClasses, slideClass),\n          \"aria-hidden\": !slideClasses[\"slick-active\"],\n          style: _objectSpread(_objectSpread({}, child.props.style || {}), childStyle),\n          onClick: function onClick(e) {\n            child.props && child.props.onClick && child.props.onClick(e);\n\n            if (spec.focusOnSelect) {\n              spec.focusOnSelect(childOnClickOptions);\n            }\n          }\n        }));\n      }\n\n      if (childrenCount !== spec.slidesToShow) {\n        key = childrenCount + index;\n\n        if (key < endIndex) {\n          child = elem;\n        }\n\n        slideClasses = getSlideClasses(_objectSpread(_objectSpread({}, spec), {}, {\n          index: key\n        }));\n        postCloneSlides.push( /*#__PURE__*/_react[\"default\"].cloneElement(child, {\n          key: \"postcloned\" + getKey(child, key),\n          \"data-index\": key,\n          tabIndex: \"-1\",\n          className: (0, _classnames[\"default\"])(slideClasses, slideClass),\n          \"aria-hidden\": !slideClasses[\"slick-active\"],\n          style: _objectSpread(_objectSpread({}, child.props.style || {}), childStyle),\n          onClick: function onClick(e) {\n            child.props && child.props.onClick && child.props.onClick(e);\n\n            if (spec.focusOnSelect) {\n              spec.focusOnSelect(childOnClickOptions);\n            }\n          }\n        }));\n      }\n    }\n  });\n\n  if (spec.rtl) {\n    return preCloneSlides.concat(slides, postCloneSlides).reverse();\n  } else {\n    return preCloneSlides.concat(slides, postCloneSlides);\n  }\n};\n\nvar Track = /*#__PURE__*/function (_React$PureComponent) {\n  _inherits(Track, _React$PureComponent);\n\n  var _super = _createSuper(Track);\n\n  function Track() {\n    var _this;\n\n    _classCallCheck(this, Track);\n\n    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n      args[_key] = arguments[_key];\n    }\n\n    _this = _super.call.apply(_super, [this].concat(args));\n\n    _defineProperty(_assertThisInitialized(_this), \"node\", null);\n\n    _defineProperty(_assertThisInitialized(_this), \"handleRef\", function (ref) {\n      _this.node = ref;\n    });\n\n    return _this;\n  }\n\n  _createClass(Track, [{\n    key: \"render\",\n    value: function render() {\n      var slides = renderSlides(this.props);\n      var _this$props = this.props,\n          onMouseEnter = _this$props.onMouseEnter,\n          onMouseOver = _this$props.onMouseOver,\n          onMouseLeave = _this$props.onMouseLeave;\n      var mouseEvents = {\n        onMouseEnter: onMouseEnter,\n        onMouseOver: onMouseOver,\n        onMouseLeave: onMouseLeave\n      };\n      return /*#__PURE__*/_react[\"default\"].createElement(\"div\", _extends({\n        ref: this.handleRef,\n        className: \"slick-track\",\n        style: this.props.trackStyle\n      }, mouseEvents), slides);\n    }\n  }]);\n\n  return Track;\n}(_react[\"default\"].PureComponent);\n\nexports.Track = Track;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/react-slick/lib/track.js\n"));

/***/ }),

/***/ "./node_modules/react-slick/lib/utils/innerSliderUtils.js":
/*!****************************************************************!*\
  !*** ./node_modules/react-slick/lib/utils/innerSliderUtils.js ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval(__webpack_require__.ts("\n\nObject.defineProperty(exports, \"__esModule\", ({\n  value: true\n}));\nexports.checkSpecKeys = exports.checkNavigable = exports.changeSlide = exports.canUseDOM = exports.canGoNext = void 0;\nexports.clamp = clamp;\nexports.swipeStart = exports.swipeMove = exports.swipeEnd = exports.slidesOnRight = exports.slidesOnLeft = exports.slideHandler = exports.siblingDirection = exports.safePreventDefault = exports.lazyStartIndex = exports.lazySlidesOnRight = exports.lazySlidesOnLeft = exports.lazyEndIndex = exports.keyHandler = exports.initializedState = exports.getWidth = exports.getTrackLeft = exports.getTrackCSS = exports.getTrackAnimateCSS = exports.getTotalSlides = exports.getSwipeDirection = exports.getSlideCount = exports.getRequiredLazySlides = exports.getPreClones = exports.getPostClones = exports.getOnDemandLazySlides = exports.getNavigableIndexes = exports.getHeight = exports.extractObject = void 0;\n\nvar _react = _interopRequireDefault(__webpack_require__(/*! react */ \"./node_modules/react/index.js\"));\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { \"default\": obj }; }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction clamp(number, lowerBound, upperBound) {\n  return Math.max(lowerBound, Math.min(number, upperBound));\n}\n\nvar safePreventDefault = function safePreventDefault(event) {\n  var passiveEvents = [\"onTouchStart\", \"onTouchMove\", \"onWheel\"];\n\n  if (!passiveEvents.includes(event._reactName)) {\n    event.preventDefault();\n  }\n};\n\nexports.safePreventDefault = safePreventDefault;\n\nvar getOnDemandLazySlides = function getOnDemandLazySlides(spec) {\n  var onDemandSlides = [];\n  var startIndex = lazyStartIndex(spec);\n  var endIndex = lazyEndIndex(spec);\n\n  for (var slideIndex = startIndex; slideIndex < endIndex; slideIndex++) {\n    if (spec.lazyLoadedList.indexOf(slideIndex) < 0) {\n      onDemandSlides.push(slideIndex);\n    }\n  }\n\n  return onDemandSlides;\n}; // return list of slides that need to be present\n\n\nexports.getOnDemandLazySlides = getOnDemandLazySlides;\n\nvar getRequiredLazySlides = function getRequiredLazySlides(spec) {\n  var requiredSlides = [];\n  var startIndex = lazyStartIndex(spec);\n  var endIndex = lazyEndIndex(spec);\n\n  for (var slideIndex = startIndex; slideIndex < endIndex; slideIndex++) {\n    requiredSlides.push(slideIndex);\n  }\n\n  return requiredSlides;\n}; // startIndex that needs to be present\n\n\nexports.getRequiredLazySlides = getRequiredLazySlides;\n\nvar lazyStartIndex = function lazyStartIndex(spec) {\n  return spec.currentSlide - lazySlidesOnLeft(spec);\n};\n\nexports.lazyStartIndex = lazyStartIndex;\n\nvar lazyEndIndex = function lazyEndIndex(spec) {\n  return spec.currentSlide + lazySlidesOnRight(spec);\n};\n\nexports.lazyEndIndex = lazyEndIndex;\n\nvar lazySlidesOnLeft = function lazySlidesOnLeft(spec) {\n  return spec.centerMode ? Math.floor(spec.slidesToShow / 2) + (parseInt(spec.centerPadding) > 0 ? 1 : 0) : 0;\n};\n\nexports.lazySlidesOnLeft = lazySlidesOnLeft;\n\nvar lazySlidesOnRight = function lazySlidesOnRight(spec) {\n  return spec.centerMode ? Math.floor((spec.slidesToShow - 1) / 2) + 1 + (parseInt(spec.centerPadding) > 0 ? 1 : 0) : spec.slidesToShow;\n}; // get width of an element\n\n\nexports.lazySlidesOnRight = lazySlidesOnRight;\n\nvar getWidth = function getWidth(elem) {\n  return elem && elem.offsetWidth || 0;\n};\n\nexports.getWidth = getWidth;\n\nvar getHeight = function getHeight(elem) {\n  return elem && elem.offsetHeight || 0;\n};\n\nexports.getHeight = getHeight;\n\nvar getSwipeDirection = function getSwipeDirection(touchObject) {\n  var verticalSwiping = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;\n  var xDist, yDist, r, swipeAngle;\n  xDist = touchObject.startX - touchObject.curX;\n  yDist = touchObject.startY - touchObject.curY;\n  r = Math.atan2(yDist, xDist);\n  swipeAngle = Math.round(r * 180 / Math.PI);\n\n  if (swipeAngle < 0) {\n    swipeAngle = 360 - Math.abs(swipeAngle);\n  }\n\n  if (swipeAngle <= 45 && swipeAngle >= 0 || swipeAngle <= 360 && swipeAngle >= 315) {\n    return \"left\";\n  }\n\n  if (swipeAngle >= 135 && swipeAngle <= 225) {\n    return \"right\";\n  }\n\n  if (verticalSwiping === true) {\n    if (swipeAngle >= 35 && swipeAngle <= 135) {\n      return \"up\";\n    } else {\n      return \"down\";\n    }\n  }\n\n  return \"vertical\";\n}; // whether or not we can go next\n\n\nexports.getSwipeDirection = getSwipeDirection;\n\nvar canGoNext = function canGoNext(spec) {\n  var canGo = true;\n\n  if (!spec.infinite) {\n    if (spec.centerMode && spec.currentSlide >= spec.slideCount - 1) {\n      canGo = false;\n    } else if (spec.slideCount <= spec.slidesToShow || spec.currentSlide >= spec.slideCount - spec.slidesToShow) {\n      canGo = false;\n    }\n  }\n\n  return canGo;\n}; // given an object and a list of keys, return new object with given keys\n\n\nexports.canGoNext = canGoNext;\n\nvar extractObject = function extractObject(spec, keys) {\n  var newObject = {};\n  keys.forEach(function (key) {\n    return newObject[key] = spec[key];\n  });\n  return newObject;\n}; // get initialized state\n\n\nexports.extractObject = extractObject;\n\nvar initializedState = function initializedState(spec) {\n  // spec also contains listRef, trackRef\n  var slideCount = _react[\"default\"].Children.count(spec.children);\n\n  var listNode = spec.listRef;\n  var listWidth = Math.ceil(getWidth(listNode));\n  var trackNode = spec.trackRef && spec.trackRef.node;\n  var trackWidth = Math.ceil(getWidth(trackNode));\n  var slideWidth;\n\n  if (!spec.vertical) {\n    var centerPaddingAdj = spec.centerMode && parseInt(spec.centerPadding) * 2;\n\n    if (typeof spec.centerPadding === \"string\" && spec.centerPadding.slice(-1) === \"%\") {\n      centerPaddingAdj *= listWidth / 100;\n    }\n\n    slideWidth = Math.ceil((listWidth - centerPaddingAdj) / spec.slidesToShow);\n  } else {\n    slideWidth = listWidth;\n  }\n\n  var slideHeight = listNode && getHeight(listNode.querySelector('[data-index=\"0\"]'));\n  var listHeight = slideHeight * spec.slidesToShow;\n  var currentSlide = spec.currentSlide === undefined ? spec.initialSlide : spec.currentSlide;\n\n  if (spec.rtl && spec.currentSlide === undefined) {\n    currentSlide = slideCount - 1 - spec.initialSlide;\n  }\n\n  var lazyLoadedList = spec.lazyLoadedList || [];\n  var slidesToLoad = getOnDemandLazySlides(_objectSpread(_objectSpread({}, spec), {}, {\n    currentSlide: currentSlide,\n    lazyLoadedList: lazyLoadedList\n  }));\n  lazyLoadedList = lazyLoadedList.concat(slidesToLoad);\n  var state = {\n    slideCount: slideCount,\n    slideWidth: slideWidth,\n    listWidth: listWidth,\n    trackWidth: trackWidth,\n    currentSlide: currentSlide,\n    slideHeight: slideHeight,\n    listHeight: listHeight,\n    lazyLoadedList: lazyLoadedList\n  };\n\n  if (spec.autoplaying === null && spec.autoplay) {\n    state[\"autoplaying\"] = \"playing\";\n  }\n\n  return state;\n};\n\nexports.initializedState = initializedState;\n\nvar slideHandler = function slideHandler(spec) {\n  var waitForAnimate = spec.waitForAnimate,\n      animating = spec.animating,\n      fade = spec.fade,\n      infinite = spec.infinite,\n      index = spec.index,\n      slideCount = spec.slideCount,\n      lazyLoad = spec.lazyLoad,\n      currentSlide = spec.currentSlide,\n      centerMode = spec.centerMode,\n      slidesToScroll = spec.slidesToScroll,\n      slidesToShow = spec.slidesToShow,\n      useCSS = spec.useCSS;\n  var lazyLoadedList = spec.lazyLoadedList;\n  if (waitForAnimate && animating) return {};\n  var animationSlide = index,\n      finalSlide,\n      animationLeft,\n      finalLeft;\n  var state = {},\n      nextState = {};\n  var targetSlide = infinite ? index : clamp(index, 0, slideCount - 1);\n\n  if (fade) {\n    if (!infinite && (index < 0 || index >= slideCount)) return {};\n\n    if (index < 0) {\n      animationSlide = index + slideCount;\n    } else if (index >= slideCount) {\n      animationSlide = index - slideCount;\n    }\n\n    if (lazyLoad && lazyLoadedList.indexOf(animationSlide) < 0) {\n      lazyLoadedList = lazyLoadedList.concat(animationSlide);\n    }\n\n    state = {\n      animating: true,\n      currentSlide: animationSlide,\n      lazyLoadedList: lazyLoadedList,\n      targetSlide: animationSlide\n    };\n    nextState = {\n      animating: false,\n      targetSlide: animationSlide\n    };\n  } else {\n    finalSlide = animationSlide;\n\n    if (animationSlide < 0) {\n      finalSlide = animationSlide + slideCount;\n      if (!infinite) finalSlide = 0;else if (slideCount % slidesToScroll !== 0) finalSlide = slideCount - slideCount % slidesToScroll;\n    } else if (!canGoNext(spec) && animationSlide > currentSlide) {\n      animationSlide = finalSlide = currentSlide;\n    } else if (centerMode && animationSlide >= slideCount) {\n      animationSlide = infinite ? slideCount : slideCount - 1;\n      finalSlide = infinite ? 0 : slideCount - 1;\n    } else if (animationSlide >= slideCount) {\n      finalSlide = animationSlide - slideCount;\n      if (!infinite) finalSlide = slideCount - slidesToShow;else if (slideCount % slidesToScroll !== 0) finalSlide = 0;\n    }\n\n    if (!infinite && animationSlide + slidesToShow >= slideCount) {\n      finalSlide = slideCount - slidesToShow;\n    }\n\n    animationLeft = getTrackLeft(_objectSpread(_objectSpread({}, spec), {}, {\n      slideIndex: animationSlide\n    }));\n    finalLeft = getTrackLeft(_objectSpread(_objectSpread({}, spec), {}, {\n      slideIndex: finalSlide\n    }));\n\n    if (!infinite) {\n      if (animationLeft === finalLeft) animationSlide = finalSlide;\n      animationLeft = finalLeft;\n    }\n\n    if (lazyLoad) {\n      lazyLoadedList = lazyLoadedList.concat(getOnDemandLazySlides(_objectSpread(_objectSpread({}, spec), {}, {\n        currentSlide: animationSlide\n      })));\n    }\n\n    if (!useCSS) {\n      state = {\n        currentSlide: finalSlide,\n        trackStyle: getTrackCSS(_objectSpread(_objectSpread({}, spec), {}, {\n          left: finalLeft\n        })),\n        lazyLoadedList: lazyLoadedList,\n        targetSlide: targetSlide\n      };\n    } else {\n      state = {\n        animating: true,\n        currentSlide: finalSlide,\n        trackStyle: getTrackAnimateCSS(_objectSpread(_objectSpread({}, spec), {}, {\n          left: animationLeft\n        })),\n        lazyLoadedList: lazyLoadedList,\n        targetSlide: targetSlide\n      };\n      nextState = {\n        animating: false,\n        currentSlide: finalSlide,\n        trackStyle: getTrackCSS(_objectSpread(_objectSpread({}, spec), {}, {\n          left: finalLeft\n        })),\n        swipeLeft: null,\n        targetSlide: targetSlide\n      };\n    }\n  }\n\n  return {\n    state: state,\n    nextState: nextState\n  };\n};\n\nexports.slideHandler = slideHandler;\n\nvar changeSlide = function changeSlide(spec, options) {\n  var indexOffset, previousInt, slideOffset, unevenOffset, targetSlide;\n  var slidesToScroll = spec.slidesToScroll,\n      slidesToShow = spec.slidesToShow,\n      slideCount = spec.slideCount,\n      currentSlide = spec.currentSlide,\n      previousTargetSlide = spec.targetSlide,\n      lazyLoad = spec.lazyLoad,\n      infinite = spec.infinite;\n  unevenOffset = slideCount % slidesToScroll !== 0;\n  indexOffset = unevenOffset ? 0 : (slideCount - currentSlide) % slidesToScroll;\n\n  if (options.message === \"previous\") {\n    slideOffset = indexOffset === 0 ? slidesToScroll : slidesToShow - indexOffset;\n    targetSlide = currentSlide - slideOffset;\n\n    if (lazyLoad && !infinite) {\n      previousInt = currentSlide - slideOffset;\n      targetSlide = previousInt === -1 ? slideCount - 1 : previousInt;\n    }\n\n    if (!infinite) {\n      targetSlide = previousTargetSlide - slidesToScroll;\n    }\n  } else if (options.message === \"next\") {\n    slideOffset = indexOffset === 0 ? slidesToScroll : indexOffset;\n    targetSlide = currentSlide + slideOffset;\n\n    if (lazyLoad && !infinite) {\n      targetSlide = (currentSlide + slidesToScroll) % slideCount + indexOffset;\n    }\n\n    if (!infinite) {\n      targetSlide = previousTargetSlide + slidesToScroll;\n    }\n  } else if (options.message === \"dots\") {\n    // Click on dots\n    targetSlide = options.index * options.slidesToScroll;\n  } else if (options.message === \"children\") {\n    // Click on the slides\n    targetSlide = options.index;\n\n    if (infinite) {\n      var direction = siblingDirection(_objectSpread(_objectSpread({}, spec), {}, {\n        targetSlide: targetSlide\n      }));\n\n      if (targetSlide > options.currentSlide && direction === \"left\") {\n        targetSlide = targetSlide - slideCount;\n      } else if (targetSlide < options.currentSlide && direction === \"right\") {\n        targetSlide = targetSlide + slideCount;\n      }\n    }\n  } else if (options.message === \"index\") {\n    targetSlide = Number(options.index);\n  }\n\n  return targetSlide;\n};\n\nexports.changeSlide = changeSlide;\n\nvar keyHandler = function keyHandler(e, accessibility, rtl) {\n  if (e.target.tagName.match(\"TEXTAREA|INPUT|SELECT\") || !accessibility) return \"\";\n  if (e.keyCode === 37) return rtl ? \"next\" : \"previous\";\n  if (e.keyCode === 39) return rtl ? \"previous\" : \"next\";\n  return \"\";\n};\n\nexports.keyHandler = keyHandler;\n\nvar swipeStart = function swipeStart(e, swipe, draggable) {\n  e.target.tagName === \"IMG\" && safePreventDefault(e);\n  if (!swipe || !draggable && e.type.indexOf(\"mouse\") !== -1) return \"\";\n  return {\n    dragging: true,\n    touchObject: {\n      startX: e.touches ? e.touches[0].pageX : e.clientX,\n      startY: e.touches ? e.touches[0].pageY : e.clientY,\n      curX: e.touches ? e.touches[0].pageX : e.clientX,\n      curY: e.touches ? e.touches[0].pageY : e.clientY\n    }\n  };\n};\n\nexports.swipeStart = swipeStart;\n\nvar swipeMove = function swipeMove(e, spec) {\n  // spec also contains, trackRef and slideIndex\n  var scrolling = spec.scrolling,\n      animating = spec.animating,\n      vertical = spec.vertical,\n      swipeToSlide = spec.swipeToSlide,\n      verticalSwiping = spec.verticalSwiping,\n      rtl = spec.rtl,\n      currentSlide = spec.currentSlide,\n      edgeFriction = spec.edgeFriction,\n      edgeDragged = spec.edgeDragged,\n      onEdge = spec.onEdge,\n      swiped = spec.swiped,\n      swiping = spec.swiping,\n      slideCount = spec.slideCount,\n      slidesToScroll = spec.slidesToScroll,\n      infinite = spec.infinite,\n      touchObject = spec.touchObject,\n      swipeEvent = spec.swipeEvent,\n      listHeight = spec.listHeight,\n      listWidth = spec.listWidth;\n  if (scrolling) return;\n  if (animating) return safePreventDefault(e);\n  if (vertical && swipeToSlide && verticalSwiping) safePreventDefault(e);\n  var swipeLeft,\n      state = {};\n  var curLeft = getTrackLeft(spec);\n  touchObject.curX = e.touches ? e.touches[0].pageX : e.clientX;\n  touchObject.curY = e.touches ? e.touches[0].pageY : e.clientY;\n  touchObject.swipeLength = Math.round(Math.sqrt(Math.pow(touchObject.curX - touchObject.startX, 2)));\n  var verticalSwipeLength = Math.round(Math.sqrt(Math.pow(touchObject.curY - touchObject.startY, 2)));\n\n  if (!verticalSwiping && !swiping && verticalSwipeLength > 10) {\n    return {\n      scrolling: true\n    };\n  }\n\n  if (verticalSwiping) touchObject.swipeLength = verticalSwipeLength;\n  var positionOffset = (!rtl ? 1 : -1) * (touchObject.curX > touchObject.startX ? 1 : -1);\n  if (verticalSwiping) positionOffset = touchObject.curY > touchObject.startY ? 1 : -1;\n  var dotCount = Math.ceil(slideCount / slidesToScroll);\n  var swipeDirection = getSwipeDirection(spec.touchObject, verticalSwiping);\n  var touchSwipeLength = touchObject.swipeLength;\n\n  if (!infinite) {\n    if (currentSlide === 0 && (swipeDirection === \"right\" || swipeDirection === \"down\") || currentSlide + 1 >= dotCount && (swipeDirection === \"left\" || swipeDirection === \"up\") || !canGoNext(spec) && (swipeDirection === \"left\" || swipeDirection === \"up\")) {\n      touchSwipeLength = touchObject.swipeLength * edgeFriction;\n\n      if (edgeDragged === false && onEdge) {\n        onEdge(swipeDirection);\n        state[\"edgeDragged\"] = true;\n      }\n    }\n  }\n\n  if (!swiped && swipeEvent) {\n    swipeEvent(swipeDirection);\n    state[\"swiped\"] = true;\n  }\n\n  if (!vertical) {\n    if (!rtl) {\n      swipeLeft = curLeft + touchSwipeLength * positionOffset;\n    } else {\n      swipeLeft = curLeft - touchSwipeLength * positionOffset;\n    }\n  } else {\n    swipeLeft = curLeft + touchSwipeLength * (listHeight / listWidth) * positionOffset;\n  }\n\n  if (verticalSwiping) {\n    swipeLeft = curLeft + touchSwipeLength * positionOffset;\n  }\n\n  state = _objectSpread(_objectSpread({}, state), {}, {\n    touchObject: touchObject,\n    swipeLeft: swipeLeft,\n    trackStyle: getTrackCSS(_objectSpread(_objectSpread({}, spec), {}, {\n      left: swipeLeft\n    }))\n  });\n\n  if (Math.abs(touchObject.curX - touchObject.startX) < Math.abs(touchObject.curY - touchObject.startY) * 0.8) {\n    return state;\n  }\n\n  if (touchObject.swipeLength > 10) {\n    state[\"swiping\"] = true;\n    safePreventDefault(e);\n  }\n\n  return state;\n};\n\nexports.swipeMove = swipeMove;\n\nvar swipeEnd = function swipeEnd(e, spec) {\n  var dragging = spec.dragging,\n      swipe = spec.swipe,\n      touchObject = spec.touchObject,\n      listWidth = spec.listWidth,\n      touchThreshold = spec.touchThreshold,\n      verticalSwiping = spec.verticalSwiping,\n      listHeight = spec.listHeight,\n      swipeToSlide = spec.swipeToSlide,\n      scrolling = spec.scrolling,\n      onSwipe = spec.onSwipe,\n      targetSlide = spec.targetSlide,\n      currentSlide = spec.currentSlide,\n      infinite = spec.infinite;\n\n  if (!dragging) {\n    if (swipe) safePreventDefault(e);\n    return {};\n  }\n\n  var minSwipe = verticalSwiping ? listHeight / touchThreshold : listWidth / touchThreshold;\n  var swipeDirection = getSwipeDirection(touchObject, verticalSwiping); // reset the state of touch related state variables.\n\n  var state = {\n    dragging: false,\n    edgeDragged: false,\n    scrolling: false,\n    swiping: false,\n    swiped: false,\n    swipeLeft: null,\n    touchObject: {}\n  };\n\n  if (scrolling) {\n    return state;\n  }\n\n  if (!touchObject.swipeLength) {\n    return state;\n  }\n\n  if (touchObject.swipeLength > minSwipe) {\n    safePreventDefault(e);\n\n    if (onSwipe) {\n      onSwipe(swipeDirection);\n    }\n\n    var slideCount, newSlide;\n    var activeSlide = infinite ? currentSlide : targetSlide;\n\n    switch (swipeDirection) {\n      case \"left\":\n      case \"up\":\n        newSlide = activeSlide + getSlideCount(spec);\n        slideCount = swipeToSlide ? checkNavigable(spec, newSlide) : newSlide;\n        state[\"currentDirection\"] = 0;\n        break;\n\n      case \"right\":\n      case \"down\":\n        newSlide = activeSlide - getSlideCount(spec);\n        slideCount = swipeToSlide ? checkNavigable(spec, newSlide) : newSlide;\n        state[\"currentDirection\"] = 1;\n        break;\n\n      default:\n        slideCount = activeSlide;\n    }\n\n    state[\"triggerSlideHandler\"] = slideCount;\n  } else {\n    // Adjust the track back to it's original position.\n    var currentLeft = getTrackLeft(spec);\n    state[\"trackStyle\"] = getTrackAnimateCSS(_objectSpread(_objectSpread({}, spec), {}, {\n      left: currentLeft\n    }));\n  }\n\n  return state;\n};\n\nexports.swipeEnd = swipeEnd;\n\nvar getNavigableIndexes = function getNavigableIndexes(spec) {\n  var max = spec.infinite ? spec.slideCount * 2 : spec.slideCount;\n  var breakpoint = spec.infinite ? spec.slidesToShow * -1 : 0;\n  var counter = spec.infinite ? spec.slidesToShow * -1 : 0;\n  var indexes = [];\n\n  while (breakpoint < max) {\n    indexes.push(breakpoint);\n    breakpoint = counter + spec.slidesToScroll;\n    counter += Math.min(spec.slidesToScroll, spec.slidesToShow);\n  }\n\n  return indexes;\n};\n\nexports.getNavigableIndexes = getNavigableIndexes;\n\nvar checkNavigable = function checkNavigable(spec, index) {\n  var navigables = getNavigableIndexes(spec);\n  var prevNavigable = 0;\n\n  if (index > navigables[navigables.length - 1]) {\n    index = navigables[navigables.length - 1];\n  } else {\n    for (var n in navigables) {\n      if (index < navigables[n]) {\n        index = prevNavigable;\n        break;\n      }\n\n      prevNavigable = navigables[n];\n    }\n  }\n\n  return index;\n};\n\nexports.checkNavigable = checkNavigable;\n\nvar getSlideCount = function getSlideCount(spec) {\n  var centerOffset = spec.centerMode ? spec.slideWidth * Math.floor(spec.slidesToShow / 2) : 0;\n\n  if (spec.swipeToSlide) {\n    var swipedSlide;\n    var slickList = spec.listRef;\n    var slides = slickList.querySelectorAll && slickList.querySelectorAll(\".slick-slide\") || [];\n    Array.from(slides).every(function (slide) {\n      if (!spec.vertical) {\n        if (slide.offsetLeft - centerOffset + getWidth(slide) / 2 > spec.swipeLeft * -1) {\n          swipedSlide = slide;\n          return false;\n        }\n      } else {\n        if (slide.offsetTop + getHeight(slide) / 2 > spec.swipeLeft * -1) {\n          swipedSlide = slide;\n          return false;\n        }\n      }\n\n      return true;\n    });\n\n    if (!swipedSlide) {\n      return 0;\n    }\n\n    var currentIndex = spec.rtl === true ? spec.slideCount - spec.currentSlide : spec.currentSlide;\n    var slidesTraversed = Math.abs(swipedSlide.dataset.index - currentIndex) || 1;\n    return slidesTraversed;\n  } else {\n    return spec.slidesToScroll;\n  }\n};\n\nexports.getSlideCount = getSlideCount;\n\nvar checkSpecKeys = function checkSpecKeys(spec, keysArray) {\n  return keysArray.reduce(function (value, key) {\n    return value && spec.hasOwnProperty(key);\n  }, true) ? null : console.error(\"Keys Missing:\", spec);\n};\n\nexports.checkSpecKeys = checkSpecKeys;\n\nvar getTrackCSS = function getTrackCSS(spec) {\n  checkSpecKeys(spec, [\"left\", \"variableWidth\", \"slideCount\", \"slidesToShow\", \"slideWidth\"]);\n  var trackWidth, trackHeight;\n  var trackChildren = spec.slideCount + 2 * spec.slidesToShow;\n\n  if (!spec.vertical) {\n    trackWidth = getTotalSlides(spec) * spec.slideWidth;\n  } else {\n    trackHeight = trackChildren * spec.slideHeight;\n  }\n\n  var style = {\n    opacity: 1,\n    transition: \"\",\n    WebkitTransition: \"\"\n  };\n\n  if (spec.useTransform) {\n    var WebkitTransform = !spec.vertical ? \"translate3d(\" + spec.left + \"px, 0px, 0px)\" : \"translate3d(0px, \" + spec.left + \"px, 0px)\";\n    var transform = !spec.vertical ? \"translate3d(\" + spec.left + \"px, 0px, 0px)\" : \"translate3d(0px, \" + spec.left + \"px, 0px)\";\n    var msTransform = !spec.vertical ? \"translateX(\" + spec.left + \"px)\" : \"translateY(\" + spec.left + \"px)\";\n    style = _objectSpread(_objectSpread({}, style), {}, {\n      WebkitTransform: WebkitTransform,\n      transform: transform,\n      msTransform: msTransform\n    });\n  } else {\n    if (spec.vertical) {\n      style[\"top\"] = spec.left;\n    } else {\n      style[\"left\"] = spec.left;\n    }\n  }\n\n  if (spec.fade) style = {\n    opacity: 1\n  };\n  if (trackWidth) style.width = trackWidth;\n  if (trackHeight) style.height = trackHeight; // Fallback for IE8\n\n  if (window && !window.addEventListener && window.attachEvent) {\n    if (!spec.vertical) {\n      style.marginLeft = spec.left + \"px\";\n    } else {\n      style.marginTop = spec.left + \"px\";\n    }\n  }\n\n  return style;\n};\n\nexports.getTrackCSS = getTrackCSS;\n\nvar getTrackAnimateCSS = function getTrackAnimateCSS(spec) {\n  checkSpecKeys(spec, [\"left\", \"variableWidth\", \"slideCount\", \"slidesToShow\", \"slideWidth\", \"speed\", \"cssEase\"]);\n  var style = getTrackCSS(spec); // useCSS is true by default so it can be undefined\n\n  if (spec.useTransform) {\n    style.WebkitTransition = \"-webkit-transform \" + spec.speed + \"ms \" + spec.cssEase;\n    style.transition = \"transform \" + spec.speed + \"ms \" + spec.cssEase;\n  } else {\n    if (spec.vertical) {\n      style.transition = \"top \" + spec.speed + \"ms \" + spec.cssEase;\n    } else {\n      style.transition = \"left \" + spec.speed + \"ms \" + spec.cssEase;\n    }\n  }\n\n  return style;\n};\n\nexports.getTrackAnimateCSS = getTrackAnimateCSS;\n\nvar getTrackLeft = function getTrackLeft(spec) {\n  if (spec.unslick) {\n    return 0;\n  }\n\n  checkSpecKeys(spec, [\"slideIndex\", \"trackRef\", \"infinite\", \"centerMode\", \"slideCount\", \"slidesToShow\", \"slidesToScroll\", \"slideWidth\", \"listWidth\", \"variableWidth\", \"slideHeight\"]);\n  var slideIndex = spec.slideIndex,\n      trackRef = spec.trackRef,\n      infinite = spec.infinite,\n      centerMode = spec.centerMode,\n      slideCount = spec.slideCount,\n      slidesToShow = spec.slidesToShow,\n      slidesToScroll = spec.slidesToScroll,\n      slideWidth = spec.slideWidth,\n      listWidth = spec.listWidth,\n      variableWidth = spec.variableWidth,\n      slideHeight = spec.slideHeight,\n      fade = spec.fade,\n      vertical = spec.vertical;\n  var slideOffset = 0;\n  var targetLeft;\n  var targetSlide;\n  var verticalOffset = 0;\n\n  if (fade || spec.slideCount === 1) {\n    return 0;\n  }\n\n  var slidesToOffset = 0;\n\n  if (infinite) {\n    slidesToOffset = -getPreClones(spec); // bring active slide to the beginning of visual area\n    // if next scroll doesn't have enough children, just reach till the end of original slides instead of shifting slidesToScroll children\n\n    if (slideCount % slidesToScroll !== 0 && slideIndex + slidesToScroll > slideCount) {\n      slidesToOffset = -(slideIndex > slideCount ? slidesToShow - (slideIndex - slideCount) : slideCount % slidesToScroll);\n    } // shift current slide to center of the frame\n\n\n    if (centerMode) {\n      slidesToOffset += parseInt(slidesToShow / 2);\n    }\n  } else {\n    if (slideCount % slidesToScroll !== 0 && slideIndex + slidesToScroll > slideCount) {\n      slidesToOffset = slidesToShow - slideCount % slidesToScroll;\n    }\n\n    if (centerMode) {\n      slidesToOffset = parseInt(slidesToShow / 2);\n    }\n  }\n\n  slideOffset = slidesToOffset * slideWidth;\n  verticalOffset = slidesToOffset * slideHeight;\n\n  if (!vertical) {\n    targetLeft = slideIndex * slideWidth * -1 + slideOffset;\n  } else {\n    targetLeft = slideIndex * slideHeight * -1 + verticalOffset;\n  }\n\n  if (variableWidth === true) {\n    var targetSlideIndex;\n    var trackElem = trackRef && trackRef.node;\n    targetSlideIndex = slideIndex + getPreClones(spec);\n    targetSlide = trackElem && trackElem.childNodes[targetSlideIndex];\n    targetLeft = targetSlide ? targetSlide.offsetLeft * -1 : 0;\n\n    if (centerMode === true) {\n      targetSlideIndex = infinite ? slideIndex + getPreClones(spec) : slideIndex;\n      targetSlide = trackElem && trackElem.children[targetSlideIndex];\n      targetLeft = 0;\n\n      for (var slide = 0; slide < targetSlideIndex; slide++) {\n        targetLeft -= trackElem && trackElem.children[slide] && trackElem.children[slide].offsetWidth;\n      }\n\n      targetLeft -= parseInt(spec.centerPadding);\n      targetLeft += targetSlide && (listWidth - targetSlide.offsetWidth) / 2;\n    }\n  }\n\n  return targetLeft;\n};\n\nexports.getTrackLeft = getTrackLeft;\n\nvar getPreClones = function getPreClones(spec) {\n  if (spec.unslick || !spec.infinite) {\n    return 0;\n  }\n\n  if (spec.variableWidth) {\n    return spec.slideCount;\n  }\n\n  return spec.slidesToShow + (spec.centerMode ? 1 : 0);\n};\n\nexports.getPreClones = getPreClones;\n\nvar getPostClones = function getPostClones(spec) {\n  if (spec.unslick || !spec.infinite) {\n    return 0;\n  }\n\n  return spec.slideCount;\n};\n\nexports.getPostClones = getPostClones;\n\nvar getTotalSlides = function getTotalSlides(spec) {\n  return spec.slideCount === 1 ? 1 : getPreClones(spec) + spec.slideCount + getPostClones(spec);\n};\n\nexports.getTotalSlides = getTotalSlides;\n\nvar siblingDirection = function siblingDirection(spec) {\n  if (spec.targetSlide > spec.currentSlide) {\n    if (spec.targetSlide > spec.currentSlide + slidesOnRight(spec)) {\n      return \"left\";\n    }\n\n    return \"right\";\n  } else {\n    if (spec.targetSlide < spec.currentSlide - slidesOnLeft(spec)) {\n      return \"right\";\n    }\n\n    return \"left\";\n  }\n};\n\nexports.siblingDirection = siblingDirection;\n\nvar slidesOnRight = function slidesOnRight(_ref) {\n  var slidesToShow = _ref.slidesToShow,\n      centerMode = _ref.centerMode,\n      rtl = _ref.rtl,\n      centerPadding = _ref.centerPadding;\n\n  // returns no of slides on the right of active slide\n  if (centerMode) {\n    var right = (slidesToShow - 1) / 2 + 1;\n    if (parseInt(centerPadding) > 0) right += 1;\n    if (rtl && slidesToShow % 2 === 0) right += 1;\n    return right;\n  }\n\n  if (rtl) {\n    return 0;\n  }\n\n  return slidesToShow - 1;\n};\n\nexports.slidesOnRight = slidesOnRight;\n\nvar slidesOnLeft = function slidesOnLeft(_ref2) {\n  var slidesToShow = _ref2.slidesToShow,\n      centerMode = _ref2.centerMode,\n      rtl = _ref2.rtl,\n      centerPadding = _ref2.centerPadding;\n\n  // returns no of slides on the left of active slide\n  if (centerMode) {\n    var left = (slidesToShow - 1) / 2 + 1;\n    if (parseInt(centerPadding) > 0) left += 1;\n    if (!rtl && slidesToShow % 2 === 0) left += 1;\n    return left;\n  }\n\n  if (rtl) {\n    return slidesToShow - 1;\n  }\n\n  return 0;\n};\n\nexports.slidesOnLeft = slidesOnLeft;\n\nvar canUseDOM = function canUseDOM() {\n  return !!(typeof window !== \"undefined\" && window.document && window.document.createElement);\n};\n\nexports.canUseDOM = canUseDOM;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvcmVhY3Qtc2xpY2svbGliL3V0aWxzL2lubmVyU2xpZGVyVXRpbHMuanMuanMiLCJtYXBwaW5ncyI6IkFBQWE7O0FBRWIsOENBQTZDO0FBQzdDO0FBQ0EsQ0FBQyxFQUFDO0FBQ0YscUJBQXFCLEdBQUcsc0JBQXNCLEdBQUcsbUJBQW1CLEdBQUcsaUJBQWlCLEdBQUcsaUJBQWlCO0FBQzVHLGFBQWE7QUFDYixrQkFBa0IsR0FBRyxpQkFBaUIsR0FBRyxnQkFBZ0IsR0FBRyxxQkFBcUIsR0FBRyxvQkFBb0IsR0FBRyxvQkFBb0IsR0FBRyx3QkFBd0IsR0FBRywwQkFBMEIsR0FBRyxzQkFBc0IsR0FBRyx5QkFBeUIsR0FBRyx3QkFBd0IsR0FBRyxvQkFBb0IsR0FBRyxrQkFBa0IsR0FBRyx3QkFBd0IsR0FBRyxnQkFBZ0IsR0FBRyxvQkFBb0IsR0FBRyxtQkFBbUIsR0FBRywwQkFBMEIsR0FBRyxzQkFBc0IsR0FBRyx5QkFBeUIsR0FBRyxxQkFBcUIsR0FBRyw2QkFBNkIsR0FBRyxvQkFBb0IsR0FBRyxxQkFBcUIsR0FBRyw2QkFBNkIsR0FBRywyQkFBMkIsR0FBRyxpQkFBaUIsR0FBRyxxQkFBcUI7O0FBRWpyQixvQ0FBb0MsbUJBQU8sQ0FBQyw0Q0FBTzs7QUFFbkQsdUNBQXVDLHVDQUF1Qzs7QUFFOUUsMkNBQTJDLGdDQUFnQyxvQ0FBb0Msb0RBQW9ELDZEQUE2RCxpRUFBaUUsc0NBQXNDOztBQUV2VSxpQ0FBaUMsZ0JBQWdCLHNCQUFzQixPQUFPLHVEQUF1RCw2REFBNkQsNENBQTRDLG9LQUFvSyxtRkFBbUYsS0FBSzs7QUFFMWUsNENBQTRDLGtCQUFrQixrQ0FBa0Msb0VBQW9FLEtBQUssT0FBTyxvQkFBb0I7O0FBRXBNO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBLDBCQUEwQjs7QUFFMUI7QUFDQTtBQUNBO0FBQ0E7O0FBRUEsb0NBQW9DLHVCQUF1QjtBQUMzRDtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBLEdBQUc7OztBQUdILDZCQUE2Qjs7QUFFN0I7QUFDQTtBQUNBO0FBQ0E7O0FBRUEsb0NBQW9DLHVCQUF1QjtBQUMzRDtBQUNBOztBQUVBO0FBQ0EsR0FBRzs7O0FBR0gsNkJBQTZCOztBQUU3QjtBQUNBO0FBQ0E7O0FBRUEsc0JBQXNCOztBQUV0QjtBQUNBO0FBQ0E7O0FBRUEsb0JBQW9COztBQUVwQjtBQUNBO0FBQ0E7O0FBRUEsd0JBQXdCOztBQUV4QjtBQUNBO0FBQ0EsR0FBRzs7O0FBR0gseUJBQXlCOztBQUV6QjtBQUNBO0FBQ0E7O0FBRUEsZ0JBQWdCOztBQUVoQjtBQUNBO0FBQ0E7O0FBRUEsaUJBQWlCOztBQUVqQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQSxNQUFNO0FBQ047QUFDQTtBQUNBOztBQUVBO0FBQ0EsR0FBRzs7O0FBR0gseUJBQXlCOztBQUV6QjtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLE1BQU07QUFDTjtBQUNBO0FBQ0E7O0FBRUE7QUFDQSxHQUFHOzs7QUFHSCxpQkFBaUI7O0FBRWpCO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0EsR0FBRzs7O0FBR0gscUJBQXFCOztBQUVyQjtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBLElBQUk7QUFDSjtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQSx5RUFBeUUsV0FBVztBQUNwRjtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUEsd0JBQXdCOztBQUV4QjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGdCQUFnQjtBQUNoQjtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBLE1BQU07QUFDTjtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLElBQUk7QUFDSjs7QUFFQTtBQUNBO0FBQ0Esb0NBQW9DO0FBQ3BDLE1BQU07QUFDTjtBQUNBLE1BQU07QUFDTjtBQUNBO0FBQ0EsTUFBTTtBQUNOO0FBQ0EsNERBQTREO0FBQzVEOztBQUVBO0FBQ0E7QUFDQTs7QUFFQSwrREFBK0QsV0FBVztBQUMxRTtBQUNBLEtBQUs7QUFDTCwyREFBMkQsV0FBVztBQUN0RTtBQUNBLEtBQUs7O0FBRUw7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQSxpR0FBaUcsV0FBVztBQUM1RztBQUNBLE9BQU87QUFDUDs7QUFFQTtBQUNBO0FBQ0E7QUFDQSw4REFBOEQsV0FBVztBQUN6RTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQSxNQUFNO0FBQ047QUFDQTtBQUNBO0FBQ0EscUVBQXFFLFdBQVc7QUFDaEY7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsOERBQThELFdBQVc7QUFDekU7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBLG9CQUFvQjs7QUFFcEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsSUFBSTtBQUNKO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLElBQUk7QUFDSjtBQUNBO0FBQ0EsSUFBSTtBQUNKO0FBQ0E7O0FBRUE7QUFDQSxxRUFBcUUsV0FBVztBQUNoRjtBQUNBLE9BQU87O0FBRVA7QUFDQTtBQUNBLFFBQVE7QUFDUjtBQUNBO0FBQ0E7QUFDQSxJQUFJO0FBQ0o7QUFDQTs7QUFFQTtBQUNBOztBQUVBLG1CQUFtQjs7QUFFbkI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBLGtCQUFrQjs7QUFFbEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUEsa0JBQWtCOztBQUVsQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLE1BQU07QUFDTjtBQUNBO0FBQ0EsSUFBSTtBQUNKO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBLHdDQUF3QyxZQUFZO0FBQ3BEO0FBQ0E7QUFDQSwwREFBMEQsV0FBVztBQUNyRTtBQUNBLEtBQUs7QUFDTCxHQUFHOztBQUVIO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBLGlCQUFpQjs7QUFFakI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBLHdFQUF3RTs7QUFFeEU7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0EsSUFBSTtBQUNKO0FBQ0E7QUFDQSwyRUFBMkUsV0FBVztBQUN0RjtBQUNBLEtBQUs7QUFDTDs7QUFFQTtBQUNBOztBQUVBLGdCQUFnQjs7QUFFaEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUEsMkJBQTJCOztBQUUzQjtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBLElBQUk7QUFDSjtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBLHNCQUFzQjs7QUFFdEI7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFFBQVE7QUFDUjtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0EsS0FBSzs7QUFFTDtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsSUFBSTtBQUNKO0FBQ0E7QUFDQTs7QUFFQSxxQkFBcUI7O0FBRXJCO0FBQ0E7QUFDQTtBQUNBLEdBQUc7QUFDSDs7QUFFQSxxQkFBcUI7O0FBRXJCO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQSxJQUFJO0FBQ0o7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsMENBQTBDLFlBQVk7QUFDdEQ7QUFDQTtBQUNBO0FBQ0EsS0FBSztBQUNMLElBQUk7QUFDSjtBQUNBO0FBQ0EsTUFBTTtBQUNOO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLCtDQUErQzs7QUFFL0M7QUFDQTtBQUNBO0FBQ0EsTUFBTTtBQUNOO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBLG1CQUFtQjs7QUFFbkI7QUFDQTtBQUNBLGlDQUFpQzs7QUFFakM7QUFDQTtBQUNBO0FBQ0EsSUFBSTtBQUNKO0FBQ0E7QUFDQSxNQUFNO0FBQ047QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUEsMEJBQTBCOztBQUUxQjtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBOztBQUVBO0FBQ0EsMENBQTBDO0FBQzFDOztBQUVBO0FBQ0E7QUFDQSxNQUFNOzs7QUFHTjtBQUNBO0FBQ0E7QUFDQSxJQUFJO0FBQ0o7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBLElBQUk7QUFDSjtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQSwwQkFBMEIsMEJBQTBCO0FBQ3BEO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQSxvQkFBb0I7O0FBRXBCO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBLG9CQUFvQjs7QUFFcEI7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQSxxQkFBcUI7O0FBRXJCO0FBQ0E7QUFDQTs7QUFFQSxzQkFBc0I7O0FBRXRCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQSxJQUFJO0FBQ0o7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQSx3QkFBd0I7O0FBRXhCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUEscUJBQXFCOztBQUVyQjtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBLG9CQUFvQjs7QUFFcEI7QUFDQTtBQUNBOztBQUVBLGlCQUFpQiIsInNvdXJjZXMiOlsid2VicGFjazovL19OX0UvLi9ub2RlX21vZHVsZXMvcmVhY3Qtc2xpY2svbGliL3V0aWxzL2lubmVyU2xpZGVyVXRpbHMuanM/YTk5YSJdLCJzb3VyY2VzQ29udGVudCI6WyJcInVzZSBzdHJpY3RcIjtcblxuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7XG4gIHZhbHVlOiB0cnVlXG59KTtcbmV4cG9ydHMuY2hlY2tTcGVjS2V5cyA9IGV4cG9ydHMuY2hlY2tOYXZpZ2FibGUgPSBleHBvcnRzLmNoYW5nZVNsaWRlID0gZXhwb3J0cy5jYW5Vc2VET00gPSBleHBvcnRzLmNhbkdvTmV4dCA9IHZvaWQgMDtcbmV4cG9ydHMuY2xhbXAgPSBjbGFtcDtcbmV4cG9ydHMuc3dpcGVTdGFydCA9IGV4cG9ydHMuc3dpcGVNb3ZlID0gZXhwb3J0cy5zd2lwZUVuZCA9IGV4cG9ydHMuc2xpZGVzT25SaWdodCA9IGV4cG9ydHMuc2xpZGVzT25MZWZ0ID0gZXhwb3J0cy5zbGlkZUhhbmRsZXIgPSBleHBvcnRzLnNpYmxpbmdEaXJlY3Rpb24gPSBleHBvcnRzLnNhZmVQcmV2ZW50RGVmYXVsdCA9IGV4cG9ydHMubGF6eVN0YXJ0SW5kZXggPSBleHBvcnRzLmxhenlTbGlkZXNPblJpZ2h0ID0gZXhwb3J0cy5sYXp5U2xpZGVzT25MZWZ0ID0gZXhwb3J0cy5sYXp5RW5kSW5kZXggPSBleHBvcnRzLmtleUhhbmRsZXIgPSBleHBvcnRzLmluaXRpYWxpemVkU3RhdGUgPSBleHBvcnRzLmdldFdpZHRoID0gZXhwb3J0cy5nZXRUcmFja0xlZnQgPSBleHBvcnRzLmdldFRyYWNrQ1NTID0gZXhwb3J0cy5nZXRUcmFja0FuaW1hdGVDU1MgPSBleHBvcnRzLmdldFRvdGFsU2xpZGVzID0gZXhwb3J0cy5nZXRTd2lwZURpcmVjdGlvbiA9IGV4cG9ydHMuZ2V0U2xpZGVDb3VudCA9IGV4cG9ydHMuZ2V0UmVxdWlyZWRMYXp5U2xpZGVzID0gZXhwb3J0cy5nZXRQcmVDbG9uZXMgPSBleHBvcnRzLmdldFBvc3RDbG9uZXMgPSBleHBvcnRzLmdldE9uRGVtYW5kTGF6eVNsaWRlcyA9IGV4cG9ydHMuZ2V0TmF2aWdhYmxlSW5kZXhlcyA9IGV4cG9ydHMuZ2V0SGVpZ2h0ID0gZXhwb3J0cy5leHRyYWN0T2JqZWN0ID0gdm9pZCAwO1xuXG52YXIgX3JlYWN0ID0gX2ludGVyb3BSZXF1aXJlRGVmYXVsdChyZXF1aXJlKFwicmVhY3RcIikpO1xuXG5mdW5jdGlvbiBfaW50ZXJvcFJlcXVpcmVEZWZhdWx0KG9iaikgeyByZXR1cm4gb2JqICYmIG9iai5fX2VzTW9kdWxlID8gb2JqIDogeyBcImRlZmF1bHRcIjogb2JqIH07IH1cblxuZnVuY3Rpb24gb3duS2V5cyhvYmplY3QsIGVudW1lcmFibGVPbmx5KSB7IHZhciBrZXlzID0gT2JqZWN0LmtleXMob2JqZWN0KTsgaWYgKE9iamVjdC5nZXRPd25Qcm9wZXJ0eVN5bWJvbHMpIHsgdmFyIHN5bWJvbHMgPSBPYmplY3QuZ2V0T3duUHJvcGVydHlTeW1ib2xzKG9iamVjdCk7IGVudW1lcmFibGVPbmx5ICYmIChzeW1ib2xzID0gc3ltYm9scy5maWx0ZXIoZnVuY3Rpb24gKHN5bSkgeyByZXR1cm4gT2JqZWN0LmdldE93blByb3BlcnR5RGVzY3JpcHRvcihvYmplY3QsIHN5bSkuZW51bWVyYWJsZTsgfSkpLCBrZXlzLnB1c2guYXBwbHkoa2V5cywgc3ltYm9scyk7IH0gcmV0dXJuIGtleXM7IH1cblxuZnVuY3Rpb24gX29iamVjdFNwcmVhZCh0YXJnZXQpIHsgZm9yICh2YXIgaSA9IDE7IGkgPCBhcmd1bWVudHMubGVuZ3RoOyBpKyspIHsgdmFyIHNvdXJjZSA9IG51bGwgIT0gYXJndW1lbnRzW2ldID8gYXJndW1lbnRzW2ldIDoge307IGkgJSAyID8gb3duS2V5cyhPYmplY3Qoc291cmNlKSwgITApLmZvckVhY2goZnVuY3Rpb24gKGtleSkgeyBfZGVmaW5lUHJvcGVydHkodGFyZ2V0LCBrZXksIHNvdXJjZVtrZXldKTsgfSkgOiBPYmplY3QuZ2V0T3duUHJvcGVydHlEZXNjcmlwdG9ycyA/IE9iamVjdC5kZWZpbmVQcm9wZXJ0aWVzKHRhcmdldCwgT2JqZWN0LmdldE93blByb3BlcnR5RGVzY3JpcHRvcnMoc291cmNlKSkgOiBvd25LZXlzKE9iamVjdChzb3VyY2UpKS5mb3JFYWNoKGZ1bmN0aW9uIChrZXkpIHsgT2JqZWN0LmRlZmluZVByb3BlcnR5KHRhcmdldCwga2V5LCBPYmplY3QuZ2V0T3duUHJvcGVydHlEZXNjcmlwdG9yKHNvdXJjZSwga2V5KSk7IH0pOyB9IHJldHVybiB0YXJnZXQ7IH1cblxuZnVuY3Rpb24gX2RlZmluZVByb3BlcnR5KG9iaiwga2V5LCB2YWx1ZSkgeyBpZiAoa2V5IGluIG9iaikgeyBPYmplY3QuZGVmaW5lUHJvcGVydHkob2JqLCBrZXksIHsgdmFsdWU6IHZhbHVlLCBlbnVtZXJhYmxlOiB0cnVlLCBjb25maWd1cmFibGU6IHRydWUsIHdyaXRhYmxlOiB0cnVlIH0pOyB9IGVsc2UgeyBvYmpba2V5XSA9IHZhbHVlOyB9IHJldHVybiBvYmo7IH1cblxuZnVuY3Rpb24gY2xhbXAobnVtYmVyLCBsb3dlckJvdW5kLCB1cHBlckJvdW5kKSB7XG4gIHJldHVybiBNYXRoLm1heChsb3dlckJvdW5kLCBNYXRoLm1pbihudW1iZXIsIHVwcGVyQm91bmQpKTtcbn1cblxudmFyIHNhZmVQcmV2ZW50RGVmYXVsdCA9IGZ1bmN0aW9uIHNhZmVQcmV2ZW50RGVmYXVsdChldmVudCkge1xuICB2YXIgcGFzc2l2ZUV2ZW50cyA9IFtcIm9uVG91Y2hTdGFydFwiLCBcIm9uVG91Y2hNb3ZlXCIsIFwib25XaGVlbFwiXTtcblxuICBpZiAoIXBhc3NpdmVFdmVudHMuaW5jbHVkZXMoZXZlbnQuX3JlYWN0TmFtZSkpIHtcbiAgICBldmVudC5wcmV2ZW50RGVmYXVsdCgpO1xuICB9XG59O1xuXG5leHBvcnRzLnNhZmVQcmV2ZW50RGVmYXVsdCA9IHNhZmVQcmV2ZW50RGVmYXVsdDtcblxudmFyIGdldE9uRGVtYW5kTGF6eVNsaWRlcyA9IGZ1bmN0aW9uIGdldE9uRGVtYW5kTGF6eVNsaWRlcyhzcGVjKSB7XG4gIHZhciBvbkRlbWFuZFNsaWRlcyA9IFtdO1xuICB2YXIgc3RhcnRJbmRleCA9IGxhenlTdGFydEluZGV4KHNwZWMpO1xuICB2YXIgZW5kSW5kZXggPSBsYXp5RW5kSW5kZXgoc3BlYyk7XG5cbiAgZm9yICh2YXIgc2xpZGVJbmRleCA9IHN0YXJ0SW5kZXg7IHNsaWRlSW5kZXggPCBlbmRJbmRleDsgc2xpZGVJbmRleCsrKSB7XG4gICAgaWYgKHNwZWMubGF6eUxvYWRlZExpc3QuaW5kZXhPZihzbGlkZUluZGV4KSA8IDApIHtcbiAgICAgIG9uRGVtYW5kU2xpZGVzLnB1c2goc2xpZGVJbmRleCk7XG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIG9uRGVtYW5kU2xpZGVzO1xufTsgLy8gcmV0dXJuIGxpc3Qgb2Ygc2xpZGVzIHRoYXQgbmVlZCB0byBiZSBwcmVzZW50XG5cblxuZXhwb3J0cy5nZXRPbkRlbWFuZExhenlTbGlkZXMgPSBnZXRPbkRlbWFuZExhenlTbGlkZXM7XG5cbnZhciBnZXRSZXF1aXJlZExhenlTbGlkZXMgPSBmdW5jdGlvbiBnZXRSZXF1aXJlZExhenlTbGlkZXMoc3BlYykge1xuICB2YXIgcmVxdWlyZWRTbGlkZXMgPSBbXTtcbiAgdmFyIHN0YXJ0SW5kZXggPSBsYXp5U3RhcnRJbmRleChzcGVjKTtcbiAgdmFyIGVuZEluZGV4ID0gbGF6eUVuZEluZGV4KHNwZWMpO1xuXG4gIGZvciAodmFyIHNsaWRlSW5kZXggPSBzdGFydEluZGV4OyBzbGlkZUluZGV4IDwgZW5kSW5kZXg7IHNsaWRlSW5kZXgrKykge1xuICAgIHJlcXVpcmVkU2xpZGVzLnB1c2goc2xpZGVJbmRleCk7XG4gIH1cblxuICByZXR1cm4gcmVxdWlyZWRTbGlkZXM7XG59OyAvLyBzdGFydEluZGV4IHRoYXQgbmVlZHMgdG8gYmUgcHJlc2VudFxuXG5cbmV4cG9ydHMuZ2V0UmVxdWlyZWRMYXp5U2xpZGVzID0gZ2V0UmVxdWlyZWRMYXp5U2xpZGVzO1xuXG52YXIgbGF6eVN0YXJ0SW5kZXggPSBmdW5jdGlvbiBsYXp5U3RhcnRJbmRleChzcGVjKSB7XG4gIHJldHVybiBzcGVjLmN1cnJlbnRTbGlkZSAtIGxhenlTbGlkZXNPbkxlZnQoc3BlYyk7XG59O1xuXG5leHBvcnRzLmxhenlTdGFydEluZGV4ID0gbGF6eVN0YXJ0SW5kZXg7XG5cbnZhciBsYXp5RW5kSW5kZXggPSBmdW5jdGlvbiBsYXp5RW5kSW5kZXgoc3BlYykge1xuICByZXR1cm4gc3BlYy5jdXJyZW50U2xpZGUgKyBsYXp5U2xpZGVzT25SaWdodChzcGVjKTtcbn07XG5cbmV4cG9ydHMubGF6eUVuZEluZGV4ID0gbGF6eUVuZEluZGV4O1xuXG52YXIgbGF6eVNsaWRlc09uTGVmdCA9IGZ1bmN0aW9uIGxhenlTbGlkZXNPbkxlZnQoc3BlYykge1xuICByZXR1cm4gc3BlYy5jZW50ZXJNb2RlID8gTWF0aC5mbG9vcihzcGVjLnNsaWRlc1RvU2hvdyAvIDIpICsgKHBhcnNlSW50KHNwZWMuY2VudGVyUGFkZGluZykgPiAwID8gMSA6IDApIDogMDtcbn07XG5cbmV4cG9ydHMubGF6eVNsaWRlc09uTGVmdCA9IGxhenlTbGlkZXNPbkxlZnQ7XG5cbnZhciBsYXp5U2xpZGVzT25SaWdodCA9IGZ1bmN0aW9uIGxhenlTbGlkZXNPblJpZ2h0KHNwZWMpIHtcbiAgcmV0dXJuIHNwZWMuY2VudGVyTW9kZSA/IE1hdGguZmxvb3IoKHNwZWMuc2xpZGVzVG9TaG93IC0gMSkgLyAyKSArIDEgKyAocGFyc2VJbnQoc3BlYy5jZW50ZXJQYWRkaW5nKSA+IDAgPyAxIDogMCkgOiBzcGVjLnNsaWRlc1RvU2hvdztcbn07IC8vIGdldCB3aWR0aCBvZiBhbiBlbGVtZW50XG5cblxuZXhwb3J0cy5sYXp5U2xpZGVzT25SaWdodCA9IGxhenlTbGlkZXNPblJpZ2h0O1xuXG52YXIgZ2V0V2lkdGggPSBmdW5jdGlvbiBnZXRXaWR0aChlbGVtKSB7XG4gIHJldHVybiBlbGVtICYmIGVsZW0ub2Zmc2V0V2lkdGggfHwgMDtcbn07XG5cbmV4cG9ydHMuZ2V0V2lkdGggPSBnZXRXaWR0aDtcblxudmFyIGdldEhlaWdodCA9IGZ1bmN0aW9uIGdldEhlaWdodChlbGVtKSB7XG4gIHJldHVybiBlbGVtICYmIGVsZW0ub2Zmc2V0SGVpZ2h0IHx8IDA7XG59O1xuXG5leHBvcnRzLmdldEhlaWdodCA9IGdldEhlaWdodDtcblxudmFyIGdldFN3aXBlRGlyZWN0aW9uID0gZnVuY3Rpb24gZ2V0U3dpcGVEaXJlY3Rpb24odG91Y2hPYmplY3QpIHtcbiAgdmFyIHZlcnRpY2FsU3dpcGluZyA9IGFyZ3VtZW50cy5sZW5ndGggPiAxICYmIGFyZ3VtZW50c1sxXSAhPT0gdW5kZWZpbmVkID8gYXJndW1lbnRzWzFdIDogZmFsc2U7XG4gIHZhciB4RGlzdCwgeURpc3QsIHIsIHN3aXBlQW5nbGU7XG4gIHhEaXN0ID0gdG91Y2hPYmplY3Quc3RhcnRYIC0gdG91Y2hPYmplY3QuY3VyWDtcbiAgeURpc3QgPSB0b3VjaE9iamVjdC5zdGFydFkgLSB0b3VjaE9iamVjdC5jdXJZO1xuICByID0gTWF0aC5hdGFuMih5RGlzdCwgeERpc3QpO1xuICBzd2lwZUFuZ2xlID0gTWF0aC5yb3VuZChyICogMTgwIC8gTWF0aC5QSSk7XG5cbiAgaWYgKHN3aXBlQW5nbGUgPCAwKSB7XG4gICAgc3dpcGVBbmdsZSA9IDM2MCAtIE1hdGguYWJzKHN3aXBlQW5nbGUpO1xuICB9XG5cbiAgaWYgKHN3aXBlQW5nbGUgPD0gNDUgJiYgc3dpcGVBbmdsZSA+PSAwIHx8IHN3aXBlQW5nbGUgPD0gMzYwICYmIHN3aXBlQW5nbGUgPj0gMzE1KSB7XG4gICAgcmV0dXJuIFwibGVmdFwiO1xuICB9XG5cbiAgaWYgKHN3aXBlQW5nbGUgPj0gMTM1ICYmIHN3aXBlQW5nbGUgPD0gMjI1KSB7XG4gICAgcmV0dXJuIFwicmlnaHRcIjtcbiAgfVxuXG4gIGlmICh2ZXJ0aWNhbFN3aXBpbmcgPT09IHRydWUpIHtcbiAgICBpZiAoc3dpcGVBbmdsZSA+PSAzNSAmJiBzd2lwZUFuZ2xlIDw9IDEzNSkge1xuICAgICAgcmV0dXJuIFwidXBcIjtcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIFwiZG93blwiO1xuICAgIH1cbiAgfVxuXG4gIHJldHVybiBcInZlcnRpY2FsXCI7XG59OyAvLyB3aGV0aGVyIG9yIG5vdCB3ZSBjYW4gZ28gbmV4dFxuXG5cbmV4cG9ydHMuZ2V0U3dpcGVEaXJlY3Rpb24gPSBnZXRTd2lwZURpcmVjdGlvbjtcblxudmFyIGNhbkdvTmV4dCA9IGZ1bmN0aW9uIGNhbkdvTmV4dChzcGVjKSB7XG4gIHZhciBjYW5HbyA9IHRydWU7XG5cbiAgaWYgKCFzcGVjLmluZmluaXRlKSB7XG4gICAgaWYgKHNwZWMuY2VudGVyTW9kZSAmJiBzcGVjLmN1cnJlbnRTbGlkZSA+PSBzcGVjLnNsaWRlQ291bnQgLSAxKSB7XG4gICAgICBjYW5HbyA9IGZhbHNlO1xuICAgIH0gZWxzZSBpZiAoc3BlYy5zbGlkZUNvdW50IDw9IHNwZWMuc2xpZGVzVG9TaG93IHx8IHNwZWMuY3VycmVudFNsaWRlID49IHNwZWMuc2xpZGVDb3VudCAtIHNwZWMuc2xpZGVzVG9TaG93KSB7XG4gICAgICBjYW5HbyA9IGZhbHNlO1xuICAgIH1cbiAgfVxuXG4gIHJldHVybiBjYW5Hbztcbn07IC8vIGdpdmVuIGFuIG9iamVjdCBhbmQgYSBsaXN0IG9mIGtleXMsIHJldHVybiBuZXcgb2JqZWN0IHdpdGggZ2l2ZW4ga2V5c1xuXG5cbmV4cG9ydHMuY2FuR29OZXh0ID0gY2FuR29OZXh0O1xuXG52YXIgZXh0cmFjdE9iamVjdCA9IGZ1bmN0aW9uIGV4dHJhY3RPYmplY3Qoc3BlYywga2V5cykge1xuICB2YXIgbmV3T2JqZWN0ID0ge307XG4gIGtleXMuZm9yRWFjaChmdW5jdGlvbiAoa2V5KSB7XG4gICAgcmV0dXJuIG5ld09iamVjdFtrZXldID0gc3BlY1trZXldO1xuICB9KTtcbiAgcmV0dXJuIG5ld09iamVjdDtcbn07IC8vIGdldCBpbml0aWFsaXplZCBzdGF0ZVxuXG5cbmV4cG9ydHMuZXh0cmFjdE9iamVjdCA9IGV4dHJhY3RPYmplY3Q7XG5cbnZhciBpbml0aWFsaXplZFN0YXRlID0gZnVuY3Rpb24gaW5pdGlhbGl6ZWRTdGF0ZShzcGVjKSB7XG4gIC8vIHNwZWMgYWxzbyBjb250YWlucyBsaXN0UmVmLCB0cmFja1JlZlxuICB2YXIgc2xpZGVDb3VudCA9IF9yZWFjdFtcImRlZmF1bHRcIl0uQ2hpbGRyZW4uY291bnQoc3BlYy5jaGlsZHJlbik7XG5cbiAgdmFyIGxpc3ROb2RlID0gc3BlYy5saXN0UmVmO1xuICB2YXIgbGlzdFdpZHRoID0gTWF0aC5jZWlsKGdldFdpZHRoKGxpc3ROb2RlKSk7XG4gIHZhciB0cmFja05vZGUgPSBzcGVjLnRyYWNrUmVmICYmIHNwZWMudHJhY2tSZWYubm9kZTtcbiAgdmFyIHRyYWNrV2lkdGggPSBNYXRoLmNlaWwoZ2V0V2lkdGgodHJhY2tOb2RlKSk7XG4gIHZhciBzbGlkZVdpZHRoO1xuXG4gIGlmICghc3BlYy52ZXJ0aWNhbCkge1xuICAgIHZhciBjZW50ZXJQYWRkaW5nQWRqID0gc3BlYy5jZW50ZXJNb2RlICYmIHBhcnNlSW50KHNwZWMuY2VudGVyUGFkZGluZykgKiAyO1xuXG4gICAgaWYgKHR5cGVvZiBzcGVjLmNlbnRlclBhZGRpbmcgPT09IFwic3RyaW5nXCIgJiYgc3BlYy5jZW50ZXJQYWRkaW5nLnNsaWNlKC0xKSA9PT0gXCIlXCIpIHtcbiAgICAgIGNlbnRlclBhZGRpbmdBZGogKj0gbGlzdFdpZHRoIC8gMTAwO1xuICAgIH1cblxuICAgIHNsaWRlV2lkdGggPSBNYXRoLmNlaWwoKGxpc3RXaWR0aCAtIGNlbnRlclBhZGRpbmdBZGopIC8gc3BlYy5zbGlkZXNUb1Nob3cpO1xuICB9IGVsc2Uge1xuICAgIHNsaWRlV2lkdGggPSBsaXN0V2lkdGg7XG4gIH1cblxuICB2YXIgc2xpZGVIZWlnaHQgPSBsaXN0Tm9kZSAmJiBnZXRIZWlnaHQobGlzdE5vZGUucXVlcnlTZWxlY3RvcignW2RhdGEtaW5kZXg9XCIwXCJdJykpO1xuICB2YXIgbGlzdEhlaWdodCA9IHNsaWRlSGVpZ2h0ICogc3BlYy5zbGlkZXNUb1Nob3c7XG4gIHZhciBjdXJyZW50U2xpZGUgPSBzcGVjLmN1cnJlbnRTbGlkZSA9PT0gdW5kZWZpbmVkID8gc3BlYy5pbml0aWFsU2xpZGUgOiBzcGVjLmN1cnJlbnRTbGlkZTtcblxuICBpZiAoc3BlYy5ydGwgJiYgc3BlYy5jdXJyZW50U2xpZGUgPT09IHVuZGVmaW5lZCkge1xuICAgIGN1cnJlbnRTbGlkZSA9IHNsaWRlQ291bnQgLSAxIC0gc3BlYy5pbml0aWFsU2xpZGU7XG4gIH1cblxuICB2YXIgbGF6eUxvYWRlZExpc3QgPSBzcGVjLmxhenlMb2FkZWRMaXN0IHx8IFtdO1xuICB2YXIgc2xpZGVzVG9Mb2FkID0gZ2V0T25EZW1hbmRMYXp5U2xpZGVzKF9vYmplY3RTcHJlYWQoX29iamVjdFNwcmVhZCh7fSwgc3BlYyksIHt9LCB7XG4gICAgY3VycmVudFNsaWRlOiBjdXJyZW50U2xpZGUsXG4gICAgbGF6eUxvYWRlZExpc3Q6IGxhenlMb2FkZWRMaXN0XG4gIH0pKTtcbiAgbGF6eUxvYWRlZExpc3QgPSBsYXp5TG9hZGVkTGlzdC5jb25jYXQoc2xpZGVzVG9Mb2FkKTtcbiAgdmFyIHN0YXRlID0ge1xuICAgIHNsaWRlQ291bnQ6IHNsaWRlQ291bnQsXG4gICAgc2xpZGVXaWR0aDogc2xpZGVXaWR0aCxcbiAgICBsaXN0V2lkdGg6IGxpc3RXaWR0aCxcbiAgICB0cmFja1dpZHRoOiB0cmFja1dpZHRoLFxuICAgIGN1cnJlbnRTbGlkZTogY3VycmVudFNsaWRlLFxuICAgIHNsaWRlSGVpZ2h0OiBzbGlkZUhlaWdodCxcbiAgICBsaXN0SGVpZ2h0OiBsaXN0SGVpZ2h0LFxuICAgIGxhenlMb2FkZWRMaXN0OiBsYXp5TG9hZGVkTGlzdFxuICB9O1xuXG4gIGlmIChzcGVjLmF1dG9wbGF5aW5nID09PSBudWxsICYmIHNwZWMuYXV0b3BsYXkpIHtcbiAgICBzdGF0ZVtcImF1dG9wbGF5aW5nXCJdID0gXCJwbGF5aW5nXCI7XG4gIH1cblxuICByZXR1cm4gc3RhdGU7XG59O1xuXG5leHBvcnRzLmluaXRpYWxpemVkU3RhdGUgPSBpbml0aWFsaXplZFN0YXRlO1xuXG52YXIgc2xpZGVIYW5kbGVyID0gZnVuY3Rpb24gc2xpZGVIYW5kbGVyKHNwZWMpIHtcbiAgdmFyIHdhaXRGb3JBbmltYXRlID0gc3BlYy53YWl0Rm9yQW5pbWF0ZSxcbiAgICAgIGFuaW1hdGluZyA9IHNwZWMuYW5pbWF0aW5nLFxuICAgICAgZmFkZSA9IHNwZWMuZmFkZSxcbiAgICAgIGluZmluaXRlID0gc3BlYy5pbmZpbml0ZSxcbiAgICAgIGluZGV4ID0gc3BlYy5pbmRleCxcbiAgICAgIHNsaWRlQ291bnQgPSBzcGVjLnNsaWRlQ291bnQsXG4gICAgICBsYXp5TG9hZCA9IHNwZWMubGF6eUxvYWQsXG4gICAgICBjdXJyZW50U2xpZGUgPSBzcGVjLmN1cnJlbnRTbGlkZSxcbiAgICAgIGNlbnRlck1vZGUgPSBzcGVjLmNlbnRlck1vZGUsXG4gICAgICBzbGlkZXNUb1Njcm9sbCA9IHNwZWMuc2xpZGVzVG9TY3JvbGwsXG4gICAgICBzbGlkZXNUb1Nob3cgPSBzcGVjLnNsaWRlc1RvU2hvdyxcbiAgICAgIHVzZUNTUyA9IHNwZWMudXNlQ1NTO1xuICB2YXIgbGF6eUxvYWRlZExpc3QgPSBzcGVjLmxhenlMb2FkZWRMaXN0O1xuICBpZiAod2FpdEZvckFuaW1hdGUgJiYgYW5pbWF0aW5nKSByZXR1cm4ge307XG4gIHZhciBhbmltYXRpb25TbGlkZSA9IGluZGV4LFxuICAgICAgZmluYWxTbGlkZSxcbiAgICAgIGFuaW1hdGlvbkxlZnQsXG4gICAgICBmaW5hbExlZnQ7XG4gIHZhciBzdGF0ZSA9IHt9LFxuICAgICAgbmV4dFN0YXRlID0ge307XG4gIHZhciB0YXJnZXRTbGlkZSA9IGluZmluaXRlID8gaW5kZXggOiBjbGFtcChpbmRleCwgMCwgc2xpZGVDb3VudCAtIDEpO1xuXG4gIGlmIChmYWRlKSB7XG4gICAgaWYgKCFpbmZpbml0ZSAmJiAoaW5kZXggPCAwIHx8IGluZGV4ID49IHNsaWRlQ291bnQpKSByZXR1cm4ge307XG5cbiAgICBpZiAoaW5kZXggPCAwKSB7XG4gICAgICBhbmltYXRpb25TbGlkZSA9IGluZGV4ICsgc2xpZGVDb3VudDtcbiAgICB9IGVsc2UgaWYgKGluZGV4ID49IHNsaWRlQ291bnQpIHtcbiAgICAgIGFuaW1hdGlvblNsaWRlID0gaW5kZXggLSBzbGlkZUNvdW50O1xuICAgIH1cblxuICAgIGlmIChsYXp5TG9hZCAmJiBsYXp5TG9hZGVkTGlzdC5pbmRleE9mKGFuaW1hdGlvblNsaWRlKSA8IDApIHtcbiAgICAgIGxhenlMb2FkZWRMaXN0ID0gbGF6eUxvYWRlZExpc3QuY29uY2F0KGFuaW1hdGlvblNsaWRlKTtcbiAgICB9XG5cbiAgICBzdGF0ZSA9IHtcbiAgICAgIGFuaW1hdGluZzogdHJ1ZSxcbiAgICAgIGN1cnJlbnRTbGlkZTogYW5pbWF0aW9uU2xpZGUsXG4gICAgICBsYXp5TG9hZGVkTGlzdDogbGF6eUxvYWRlZExpc3QsXG4gICAgICB0YXJnZXRTbGlkZTogYW5pbWF0aW9uU2xpZGVcbiAgICB9O1xuICAgIG5leHRTdGF0ZSA9IHtcbiAgICAgIGFuaW1hdGluZzogZmFsc2UsXG4gICAgICB0YXJnZXRTbGlkZTogYW5pbWF0aW9uU2xpZGVcbiAgICB9O1xuICB9IGVsc2Uge1xuICAgIGZpbmFsU2xpZGUgPSBhbmltYXRpb25TbGlkZTtcblxuICAgIGlmIChhbmltYXRpb25TbGlkZSA8IDApIHtcbiAgICAgIGZpbmFsU2xpZGUgPSBhbmltYXRpb25TbGlkZSArIHNsaWRlQ291bnQ7XG4gICAgICBpZiAoIWluZmluaXRlKSBmaW5hbFNsaWRlID0gMDtlbHNlIGlmIChzbGlkZUNvdW50ICUgc2xpZGVzVG9TY3JvbGwgIT09IDApIGZpbmFsU2xpZGUgPSBzbGlkZUNvdW50IC0gc2xpZGVDb3VudCAlIHNsaWRlc1RvU2Nyb2xsO1xuICAgIH0gZWxzZSBpZiAoIWNhbkdvTmV4dChzcGVjKSAmJiBhbmltYXRpb25TbGlkZSA+IGN1cnJlbnRTbGlkZSkge1xuICAgICAgYW5pbWF0aW9uU2xpZGUgPSBmaW5hbFNsaWRlID0gY3VycmVudFNsaWRlO1xuICAgIH0gZWxzZSBpZiAoY2VudGVyTW9kZSAmJiBhbmltYXRpb25TbGlkZSA+PSBzbGlkZUNvdW50KSB7XG4gICAgICBhbmltYXRpb25TbGlkZSA9IGluZmluaXRlID8gc2xpZGVDb3VudCA6IHNsaWRlQ291bnQgLSAxO1xuICAgICAgZmluYWxTbGlkZSA9IGluZmluaXRlID8gMCA6IHNsaWRlQ291bnQgLSAxO1xuICAgIH0gZWxzZSBpZiAoYW5pbWF0aW9uU2xpZGUgPj0gc2xpZGVDb3VudCkge1xuICAgICAgZmluYWxTbGlkZSA9IGFuaW1hdGlvblNsaWRlIC0gc2xpZGVDb3VudDtcbiAgICAgIGlmICghaW5maW5pdGUpIGZpbmFsU2xpZGUgPSBzbGlkZUNvdW50IC0gc2xpZGVzVG9TaG93O2Vsc2UgaWYgKHNsaWRlQ291bnQgJSBzbGlkZXNUb1Njcm9sbCAhPT0gMCkgZmluYWxTbGlkZSA9IDA7XG4gICAgfVxuXG4gICAgaWYgKCFpbmZpbml0ZSAmJiBhbmltYXRpb25TbGlkZSArIHNsaWRlc1RvU2hvdyA+PSBzbGlkZUNvdW50KSB7XG4gICAgICBmaW5hbFNsaWRlID0gc2xpZGVDb3VudCAtIHNsaWRlc1RvU2hvdztcbiAgICB9XG5cbiAgICBhbmltYXRpb25MZWZ0ID0gZ2V0VHJhY2tMZWZ0KF9vYmplY3RTcHJlYWQoX29iamVjdFNwcmVhZCh7fSwgc3BlYyksIHt9LCB7XG4gICAgICBzbGlkZUluZGV4OiBhbmltYXRpb25TbGlkZVxuICAgIH0pKTtcbiAgICBmaW5hbExlZnQgPSBnZXRUcmFja0xlZnQoX29iamVjdFNwcmVhZChfb2JqZWN0U3ByZWFkKHt9LCBzcGVjKSwge30sIHtcbiAgICAgIHNsaWRlSW5kZXg6IGZpbmFsU2xpZGVcbiAgICB9KSk7XG5cbiAgICBpZiAoIWluZmluaXRlKSB7XG4gICAgICBpZiAoYW5pbWF0aW9uTGVmdCA9PT0gZmluYWxMZWZ0KSBhbmltYXRpb25TbGlkZSA9IGZpbmFsU2xpZGU7XG4gICAgICBhbmltYXRpb25MZWZ0ID0gZmluYWxMZWZ0O1xuICAgIH1cblxuICAgIGlmIChsYXp5TG9hZCkge1xuICAgICAgbGF6eUxvYWRlZExpc3QgPSBsYXp5TG9hZGVkTGlzdC5jb25jYXQoZ2V0T25EZW1hbmRMYXp5U2xpZGVzKF9vYmplY3RTcHJlYWQoX29iamVjdFNwcmVhZCh7fSwgc3BlYyksIHt9LCB7XG4gICAgICAgIGN1cnJlbnRTbGlkZTogYW5pbWF0aW9uU2xpZGVcbiAgICAgIH0pKSk7XG4gICAgfVxuXG4gICAgaWYgKCF1c2VDU1MpIHtcbiAgICAgIHN0YXRlID0ge1xuICAgICAgICBjdXJyZW50U2xpZGU6IGZpbmFsU2xpZGUsXG4gICAgICAgIHRyYWNrU3R5bGU6IGdldFRyYWNrQ1NTKF9vYmplY3RTcHJlYWQoX29iamVjdFNwcmVhZCh7fSwgc3BlYyksIHt9LCB7XG4gICAgICAgICAgbGVmdDogZmluYWxMZWZ0XG4gICAgICAgIH0pKSxcbiAgICAgICAgbGF6eUxvYWRlZExpc3Q6IGxhenlMb2FkZWRMaXN0LFxuICAgICAgICB0YXJnZXRTbGlkZTogdGFyZ2V0U2xpZGVcbiAgICAgIH07XG4gICAgfSBlbHNlIHtcbiAgICAgIHN0YXRlID0ge1xuICAgICAgICBhbmltYXRpbmc6IHRydWUsXG4gICAgICAgIGN1cnJlbnRTbGlkZTogZmluYWxTbGlkZSxcbiAgICAgICAgdHJhY2tTdHlsZTogZ2V0VHJhY2tBbmltYXRlQ1NTKF9vYmplY3RTcHJlYWQoX29iamVjdFNwcmVhZCh7fSwgc3BlYyksIHt9LCB7XG4gICAgICAgICAgbGVmdDogYW5pbWF0aW9uTGVmdFxuICAgICAgICB9KSksXG4gICAgICAgIGxhenlMb2FkZWRMaXN0OiBsYXp5TG9hZGVkTGlzdCxcbiAgICAgICAgdGFyZ2V0U2xpZGU6IHRhcmdldFNsaWRlXG4gICAgICB9O1xuICAgICAgbmV4dFN0YXRlID0ge1xuICAgICAgICBhbmltYXRpbmc6IGZhbHNlLFxuICAgICAgICBjdXJyZW50U2xpZGU6IGZpbmFsU2xpZGUsXG4gICAgICAgIHRyYWNrU3R5bGU6IGdldFRyYWNrQ1NTKF9vYmplY3RTcHJlYWQoX29iamVjdFNwcmVhZCh7fSwgc3BlYyksIHt9LCB7XG4gICAgICAgICAgbGVmdDogZmluYWxMZWZ0XG4gICAgICAgIH0pKSxcbiAgICAgICAgc3dpcGVMZWZ0OiBudWxsLFxuICAgICAgICB0YXJnZXRTbGlkZTogdGFyZ2V0U2xpZGVcbiAgICAgIH07XG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIHtcbiAgICBzdGF0ZTogc3RhdGUsXG4gICAgbmV4dFN0YXRlOiBuZXh0U3RhdGVcbiAgfTtcbn07XG5cbmV4cG9ydHMuc2xpZGVIYW5kbGVyID0gc2xpZGVIYW5kbGVyO1xuXG52YXIgY2hhbmdlU2xpZGUgPSBmdW5jdGlvbiBjaGFuZ2VTbGlkZShzcGVjLCBvcHRpb25zKSB7XG4gIHZhciBpbmRleE9mZnNldCwgcHJldmlvdXNJbnQsIHNsaWRlT2Zmc2V0LCB1bmV2ZW5PZmZzZXQsIHRhcmdldFNsaWRlO1xuICB2YXIgc2xpZGVzVG9TY3JvbGwgPSBzcGVjLnNsaWRlc1RvU2Nyb2xsLFxuICAgICAgc2xpZGVzVG9TaG93ID0gc3BlYy5zbGlkZXNUb1Nob3csXG4gICAgICBzbGlkZUNvdW50ID0gc3BlYy5zbGlkZUNvdW50LFxuICAgICAgY3VycmVudFNsaWRlID0gc3BlYy5jdXJyZW50U2xpZGUsXG4gICAgICBwcmV2aW91c1RhcmdldFNsaWRlID0gc3BlYy50YXJnZXRTbGlkZSxcbiAgICAgIGxhenlMb2FkID0gc3BlYy5sYXp5TG9hZCxcbiAgICAgIGluZmluaXRlID0gc3BlYy5pbmZpbml0ZTtcbiAgdW5ldmVuT2Zmc2V0ID0gc2xpZGVDb3VudCAlIHNsaWRlc1RvU2Nyb2xsICE9PSAwO1xuICBpbmRleE9mZnNldCA9IHVuZXZlbk9mZnNldCA/IDAgOiAoc2xpZGVDb3VudCAtIGN1cnJlbnRTbGlkZSkgJSBzbGlkZXNUb1Njcm9sbDtcblxuICBpZiAob3B0aW9ucy5tZXNzYWdlID09PSBcInByZXZpb3VzXCIpIHtcbiAgICBzbGlkZU9mZnNldCA9IGluZGV4T2Zmc2V0ID09PSAwID8gc2xpZGVzVG9TY3JvbGwgOiBzbGlkZXNUb1Nob3cgLSBpbmRleE9mZnNldDtcbiAgICB0YXJnZXRTbGlkZSA9IGN1cnJlbnRTbGlkZSAtIHNsaWRlT2Zmc2V0O1xuXG4gICAgaWYgKGxhenlMb2FkICYmICFpbmZpbml0ZSkge1xuICAgICAgcHJldmlvdXNJbnQgPSBjdXJyZW50U2xpZGUgLSBzbGlkZU9mZnNldDtcbiAgICAgIHRhcmdldFNsaWRlID0gcHJldmlvdXNJbnQgPT09IC0xID8gc2xpZGVDb3VudCAtIDEgOiBwcmV2aW91c0ludDtcbiAgICB9XG5cbiAgICBpZiAoIWluZmluaXRlKSB7XG4gICAgICB0YXJnZXRTbGlkZSA9IHByZXZpb3VzVGFyZ2V0U2xpZGUgLSBzbGlkZXNUb1Njcm9sbDtcbiAgICB9XG4gIH0gZWxzZSBpZiAob3B0aW9ucy5tZXNzYWdlID09PSBcIm5leHRcIikge1xuICAgIHNsaWRlT2Zmc2V0ID0gaW5kZXhPZmZzZXQgPT09IDAgPyBzbGlkZXNUb1Njcm9sbCA6IGluZGV4T2Zmc2V0O1xuICAgIHRhcmdldFNsaWRlID0gY3VycmVudFNsaWRlICsgc2xpZGVPZmZzZXQ7XG5cbiAgICBpZiAobGF6eUxvYWQgJiYgIWluZmluaXRlKSB7XG4gICAgICB0YXJnZXRTbGlkZSA9IChjdXJyZW50U2xpZGUgKyBzbGlkZXNUb1Njcm9sbCkgJSBzbGlkZUNvdW50ICsgaW5kZXhPZmZzZXQ7XG4gICAgfVxuXG4gICAgaWYgKCFpbmZpbml0ZSkge1xuICAgICAgdGFyZ2V0U2xpZGUgPSBwcmV2aW91c1RhcmdldFNsaWRlICsgc2xpZGVzVG9TY3JvbGw7XG4gICAgfVxuICB9IGVsc2UgaWYgKG9wdGlvbnMubWVzc2FnZSA9PT0gXCJkb3RzXCIpIHtcbiAgICAvLyBDbGljayBvbiBkb3RzXG4gICAgdGFyZ2V0U2xpZGUgPSBvcHRpb25zLmluZGV4ICogb3B0aW9ucy5zbGlkZXNUb1Njcm9sbDtcbiAgfSBlbHNlIGlmIChvcHRpb25zLm1lc3NhZ2UgPT09IFwiY2hpbGRyZW5cIikge1xuICAgIC8vIENsaWNrIG9uIHRoZSBzbGlkZXNcbiAgICB0YXJnZXRTbGlkZSA9IG9wdGlvbnMuaW5kZXg7XG5cbiAgICBpZiAoaW5maW5pdGUpIHtcbiAgICAgIHZhciBkaXJlY3Rpb24gPSBzaWJsaW5nRGlyZWN0aW9uKF9vYmplY3RTcHJlYWQoX29iamVjdFNwcmVhZCh7fSwgc3BlYyksIHt9LCB7XG4gICAgICAgIHRhcmdldFNsaWRlOiB0YXJnZXRTbGlkZVxuICAgICAgfSkpO1xuXG4gICAgICBpZiAodGFyZ2V0U2xpZGUgPiBvcHRpb25zLmN1cnJlbnRTbGlkZSAmJiBkaXJlY3Rpb24gPT09IFwibGVmdFwiKSB7XG4gICAgICAgIHRhcmdldFNsaWRlID0gdGFyZ2V0U2xpZGUgLSBzbGlkZUNvdW50O1xuICAgICAgfSBlbHNlIGlmICh0YXJnZXRTbGlkZSA8IG9wdGlvbnMuY3VycmVudFNsaWRlICYmIGRpcmVjdGlvbiA9PT0gXCJyaWdodFwiKSB7XG4gICAgICAgIHRhcmdldFNsaWRlID0gdGFyZ2V0U2xpZGUgKyBzbGlkZUNvdW50O1xuICAgICAgfVxuICAgIH1cbiAgfSBlbHNlIGlmIChvcHRpb25zLm1lc3NhZ2UgPT09IFwiaW5kZXhcIikge1xuICAgIHRhcmdldFNsaWRlID0gTnVtYmVyKG9wdGlvbnMuaW5kZXgpO1xuICB9XG5cbiAgcmV0dXJuIHRhcmdldFNsaWRlO1xufTtcblxuZXhwb3J0cy5jaGFuZ2VTbGlkZSA9IGNoYW5nZVNsaWRlO1xuXG52YXIga2V5SGFuZGxlciA9IGZ1bmN0aW9uIGtleUhhbmRsZXIoZSwgYWNjZXNzaWJpbGl0eSwgcnRsKSB7XG4gIGlmIChlLnRhcmdldC50YWdOYW1lLm1hdGNoKFwiVEVYVEFSRUF8SU5QVVR8U0VMRUNUXCIpIHx8ICFhY2Nlc3NpYmlsaXR5KSByZXR1cm4gXCJcIjtcbiAgaWYgKGUua2V5Q29kZSA9PT0gMzcpIHJldHVybiBydGwgPyBcIm5leHRcIiA6IFwicHJldmlvdXNcIjtcbiAgaWYgKGUua2V5Q29kZSA9PT0gMzkpIHJldHVybiBydGwgPyBcInByZXZpb3VzXCIgOiBcIm5leHRcIjtcbiAgcmV0dXJuIFwiXCI7XG59O1xuXG5leHBvcnRzLmtleUhhbmRsZXIgPSBrZXlIYW5kbGVyO1xuXG52YXIgc3dpcGVTdGFydCA9IGZ1bmN0aW9uIHN3aXBlU3RhcnQoZSwgc3dpcGUsIGRyYWdnYWJsZSkge1xuICBlLnRhcmdldC50YWdOYW1lID09PSBcIklNR1wiICYmIHNhZmVQcmV2ZW50RGVmYXVsdChlKTtcbiAgaWYgKCFzd2lwZSB8fCAhZHJhZ2dhYmxlICYmIGUudHlwZS5pbmRleE9mKFwibW91c2VcIikgIT09IC0xKSByZXR1cm4gXCJcIjtcbiAgcmV0dXJuIHtcbiAgICBkcmFnZ2luZzogdHJ1ZSxcbiAgICB0b3VjaE9iamVjdDoge1xuICAgICAgc3RhcnRYOiBlLnRvdWNoZXMgPyBlLnRvdWNoZXNbMF0ucGFnZVggOiBlLmNsaWVudFgsXG4gICAgICBzdGFydFk6IGUudG91Y2hlcyA/IGUudG91Y2hlc1swXS5wYWdlWSA6IGUuY2xpZW50WSxcbiAgICAgIGN1clg6IGUudG91Y2hlcyA/IGUudG91Y2hlc1swXS5wYWdlWCA6IGUuY2xpZW50WCxcbiAgICAgIGN1clk6IGUudG91Y2hlcyA/IGUudG91Y2hlc1swXS5wYWdlWSA6IGUuY2xpZW50WVxuICAgIH1cbiAgfTtcbn07XG5cbmV4cG9ydHMuc3dpcGVTdGFydCA9IHN3aXBlU3RhcnQ7XG5cbnZhciBzd2lwZU1vdmUgPSBmdW5jdGlvbiBzd2lwZU1vdmUoZSwgc3BlYykge1xuICAvLyBzcGVjIGFsc28gY29udGFpbnMsIHRyYWNrUmVmIGFuZCBzbGlkZUluZGV4XG4gIHZhciBzY3JvbGxpbmcgPSBzcGVjLnNjcm9sbGluZyxcbiAgICAgIGFuaW1hdGluZyA9IHNwZWMuYW5pbWF0aW5nLFxuICAgICAgdmVydGljYWwgPSBzcGVjLnZlcnRpY2FsLFxuICAgICAgc3dpcGVUb1NsaWRlID0gc3BlYy5zd2lwZVRvU2xpZGUsXG4gICAgICB2ZXJ0aWNhbFN3aXBpbmcgPSBzcGVjLnZlcnRpY2FsU3dpcGluZyxcbiAgICAgIHJ0bCA9IHNwZWMucnRsLFxuICAgICAgY3VycmVudFNsaWRlID0gc3BlYy5jdXJyZW50U2xpZGUsXG4gICAgICBlZGdlRnJpY3Rpb24gPSBzcGVjLmVkZ2VGcmljdGlvbixcbiAgICAgIGVkZ2VEcmFnZ2VkID0gc3BlYy5lZGdlRHJhZ2dlZCxcbiAgICAgIG9uRWRnZSA9IHNwZWMub25FZGdlLFxuICAgICAgc3dpcGVkID0gc3BlYy5zd2lwZWQsXG4gICAgICBzd2lwaW5nID0gc3BlYy5zd2lwaW5nLFxuICAgICAgc2xpZGVDb3VudCA9IHNwZWMuc2xpZGVDb3VudCxcbiAgICAgIHNsaWRlc1RvU2Nyb2xsID0gc3BlYy5zbGlkZXNUb1Njcm9sbCxcbiAgICAgIGluZmluaXRlID0gc3BlYy5pbmZpbml0ZSxcbiAgICAgIHRvdWNoT2JqZWN0ID0gc3BlYy50b3VjaE9iamVjdCxcbiAgICAgIHN3aXBlRXZlbnQgPSBzcGVjLnN3aXBlRXZlbnQsXG4gICAgICBsaXN0SGVpZ2h0ID0gc3BlYy5saXN0SGVpZ2h0LFxuICAgICAgbGlzdFdpZHRoID0gc3BlYy5saXN0V2lkdGg7XG4gIGlmIChzY3JvbGxpbmcpIHJldHVybjtcbiAgaWYgKGFuaW1hdGluZykgcmV0dXJuIHNhZmVQcmV2ZW50RGVmYXVsdChlKTtcbiAgaWYgKHZlcnRpY2FsICYmIHN3aXBlVG9TbGlkZSAmJiB2ZXJ0aWNhbFN3aXBpbmcpIHNhZmVQcmV2ZW50RGVmYXVsdChlKTtcbiAgdmFyIHN3aXBlTGVmdCxcbiAgICAgIHN0YXRlID0ge307XG4gIHZhciBjdXJMZWZ0ID0gZ2V0VHJhY2tMZWZ0KHNwZWMpO1xuICB0b3VjaE9iamVjdC5jdXJYID0gZS50b3VjaGVzID8gZS50b3VjaGVzWzBdLnBhZ2VYIDogZS5jbGllbnRYO1xuICB0b3VjaE9iamVjdC5jdXJZID0gZS50b3VjaGVzID8gZS50b3VjaGVzWzBdLnBhZ2VZIDogZS5jbGllbnRZO1xuICB0b3VjaE9iamVjdC5zd2lwZUxlbmd0aCA9IE1hdGgucm91bmQoTWF0aC5zcXJ0KE1hdGgucG93KHRvdWNoT2JqZWN0LmN1clggLSB0b3VjaE9iamVjdC5zdGFydFgsIDIpKSk7XG4gIHZhciB2ZXJ0aWNhbFN3aXBlTGVuZ3RoID0gTWF0aC5yb3VuZChNYXRoLnNxcnQoTWF0aC5wb3codG91Y2hPYmplY3QuY3VyWSAtIHRvdWNoT2JqZWN0LnN0YXJ0WSwgMikpKTtcblxuICBpZiAoIXZlcnRpY2FsU3dpcGluZyAmJiAhc3dpcGluZyAmJiB2ZXJ0aWNhbFN3aXBlTGVuZ3RoID4gMTApIHtcbiAgICByZXR1cm4ge1xuICAgICAgc2Nyb2xsaW5nOiB0cnVlXG4gICAgfTtcbiAgfVxuXG4gIGlmICh2ZXJ0aWNhbFN3aXBpbmcpIHRvdWNoT2JqZWN0LnN3aXBlTGVuZ3RoID0gdmVydGljYWxTd2lwZUxlbmd0aDtcbiAgdmFyIHBvc2l0aW9uT2Zmc2V0ID0gKCFydGwgPyAxIDogLTEpICogKHRvdWNoT2JqZWN0LmN1clggPiB0b3VjaE9iamVjdC5zdGFydFggPyAxIDogLTEpO1xuICBpZiAodmVydGljYWxTd2lwaW5nKSBwb3NpdGlvbk9mZnNldCA9IHRvdWNoT2JqZWN0LmN1clkgPiB0b3VjaE9iamVjdC5zdGFydFkgPyAxIDogLTE7XG4gIHZhciBkb3RDb3VudCA9IE1hdGguY2VpbChzbGlkZUNvdW50IC8gc2xpZGVzVG9TY3JvbGwpO1xuICB2YXIgc3dpcGVEaXJlY3Rpb24gPSBnZXRTd2lwZURpcmVjdGlvbihzcGVjLnRvdWNoT2JqZWN0LCB2ZXJ0aWNhbFN3aXBpbmcpO1xuICB2YXIgdG91Y2hTd2lwZUxlbmd0aCA9IHRvdWNoT2JqZWN0LnN3aXBlTGVuZ3RoO1xuXG4gIGlmICghaW5maW5pdGUpIHtcbiAgICBpZiAoY3VycmVudFNsaWRlID09PSAwICYmIChzd2lwZURpcmVjdGlvbiA9PT0gXCJyaWdodFwiIHx8IHN3aXBlRGlyZWN0aW9uID09PSBcImRvd25cIikgfHwgY3VycmVudFNsaWRlICsgMSA+PSBkb3RDb3VudCAmJiAoc3dpcGVEaXJlY3Rpb24gPT09IFwibGVmdFwiIHx8IHN3aXBlRGlyZWN0aW9uID09PSBcInVwXCIpIHx8ICFjYW5Hb05leHQoc3BlYykgJiYgKHN3aXBlRGlyZWN0aW9uID09PSBcImxlZnRcIiB8fCBzd2lwZURpcmVjdGlvbiA9PT0gXCJ1cFwiKSkge1xuICAgICAgdG91Y2hTd2lwZUxlbmd0aCA9IHRvdWNoT2JqZWN0LnN3aXBlTGVuZ3RoICogZWRnZUZyaWN0aW9uO1xuXG4gICAgICBpZiAoZWRnZURyYWdnZWQgPT09IGZhbHNlICYmIG9uRWRnZSkge1xuICAgICAgICBvbkVkZ2Uoc3dpcGVEaXJlY3Rpb24pO1xuICAgICAgICBzdGF0ZVtcImVkZ2VEcmFnZ2VkXCJdID0gdHJ1ZTtcbiAgICAgIH1cbiAgICB9XG4gIH1cblxuICBpZiAoIXN3aXBlZCAmJiBzd2lwZUV2ZW50KSB7XG4gICAgc3dpcGVFdmVudChzd2lwZURpcmVjdGlvbik7XG4gICAgc3RhdGVbXCJzd2lwZWRcIl0gPSB0cnVlO1xuICB9XG5cbiAgaWYgKCF2ZXJ0aWNhbCkge1xuICAgIGlmICghcnRsKSB7XG4gICAgICBzd2lwZUxlZnQgPSBjdXJMZWZ0ICsgdG91Y2hTd2lwZUxlbmd0aCAqIHBvc2l0aW9uT2Zmc2V0O1xuICAgIH0gZWxzZSB7XG4gICAgICBzd2lwZUxlZnQgPSBjdXJMZWZ0IC0gdG91Y2hTd2lwZUxlbmd0aCAqIHBvc2l0aW9uT2Zmc2V0O1xuICAgIH1cbiAgfSBlbHNlIHtcbiAgICBzd2lwZUxlZnQgPSBjdXJMZWZ0ICsgdG91Y2hTd2lwZUxlbmd0aCAqIChsaXN0SGVpZ2h0IC8gbGlzdFdpZHRoKSAqIHBvc2l0aW9uT2Zmc2V0O1xuICB9XG5cbiAgaWYgKHZlcnRpY2FsU3dpcGluZykge1xuICAgIHN3aXBlTGVmdCA9IGN1ckxlZnQgKyB0b3VjaFN3aXBlTGVuZ3RoICogcG9zaXRpb25PZmZzZXQ7XG4gIH1cblxuICBzdGF0ZSA9IF9vYmplY3RTcHJlYWQoX29iamVjdFNwcmVhZCh7fSwgc3RhdGUpLCB7fSwge1xuICAgIHRvdWNoT2JqZWN0OiB0b3VjaE9iamVjdCxcbiAgICBzd2lwZUxlZnQ6IHN3aXBlTGVmdCxcbiAgICB0cmFja1N0eWxlOiBnZXRUcmFja0NTUyhfb2JqZWN0U3ByZWFkKF9vYmplY3RTcHJlYWQoe30sIHNwZWMpLCB7fSwge1xuICAgICAgbGVmdDogc3dpcGVMZWZ0XG4gICAgfSkpXG4gIH0pO1xuXG4gIGlmIChNYXRoLmFicyh0b3VjaE9iamVjdC5jdXJYIC0gdG91Y2hPYmplY3Quc3RhcnRYKSA8IE1hdGguYWJzKHRvdWNoT2JqZWN0LmN1clkgLSB0b3VjaE9iamVjdC5zdGFydFkpICogMC44KSB7XG4gICAgcmV0dXJuIHN0YXRlO1xuICB9XG5cbiAgaWYgKHRvdWNoT2JqZWN0LnN3aXBlTGVuZ3RoID4gMTApIHtcbiAgICBzdGF0ZVtcInN3aXBpbmdcIl0gPSB0cnVlO1xuICAgIHNhZmVQcmV2ZW50RGVmYXVsdChlKTtcbiAgfVxuXG4gIHJldHVybiBzdGF0ZTtcbn07XG5cbmV4cG9ydHMuc3dpcGVNb3ZlID0gc3dpcGVNb3ZlO1xuXG52YXIgc3dpcGVFbmQgPSBmdW5jdGlvbiBzd2lwZUVuZChlLCBzcGVjKSB7XG4gIHZhciBkcmFnZ2luZyA9IHNwZWMuZHJhZ2dpbmcsXG4gICAgICBzd2lwZSA9IHNwZWMuc3dpcGUsXG4gICAgICB0b3VjaE9iamVjdCA9IHNwZWMudG91Y2hPYmplY3QsXG4gICAgICBsaXN0V2lkdGggPSBzcGVjLmxpc3RXaWR0aCxcbiAgICAgIHRvdWNoVGhyZXNob2xkID0gc3BlYy50b3VjaFRocmVzaG9sZCxcbiAgICAgIHZlcnRpY2FsU3dpcGluZyA9IHNwZWMudmVydGljYWxTd2lwaW5nLFxuICAgICAgbGlzdEhlaWdodCA9IHNwZWMubGlzdEhlaWdodCxcbiAgICAgIHN3aXBlVG9TbGlkZSA9IHNwZWMuc3dpcGVUb1NsaWRlLFxuICAgICAgc2Nyb2xsaW5nID0gc3BlYy5zY3JvbGxpbmcsXG4gICAgICBvblN3aXBlID0gc3BlYy5vblN3aXBlLFxuICAgICAgdGFyZ2V0U2xpZGUgPSBzcGVjLnRhcmdldFNsaWRlLFxuICAgICAgY3VycmVudFNsaWRlID0gc3BlYy5jdXJyZW50U2xpZGUsXG4gICAgICBpbmZpbml0ZSA9IHNwZWMuaW5maW5pdGU7XG5cbiAgaWYgKCFkcmFnZ2luZykge1xuICAgIGlmIChzd2lwZSkgc2FmZVByZXZlbnREZWZhdWx0KGUpO1xuICAgIHJldHVybiB7fTtcbiAgfVxuXG4gIHZhciBtaW5Td2lwZSA9IHZlcnRpY2FsU3dpcGluZyA/IGxpc3RIZWlnaHQgLyB0b3VjaFRocmVzaG9sZCA6IGxpc3RXaWR0aCAvIHRvdWNoVGhyZXNob2xkO1xuICB2YXIgc3dpcGVEaXJlY3Rpb24gPSBnZXRTd2lwZURpcmVjdGlvbih0b3VjaE9iamVjdCwgdmVydGljYWxTd2lwaW5nKTsgLy8gcmVzZXQgdGhlIHN0YXRlIG9mIHRvdWNoIHJlbGF0ZWQgc3RhdGUgdmFyaWFibGVzLlxuXG4gIHZhciBzdGF0ZSA9IHtcbiAgICBkcmFnZ2luZzogZmFsc2UsXG4gICAgZWRnZURyYWdnZWQ6IGZhbHNlLFxuICAgIHNjcm9sbGluZzogZmFsc2UsXG4gICAgc3dpcGluZzogZmFsc2UsXG4gICAgc3dpcGVkOiBmYWxzZSxcbiAgICBzd2lwZUxlZnQ6IG51bGwsXG4gICAgdG91Y2hPYmplY3Q6IHt9XG4gIH07XG5cbiAgaWYgKHNjcm9sbGluZykge1xuICAgIHJldHVybiBzdGF0ZTtcbiAgfVxuXG4gIGlmICghdG91Y2hPYmplY3Quc3dpcGVMZW5ndGgpIHtcbiAgICByZXR1cm4gc3RhdGU7XG4gIH1cblxuICBpZiAodG91Y2hPYmplY3Quc3dpcGVMZW5ndGggPiBtaW5Td2lwZSkge1xuICAgIHNhZmVQcmV2ZW50RGVmYXVsdChlKTtcblxuICAgIGlmIChvblN3aXBlKSB7XG4gICAgICBvblN3aXBlKHN3aXBlRGlyZWN0aW9uKTtcbiAgICB9XG5cbiAgICB2YXIgc2xpZGVDb3VudCwgbmV3U2xpZGU7XG4gICAgdmFyIGFjdGl2ZVNsaWRlID0gaW5maW5pdGUgPyBjdXJyZW50U2xpZGUgOiB0YXJnZXRTbGlkZTtcblxuICAgIHN3aXRjaCAoc3dpcGVEaXJlY3Rpb24pIHtcbiAgICAgIGNhc2UgXCJsZWZ0XCI6XG4gICAgICBjYXNlIFwidXBcIjpcbiAgICAgICAgbmV3U2xpZGUgPSBhY3RpdmVTbGlkZSArIGdldFNsaWRlQ291bnQoc3BlYyk7XG4gICAgICAgIHNsaWRlQ291bnQgPSBzd2lwZVRvU2xpZGUgPyBjaGVja05hdmlnYWJsZShzcGVjLCBuZXdTbGlkZSkgOiBuZXdTbGlkZTtcbiAgICAgICAgc3RhdGVbXCJjdXJyZW50RGlyZWN0aW9uXCJdID0gMDtcbiAgICAgICAgYnJlYWs7XG5cbiAgICAgIGNhc2UgXCJyaWdodFwiOlxuICAgICAgY2FzZSBcImRvd25cIjpcbiAgICAgICAgbmV3U2xpZGUgPSBhY3RpdmVTbGlkZSAtIGdldFNsaWRlQ291bnQoc3BlYyk7XG4gICAgICAgIHNsaWRlQ291bnQgPSBzd2lwZVRvU2xpZGUgPyBjaGVja05hdmlnYWJsZShzcGVjLCBuZXdTbGlkZSkgOiBuZXdTbGlkZTtcbiAgICAgICAgc3RhdGVbXCJjdXJyZW50RGlyZWN0aW9uXCJdID0gMTtcbiAgICAgICAgYnJlYWs7XG5cbiAgICAgIGRlZmF1bHQ6XG4gICAgICAgIHNsaWRlQ291bnQgPSBhY3RpdmVTbGlkZTtcbiAgICB9XG5cbiAgICBzdGF0ZVtcInRyaWdnZXJTbGlkZUhhbmRsZXJcIl0gPSBzbGlkZUNvdW50O1xuICB9IGVsc2Uge1xuICAgIC8vIEFkanVzdCB0aGUgdHJhY2sgYmFjayB0byBpdCdzIG9yaWdpbmFsIHBvc2l0aW9uLlxuICAgIHZhciBjdXJyZW50TGVmdCA9IGdldFRyYWNrTGVmdChzcGVjKTtcbiAgICBzdGF0ZVtcInRyYWNrU3R5bGVcIl0gPSBnZXRUcmFja0FuaW1hdGVDU1MoX29iamVjdFNwcmVhZChfb2JqZWN0U3ByZWFkKHt9LCBzcGVjKSwge30sIHtcbiAgICAgIGxlZnQ6IGN1cnJlbnRMZWZ0XG4gICAgfSkpO1xuICB9XG5cbiAgcmV0dXJuIHN0YXRlO1xufTtcblxuZXhwb3J0cy5zd2lwZUVuZCA9IHN3aXBlRW5kO1xuXG52YXIgZ2V0TmF2aWdhYmxlSW5kZXhlcyA9IGZ1bmN0aW9uIGdldE5hdmlnYWJsZUluZGV4ZXMoc3BlYykge1xuICB2YXIgbWF4ID0gc3BlYy5pbmZpbml0ZSA/IHNwZWMuc2xpZGVDb3VudCAqIDIgOiBzcGVjLnNsaWRlQ291bnQ7XG4gIHZhciBicmVha3BvaW50ID0gc3BlYy5pbmZpbml0ZSA/IHNwZWMuc2xpZGVzVG9TaG93ICogLTEgOiAwO1xuICB2YXIgY291bnRlciA9IHNwZWMuaW5maW5pdGUgPyBzcGVjLnNsaWRlc1RvU2hvdyAqIC0xIDogMDtcbiAgdmFyIGluZGV4ZXMgPSBbXTtcblxuICB3aGlsZSAoYnJlYWtwb2ludCA8IG1heCkge1xuICAgIGluZGV4ZXMucHVzaChicmVha3BvaW50KTtcbiAgICBicmVha3BvaW50ID0gY291bnRlciArIHNwZWMuc2xpZGVzVG9TY3JvbGw7XG4gICAgY291bnRlciArPSBNYXRoLm1pbihzcGVjLnNsaWRlc1RvU2Nyb2xsLCBzcGVjLnNsaWRlc1RvU2hvdyk7XG4gIH1cblxuICByZXR1cm4gaW5kZXhlcztcbn07XG5cbmV4cG9ydHMuZ2V0TmF2aWdhYmxlSW5kZXhlcyA9IGdldE5hdmlnYWJsZUluZGV4ZXM7XG5cbnZhciBjaGVja05hdmlnYWJsZSA9IGZ1bmN0aW9uIGNoZWNrTmF2aWdhYmxlKHNwZWMsIGluZGV4KSB7XG4gIHZhciBuYXZpZ2FibGVzID0gZ2V0TmF2aWdhYmxlSW5kZXhlcyhzcGVjKTtcbiAgdmFyIHByZXZOYXZpZ2FibGUgPSAwO1xuXG4gIGlmIChpbmRleCA+IG5hdmlnYWJsZXNbbmF2aWdhYmxlcy5sZW5ndGggLSAxXSkge1xuICAgIGluZGV4ID0gbmF2aWdhYmxlc1tuYXZpZ2FibGVzLmxlbmd0aCAtIDFdO1xuICB9IGVsc2Uge1xuICAgIGZvciAodmFyIG4gaW4gbmF2aWdhYmxlcykge1xuICAgICAgaWYgKGluZGV4IDwgbmF2aWdhYmxlc1tuXSkge1xuICAgICAgICBpbmRleCA9IHByZXZOYXZpZ2FibGU7XG4gICAgICAgIGJyZWFrO1xuICAgICAgfVxuXG4gICAgICBwcmV2TmF2aWdhYmxlID0gbmF2aWdhYmxlc1tuXTtcbiAgICB9XG4gIH1cblxuICByZXR1cm4gaW5kZXg7XG59O1xuXG5leHBvcnRzLmNoZWNrTmF2aWdhYmxlID0gY2hlY2tOYXZpZ2FibGU7XG5cbnZhciBnZXRTbGlkZUNvdW50ID0gZnVuY3Rpb24gZ2V0U2xpZGVDb3VudChzcGVjKSB7XG4gIHZhciBjZW50ZXJPZmZzZXQgPSBzcGVjLmNlbnRlck1vZGUgPyBzcGVjLnNsaWRlV2lkdGggKiBNYXRoLmZsb29yKHNwZWMuc2xpZGVzVG9TaG93IC8gMikgOiAwO1xuXG4gIGlmIChzcGVjLnN3aXBlVG9TbGlkZSkge1xuICAgIHZhciBzd2lwZWRTbGlkZTtcbiAgICB2YXIgc2xpY2tMaXN0ID0gc3BlYy5saXN0UmVmO1xuICAgIHZhciBzbGlkZXMgPSBzbGlja0xpc3QucXVlcnlTZWxlY3RvckFsbCAmJiBzbGlja0xpc3QucXVlcnlTZWxlY3RvckFsbChcIi5zbGljay1zbGlkZVwiKSB8fCBbXTtcbiAgICBBcnJheS5mcm9tKHNsaWRlcykuZXZlcnkoZnVuY3Rpb24gKHNsaWRlKSB7XG4gICAgICBpZiAoIXNwZWMudmVydGljYWwpIHtcbiAgICAgICAgaWYgKHNsaWRlLm9mZnNldExlZnQgLSBjZW50ZXJPZmZzZXQgKyBnZXRXaWR0aChzbGlkZSkgLyAyID4gc3BlYy5zd2lwZUxlZnQgKiAtMSkge1xuICAgICAgICAgIHN3aXBlZFNsaWRlID0gc2xpZGU7XG4gICAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgICB9XG4gICAgICB9IGVsc2Uge1xuICAgICAgICBpZiAoc2xpZGUub2Zmc2V0VG9wICsgZ2V0SGVpZ2h0KHNsaWRlKSAvIDIgPiBzcGVjLnN3aXBlTGVmdCAqIC0xKSB7XG4gICAgICAgICAgc3dpcGVkU2xpZGUgPSBzbGlkZTtcbiAgICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICAgIH1cbiAgICAgIH1cblxuICAgICAgcmV0dXJuIHRydWU7XG4gICAgfSk7XG5cbiAgICBpZiAoIXN3aXBlZFNsaWRlKSB7XG4gICAgICByZXR1cm4gMDtcbiAgICB9XG5cbiAgICB2YXIgY3VycmVudEluZGV4ID0gc3BlYy5ydGwgPT09IHRydWUgPyBzcGVjLnNsaWRlQ291bnQgLSBzcGVjLmN1cnJlbnRTbGlkZSA6IHNwZWMuY3VycmVudFNsaWRlO1xuICAgIHZhciBzbGlkZXNUcmF2ZXJzZWQgPSBNYXRoLmFicyhzd2lwZWRTbGlkZS5kYXRhc2V0LmluZGV4IC0gY3VycmVudEluZGV4KSB8fCAxO1xuICAgIHJldHVybiBzbGlkZXNUcmF2ZXJzZWQ7XG4gIH0gZWxzZSB7XG4gICAgcmV0dXJuIHNwZWMuc2xpZGVzVG9TY3JvbGw7XG4gIH1cbn07XG5cbmV4cG9ydHMuZ2V0U2xpZGVDb3VudCA9IGdldFNsaWRlQ291bnQ7XG5cbnZhciBjaGVja1NwZWNLZXlzID0gZnVuY3Rpb24gY2hlY2tTcGVjS2V5cyhzcGVjLCBrZXlzQXJyYXkpIHtcbiAgcmV0dXJuIGtleXNBcnJheS5yZWR1Y2UoZnVuY3Rpb24gKHZhbHVlLCBrZXkpIHtcbiAgICByZXR1cm4gdmFsdWUgJiYgc3BlYy5oYXNPd25Qcm9wZXJ0eShrZXkpO1xuICB9LCB0cnVlKSA/IG51bGwgOiBjb25zb2xlLmVycm9yKFwiS2V5cyBNaXNzaW5nOlwiLCBzcGVjKTtcbn07XG5cbmV4cG9ydHMuY2hlY2tTcGVjS2V5cyA9IGNoZWNrU3BlY0tleXM7XG5cbnZhciBnZXRUcmFja0NTUyA9IGZ1bmN0aW9uIGdldFRyYWNrQ1NTKHNwZWMpIHtcbiAgY2hlY2tTcGVjS2V5cyhzcGVjLCBbXCJsZWZ0XCIsIFwidmFyaWFibGVXaWR0aFwiLCBcInNsaWRlQ291bnRcIiwgXCJzbGlkZXNUb1Nob3dcIiwgXCJzbGlkZVdpZHRoXCJdKTtcbiAgdmFyIHRyYWNrV2lkdGgsIHRyYWNrSGVpZ2h0O1xuICB2YXIgdHJhY2tDaGlsZHJlbiA9IHNwZWMuc2xpZGVDb3VudCArIDIgKiBzcGVjLnNsaWRlc1RvU2hvdztcblxuICBpZiAoIXNwZWMudmVydGljYWwpIHtcbiAgICB0cmFja1dpZHRoID0gZ2V0VG90YWxTbGlkZXMoc3BlYykgKiBzcGVjLnNsaWRlV2lkdGg7XG4gIH0gZWxzZSB7XG4gICAgdHJhY2tIZWlnaHQgPSB0cmFja0NoaWxkcmVuICogc3BlYy5zbGlkZUhlaWdodDtcbiAgfVxuXG4gIHZhciBzdHlsZSA9IHtcbiAgICBvcGFjaXR5OiAxLFxuICAgIHRyYW5zaXRpb246IFwiXCIsXG4gICAgV2Via2l0VHJhbnNpdGlvbjogXCJcIlxuICB9O1xuXG4gIGlmIChzcGVjLnVzZVRyYW5zZm9ybSkge1xuICAgIHZhciBXZWJraXRUcmFuc2Zvcm0gPSAhc3BlYy52ZXJ0aWNhbCA/IFwidHJhbnNsYXRlM2QoXCIgKyBzcGVjLmxlZnQgKyBcInB4LCAwcHgsIDBweClcIiA6IFwidHJhbnNsYXRlM2QoMHB4LCBcIiArIHNwZWMubGVmdCArIFwicHgsIDBweClcIjtcbiAgICB2YXIgdHJhbnNmb3JtID0gIXNwZWMudmVydGljYWwgPyBcInRyYW5zbGF0ZTNkKFwiICsgc3BlYy5sZWZ0ICsgXCJweCwgMHB4LCAwcHgpXCIgOiBcInRyYW5zbGF0ZTNkKDBweCwgXCIgKyBzcGVjLmxlZnQgKyBcInB4LCAwcHgpXCI7XG4gICAgdmFyIG1zVHJhbnNmb3JtID0gIXNwZWMudmVydGljYWwgPyBcInRyYW5zbGF0ZVgoXCIgKyBzcGVjLmxlZnQgKyBcInB4KVwiIDogXCJ0cmFuc2xhdGVZKFwiICsgc3BlYy5sZWZ0ICsgXCJweClcIjtcbiAgICBzdHlsZSA9IF9vYmplY3RTcHJlYWQoX29iamVjdFNwcmVhZCh7fSwgc3R5bGUpLCB7fSwge1xuICAgICAgV2Via2l0VHJhbnNmb3JtOiBXZWJraXRUcmFuc2Zvcm0sXG4gICAgICB0cmFuc2Zvcm06IHRyYW5zZm9ybSxcbiAgICAgIG1zVHJhbnNmb3JtOiBtc1RyYW5zZm9ybVxuICAgIH0pO1xuICB9IGVsc2Uge1xuICAgIGlmIChzcGVjLnZlcnRpY2FsKSB7XG4gICAgICBzdHlsZVtcInRvcFwiXSA9IHNwZWMubGVmdDtcbiAgICB9IGVsc2Uge1xuICAgICAgc3R5bGVbXCJsZWZ0XCJdID0gc3BlYy5sZWZ0O1xuICAgIH1cbiAgfVxuXG4gIGlmIChzcGVjLmZhZGUpIHN0eWxlID0ge1xuICAgIG9wYWNpdHk6IDFcbiAgfTtcbiAgaWYgKHRyYWNrV2lkdGgpIHN0eWxlLndpZHRoID0gdHJhY2tXaWR0aDtcbiAgaWYgKHRyYWNrSGVpZ2h0KSBzdHlsZS5oZWlnaHQgPSB0cmFja0hlaWdodDsgLy8gRmFsbGJhY2sgZm9yIElFOFxuXG4gIGlmICh3aW5kb3cgJiYgIXdpbmRvdy5hZGRFdmVudExpc3RlbmVyICYmIHdpbmRvdy5hdHRhY2hFdmVudCkge1xuICAgIGlmICghc3BlYy52ZXJ0aWNhbCkge1xuICAgICAgc3R5bGUubWFyZ2luTGVmdCA9IHNwZWMubGVmdCArIFwicHhcIjtcbiAgICB9IGVsc2Uge1xuICAgICAgc3R5bGUubWFyZ2luVG9wID0gc3BlYy5sZWZ0ICsgXCJweFwiO1xuICAgIH1cbiAgfVxuXG4gIHJldHVybiBzdHlsZTtcbn07XG5cbmV4cG9ydHMuZ2V0VHJhY2tDU1MgPSBnZXRUcmFja0NTUztcblxudmFyIGdldFRyYWNrQW5pbWF0ZUNTUyA9IGZ1bmN0aW9uIGdldFRyYWNrQW5pbWF0ZUNTUyhzcGVjKSB7XG4gIGNoZWNrU3BlY0tleXMoc3BlYywgW1wibGVmdFwiLCBcInZhcmlhYmxlV2lkdGhcIiwgXCJzbGlkZUNvdW50XCIsIFwic2xpZGVzVG9TaG93XCIsIFwic2xpZGVXaWR0aFwiLCBcInNwZWVkXCIsIFwiY3NzRWFzZVwiXSk7XG4gIHZhciBzdHlsZSA9IGdldFRyYWNrQ1NTKHNwZWMpOyAvLyB1c2VDU1MgaXMgdHJ1ZSBieSBkZWZhdWx0IHNvIGl0IGNhbiBiZSB1bmRlZmluZWRcblxuICBpZiAoc3BlYy51c2VUcmFuc2Zvcm0pIHtcbiAgICBzdHlsZS5XZWJraXRUcmFuc2l0aW9uID0gXCItd2Via2l0LXRyYW5zZm9ybSBcIiArIHNwZWMuc3BlZWQgKyBcIm1zIFwiICsgc3BlYy5jc3NFYXNlO1xuICAgIHN0eWxlLnRyYW5zaXRpb24gPSBcInRyYW5zZm9ybSBcIiArIHNwZWMuc3BlZWQgKyBcIm1zIFwiICsgc3BlYy5jc3NFYXNlO1xuICB9IGVsc2Uge1xuICAgIGlmIChzcGVjLnZlcnRpY2FsKSB7XG4gICAgICBzdHlsZS50cmFuc2l0aW9uID0gXCJ0b3AgXCIgKyBzcGVjLnNwZWVkICsgXCJtcyBcIiArIHNwZWMuY3NzRWFzZTtcbiAgICB9IGVsc2Uge1xuICAgICAgc3R5bGUudHJhbnNpdGlvbiA9IFwibGVmdCBcIiArIHNwZWMuc3BlZWQgKyBcIm1zIFwiICsgc3BlYy5jc3NFYXNlO1xuICAgIH1cbiAgfVxuXG4gIHJldHVybiBzdHlsZTtcbn07XG5cbmV4cG9ydHMuZ2V0VHJhY2tBbmltYXRlQ1NTID0gZ2V0VHJhY2tBbmltYXRlQ1NTO1xuXG52YXIgZ2V0VHJhY2tMZWZ0ID0gZnVuY3Rpb24gZ2V0VHJhY2tMZWZ0KHNwZWMpIHtcbiAgaWYgKHNwZWMudW5zbGljaykge1xuICAgIHJldHVybiAwO1xuICB9XG5cbiAgY2hlY2tTcGVjS2V5cyhzcGVjLCBbXCJzbGlkZUluZGV4XCIsIFwidHJhY2tSZWZcIiwgXCJpbmZpbml0ZVwiLCBcImNlbnRlck1vZGVcIiwgXCJzbGlkZUNvdW50XCIsIFwic2xpZGVzVG9TaG93XCIsIFwic2xpZGVzVG9TY3JvbGxcIiwgXCJzbGlkZVdpZHRoXCIsIFwibGlzdFdpZHRoXCIsIFwidmFyaWFibGVXaWR0aFwiLCBcInNsaWRlSGVpZ2h0XCJdKTtcbiAgdmFyIHNsaWRlSW5kZXggPSBzcGVjLnNsaWRlSW5kZXgsXG4gICAgICB0cmFja1JlZiA9IHNwZWMudHJhY2tSZWYsXG4gICAgICBpbmZpbml0ZSA9IHNwZWMuaW5maW5pdGUsXG4gICAgICBjZW50ZXJNb2RlID0gc3BlYy5jZW50ZXJNb2RlLFxuICAgICAgc2xpZGVDb3VudCA9IHNwZWMuc2xpZGVDb3VudCxcbiAgICAgIHNsaWRlc1RvU2hvdyA9IHNwZWMuc2xpZGVzVG9TaG93LFxuICAgICAgc2xpZGVzVG9TY3JvbGwgPSBzcGVjLnNsaWRlc1RvU2Nyb2xsLFxuICAgICAgc2xpZGVXaWR0aCA9IHNwZWMuc2xpZGVXaWR0aCxcbiAgICAgIGxpc3RXaWR0aCA9IHNwZWMubGlzdFdpZHRoLFxuICAgICAgdmFyaWFibGVXaWR0aCA9IHNwZWMudmFyaWFibGVXaWR0aCxcbiAgICAgIHNsaWRlSGVpZ2h0ID0gc3BlYy5zbGlkZUhlaWdodCxcbiAgICAgIGZhZGUgPSBzcGVjLmZhZGUsXG4gICAgICB2ZXJ0aWNhbCA9IHNwZWMudmVydGljYWw7XG4gIHZhciBzbGlkZU9mZnNldCA9IDA7XG4gIHZhciB0YXJnZXRMZWZ0O1xuICB2YXIgdGFyZ2V0U2xpZGU7XG4gIHZhciB2ZXJ0aWNhbE9mZnNldCA9IDA7XG5cbiAgaWYgKGZhZGUgfHwgc3BlYy5zbGlkZUNvdW50ID09PSAxKSB7XG4gICAgcmV0dXJuIDA7XG4gIH1cblxuICB2YXIgc2xpZGVzVG9PZmZzZXQgPSAwO1xuXG4gIGlmIChpbmZpbml0ZSkge1xuICAgIHNsaWRlc1RvT2Zmc2V0ID0gLWdldFByZUNsb25lcyhzcGVjKTsgLy8gYnJpbmcgYWN0aXZlIHNsaWRlIHRvIHRoZSBiZWdpbm5pbmcgb2YgdmlzdWFsIGFyZWFcbiAgICAvLyBpZiBuZXh0IHNjcm9sbCBkb2Vzbid0IGhhdmUgZW5vdWdoIGNoaWxkcmVuLCBqdXN0IHJlYWNoIHRpbGwgdGhlIGVuZCBvZiBvcmlnaW5hbCBzbGlkZXMgaW5zdGVhZCBvZiBzaGlmdGluZyBzbGlkZXNUb1Njcm9sbCBjaGlsZHJlblxuXG4gICAgaWYgKHNsaWRlQ291bnQgJSBzbGlkZXNUb1Njcm9sbCAhPT0gMCAmJiBzbGlkZUluZGV4ICsgc2xpZGVzVG9TY3JvbGwgPiBzbGlkZUNvdW50KSB7XG4gICAgICBzbGlkZXNUb09mZnNldCA9IC0oc2xpZGVJbmRleCA+IHNsaWRlQ291bnQgPyBzbGlkZXNUb1Nob3cgLSAoc2xpZGVJbmRleCAtIHNsaWRlQ291bnQpIDogc2xpZGVDb3VudCAlIHNsaWRlc1RvU2Nyb2xsKTtcbiAgICB9IC8vIHNoaWZ0IGN1cnJlbnQgc2xpZGUgdG8gY2VudGVyIG9mIHRoZSBmcmFtZVxuXG5cbiAgICBpZiAoY2VudGVyTW9kZSkge1xuICAgICAgc2xpZGVzVG9PZmZzZXQgKz0gcGFyc2VJbnQoc2xpZGVzVG9TaG93IC8gMik7XG4gICAgfVxuICB9IGVsc2Uge1xuICAgIGlmIChzbGlkZUNvdW50ICUgc2xpZGVzVG9TY3JvbGwgIT09IDAgJiYgc2xpZGVJbmRleCArIHNsaWRlc1RvU2Nyb2xsID4gc2xpZGVDb3VudCkge1xuICAgICAgc2xpZGVzVG9PZmZzZXQgPSBzbGlkZXNUb1Nob3cgLSBzbGlkZUNvdW50ICUgc2xpZGVzVG9TY3JvbGw7XG4gICAgfVxuXG4gICAgaWYgKGNlbnRlck1vZGUpIHtcbiAgICAgIHNsaWRlc1RvT2Zmc2V0ID0gcGFyc2VJbnQoc2xpZGVzVG9TaG93IC8gMik7XG4gICAgfVxuICB9XG5cbiAgc2xpZGVPZmZzZXQgPSBzbGlkZXNUb09mZnNldCAqIHNsaWRlV2lkdGg7XG4gIHZlcnRpY2FsT2Zmc2V0ID0gc2xpZGVzVG9PZmZzZXQgKiBzbGlkZUhlaWdodDtcblxuICBpZiAoIXZlcnRpY2FsKSB7XG4gICAgdGFyZ2V0TGVmdCA9IHNsaWRlSW5kZXggKiBzbGlkZVdpZHRoICogLTEgKyBzbGlkZU9mZnNldDtcbiAgfSBlbHNlIHtcbiAgICB0YXJnZXRMZWZ0ID0gc2xpZGVJbmRleCAqIHNsaWRlSGVpZ2h0ICogLTEgKyB2ZXJ0aWNhbE9mZnNldDtcbiAgfVxuXG4gIGlmICh2YXJpYWJsZVdpZHRoID09PSB0cnVlKSB7XG4gICAgdmFyIHRhcmdldFNsaWRlSW5kZXg7XG4gICAgdmFyIHRyYWNrRWxlbSA9IHRyYWNrUmVmICYmIHRyYWNrUmVmLm5vZGU7XG4gICAgdGFyZ2V0U2xpZGVJbmRleCA9IHNsaWRlSW5kZXggKyBnZXRQcmVDbG9uZXMoc3BlYyk7XG4gICAgdGFyZ2V0U2xpZGUgPSB0cmFja0VsZW0gJiYgdHJhY2tFbGVtLmNoaWxkTm9kZXNbdGFyZ2V0U2xpZGVJbmRleF07XG4gICAgdGFyZ2V0TGVmdCA9IHRhcmdldFNsaWRlID8gdGFyZ2V0U2xpZGUub2Zmc2V0TGVmdCAqIC0xIDogMDtcblxuICAgIGlmIChjZW50ZXJNb2RlID09PSB0cnVlKSB7XG4gICAgICB0YXJnZXRTbGlkZUluZGV4ID0gaW5maW5pdGUgPyBzbGlkZUluZGV4ICsgZ2V0UHJlQ2xvbmVzKHNwZWMpIDogc2xpZGVJbmRleDtcbiAgICAgIHRhcmdldFNsaWRlID0gdHJhY2tFbGVtICYmIHRyYWNrRWxlbS5jaGlsZHJlblt0YXJnZXRTbGlkZUluZGV4XTtcbiAgICAgIHRhcmdldExlZnQgPSAwO1xuXG4gICAgICBmb3IgKHZhciBzbGlkZSA9IDA7IHNsaWRlIDwgdGFyZ2V0U2xpZGVJbmRleDsgc2xpZGUrKykge1xuICAgICAgICB0YXJnZXRMZWZ0IC09IHRyYWNrRWxlbSAmJiB0cmFja0VsZW0uY2hpbGRyZW5bc2xpZGVdICYmIHRyYWNrRWxlbS5jaGlsZHJlbltzbGlkZV0ub2Zmc2V0V2lkdGg7XG4gICAgICB9XG5cbiAgICAgIHRhcmdldExlZnQgLT0gcGFyc2VJbnQoc3BlYy5jZW50ZXJQYWRkaW5nKTtcbiAgICAgIHRhcmdldExlZnQgKz0gdGFyZ2V0U2xpZGUgJiYgKGxpc3RXaWR0aCAtIHRhcmdldFNsaWRlLm9mZnNldFdpZHRoKSAvIDI7XG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIHRhcmdldExlZnQ7XG59O1xuXG5leHBvcnRzLmdldFRyYWNrTGVmdCA9IGdldFRyYWNrTGVmdDtcblxudmFyIGdldFByZUNsb25lcyA9IGZ1bmN0aW9uIGdldFByZUNsb25lcyhzcGVjKSB7XG4gIGlmIChzcGVjLnVuc2xpY2sgfHwgIXNwZWMuaW5maW5pdGUpIHtcbiAgICByZXR1cm4gMDtcbiAgfVxuXG4gIGlmIChzcGVjLnZhcmlhYmxlV2lkdGgpIHtcbiAgICByZXR1cm4gc3BlYy5zbGlkZUNvdW50O1xuICB9XG5cbiAgcmV0dXJuIHNwZWMuc2xpZGVzVG9TaG93ICsgKHNwZWMuY2VudGVyTW9kZSA/IDEgOiAwKTtcbn07XG5cbmV4cG9ydHMuZ2V0UHJlQ2xvbmVzID0gZ2V0UHJlQ2xvbmVzO1xuXG52YXIgZ2V0UG9zdENsb25lcyA9IGZ1bmN0aW9uIGdldFBvc3RDbG9uZXMoc3BlYykge1xuICBpZiAoc3BlYy51bnNsaWNrIHx8ICFzcGVjLmluZmluaXRlKSB7XG4gICAgcmV0dXJuIDA7XG4gIH1cblxuICByZXR1cm4gc3BlYy5zbGlkZUNvdW50O1xufTtcblxuZXhwb3J0cy5nZXRQb3N0Q2xvbmVzID0gZ2V0UG9zdENsb25lcztcblxudmFyIGdldFRvdGFsU2xpZGVzID0gZnVuY3Rpb24gZ2V0VG90YWxTbGlkZXMoc3BlYykge1xuICByZXR1cm4gc3BlYy5zbGlkZUNvdW50ID09PSAxID8gMSA6IGdldFByZUNsb25lcyhzcGVjKSArIHNwZWMuc2xpZGVDb3VudCArIGdldFBvc3RDbG9uZXMoc3BlYyk7XG59O1xuXG5leHBvcnRzLmdldFRvdGFsU2xpZGVzID0gZ2V0VG90YWxTbGlkZXM7XG5cbnZhciBzaWJsaW5nRGlyZWN0aW9uID0gZnVuY3Rpb24gc2libGluZ0RpcmVjdGlvbihzcGVjKSB7XG4gIGlmIChzcGVjLnRhcmdldFNsaWRlID4gc3BlYy5jdXJyZW50U2xpZGUpIHtcbiAgICBpZiAoc3BlYy50YXJnZXRTbGlkZSA+IHNwZWMuY3VycmVudFNsaWRlICsgc2xpZGVzT25SaWdodChzcGVjKSkge1xuICAgICAgcmV0dXJuIFwibGVmdFwiO1xuICAgIH1cblxuICAgIHJldHVybiBcInJpZ2h0XCI7XG4gIH0gZWxzZSB7XG4gICAgaWYgKHNwZWMudGFyZ2V0U2xpZGUgPCBzcGVjLmN1cnJlbnRTbGlkZSAtIHNsaWRlc09uTGVmdChzcGVjKSkge1xuICAgICAgcmV0dXJuIFwicmlnaHRcIjtcbiAgICB9XG5cbiAgICByZXR1cm4gXCJsZWZ0XCI7XG4gIH1cbn07XG5cbmV4cG9ydHMuc2libGluZ0RpcmVjdGlvbiA9IHNpYmxpbmdEaXJlY3Rpb247XG5cbnZhciBzbGlkZXNPblJpZ2h0ID0gZnVuY3Rpb24gc2xpZGVzT25SaWdodChfcmVmKSB7XG4gIHZhciBzbGlkZXNUb1Nob3cgPSBfcmVmLnNsaWRlc1RvU2hvdyxcbiAgICAgIGNlbnRlck1vZGUgPSBfcmVmLmNlbnRlck1vZGUsXG4gICAgICBydGwgPSBfcmVmLnJ0bCxcbiAgICAgIGNlbnRlclBhZGRpbmcgPSBfcmVmLmNlbnRlclBhZGRpbmc7XG5cbiAgLy8gcmV0dXJucyBubyBvZiBzbGlkZXMgb24gdGhlIHJpZ2h0IG9mIGFjdGl2ZSBzbGlkZVxuICBpZiAoY2VudGVyTW9kZSkge1xuICAgIHZhciByaWdodCA9IChzbGlkZXNUb1Nob3cgLSAxKSAvIDIgKyAxO1xuICAgIGlmIChwYXJzZUludChjZW50ZXJQYWRkaW5nKSA+IDApIHJpZ2h0ICs9IDE7XG4gICAgaWYgKHJ0bCAmJiBzbGlkZXNUb1Nob3cgJSAyID09PSAwKSByaWdodCArPSAxO1xuICAgIHJldHVybiByaWdodDtcbiAgfVxuXG4gIGlmIChydGwpIHtcbiAgICByZXR1cm4gMDtcbiAgfVxuXG4gIHJldHVybiBzbGlkZXNUb1Nob3cgLSAxO1xufTtcblxuZXhwb3J0cy5zbGlkZXNPblJpZ2h0ID0gc2xpZGVzT25SaWdodDtcblxudmFyIHNsaWRlc09uTGVmdCA9IGZ1bmN0aW9uIHNsaWRlc09uTGVmdChfcmVmMikge1xuICB2YXIgc2xpZGVzVG9TaG93ID0gX3JlZjIuc2xpZGVzVG9TaG93LFxuICAgICAgY2VudGVyTW9kZSA9IF9yZWYyLmNlbnRlck1vZGUsXG4gICAgICBydGwgPSBfcmVmMi5ydGwsXG4gICAgICBjZW50ZXJQYWRkaW5nID0gX3JlZjIuY2VudGVyUGFkZGluZztcblxuICAvLyByZXR1cm5zIG5vIG9mIHNsaWRlcyBvbiB0aGUgbGVmdCBvZiBhY3RpdmUgc2xpZGVcbiAgaWYgKGNlbnRlck1vZGUpIHtcbiAgICB2YXIgbGVmdCA9IChzbGlkZXNUb1Nob3cgLSAxKSAvIDIgKyAxO1xuICAgIGlmIChwYXJzZUludChjZW50ZXJQYWRkaW5nKSA+IDApIGxlZnQgKz0gMTtcbiAgICBpZiAoIXJ0bCAmJiBzbGlkZXNUb1Nob3cgJSAyID09PSAwKSBsZWZ0ICs9IDE7XG4gICAgcmV0dXJuIGxlZnQ7XG4gIH1cblxuICBpZiAocnRsKSB7XG4gICAgcmV0dXJuIHNsaWRlc1RvU2hvdyAtIDE7XG4gIH1cblxuICByZXR1cm4gMDtcbn07XG5cbmV4cG9ydHMuc2xpZGVzT25MZWZ0ID0gc2xpZGVzT25MZWZ0O1xuXG52YXIgY2FuVXNlRE9NID0gZnVuY3Rpb24gY2FuVXNlRE9NKCkge1xuICByZXR1cm4gISEodHlwZW9mIHdpbmRvdyAhPT0gXCJ1bmRlZmluZWRcIiAmJiB3aW5kb3cuZG9jdW1lbnQgJiYgd2luZG93LmRvY3VtZW50LmNyZWF0ZUVsZW1lbnQpO1xufTtcblxuZXhwb3J0cy5jYW5Vc2VET00gPSBjYW5Vc2VET007Il0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/react-slick/lib/utils/innerSliderUtils.js\n"));

/***/ }),

/***/ "./node_modules/resize-observer-polyfill/dist/ResizeObserver.es.js":
/*!*************************************************************************!*\
  !*** ./node_modules/resize-observer-polyfill/dist/ResizeObserver.es.js ***!
  \*************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
eval(__webpack_require__.ts("__webpack_require__.r(__webpack_exports__);\n/**\r\n * A collection of shims that provide minimal functionality of the ES6 collections.\r\n *\r\n * These implementations are not meant to be used outside of the ResizeObserver\r\n * modules as they cover only a limited range of use cases.\r\n */\r\n/* eslint-disable require-jsdoc, valid-jsdoc */\r\nvar MapShim = (function () {\r\n    if (typeof Map !== 'undefined') {\r\n        return Map;\r\n    }\r\n    /**\r\n     * Returns index in provided array that matches the specified key.\r\n     *\r\n     * @param {Array<Array>} arr\r\n     * @param {*} key\r\n     * @returns {number}\r\n     */\r\n    function getIndex(arr, key) {\r\n        var result = -1;\r\n        arr.some(function (entry, index) {\r\n            if (entry[0] === key) {\r\n                result = index;\r\n                return true;\r\n            }\r\n            return false;\r\n        });\r\n        return result;\r\n    }\r\n    return /** @class */ (function () {\r\n        function class_1() {\r\n            this.__entries__ = [];\r\n        }\r\n        Object.defineProperty(class_1.prototype, \"size\", {\r\n            /**\r\n             * @returns {boolean}\r\n             */\r\n            get: function () {\r\n                return this.__entries__.length;\r\n            },\r\n            enumerable: true,\r\n            configurable: true\r\n        });\r\n        /**\r\n         * @param {*} key\r\n         * @returns {*}\r\n         */\r\n        class_1.prototype.get = function (key) {\r\n            var index = getIndex(this.__entries__, key);\r\n            var entry = this.__entries__[index];\r\n            return entry && entry[1];\r\n        };\r\n        /**\r\n         * @param {*} key\r\n         * @param {*} value\r\n         * @returns {void}\r\n         */\r\n        class_1.prototype.set = function (key, value) {\r\n            var index = getIndex(this.__entries__, key);\r\n            if (~index) {\r\n                this.__entries__[index][1] = value;\r\n            }\r\n            else {\r\n                this.__entries__.push([key, value]);\r\n            }\r\n        };\r\n        /**\r\n         * @param {*} key\r\n         * @returns {void}\r\n         */\r\n        class_1.prototype.delete = function (key) {\r\n            var entries = this.__entries__;\r\n            var index = getIndex(entries, key);\r\n            if (~index) {\r\n                entries.splice(index, 1);\r\n            }\r\n        };\r\n        /**\r\n         * @param {*} key\r\n         * @returns {void}\r\n         */\r\n        class_1.prototype.has = function (key) {\r\n            return !!~getIndex(this.__entries__, key);\r\n        };\r\n        /**\r\n         * @returns {void}\r\n         */\r\n        class_1.prototype.clear = function () {\r\n            this.__entries__.splice(0);\r\n        };\r\n        /**\r\n         * @param {Function} callback\r\n         * @param {*} [ctx=null]\r\n         * @returns {void}\r\n         */\r\n        class_1.prototype.forEach = function (callback, ctx) {\r\n            if (ctx === void 0) { ctx = null; }\r\n            for (var _i = 0, _a = this.__entries__; _i < _a.length; _i++) {\r\n                var entry = _a[_i];\r\n                callback.call(ctx, entry[1], entry[0]);\r\n            }\r\n        };\r\n        return class_1;\r\n    }());\r\n})();\n\n/**\r\n * Detects whether window and document objects are available in current environment.\r\n */\r\nvar isBrowser = typeof window !== 'undefined' && typeof document !== 'undefined' && window.document === document;\n\n// Returns global object of a current environment.\r\nvar global$1 = (function () {\r\n    if (typeof __webpack_require__.g !== 'undefined' && __webpack_require__.g.Math === Math) {\r\n        return __webpack_require__.g;\r\n    }\r\n    if (typeof self !== 'undefined' && self.Math === Math) {\r\n        return self;\r\n    }\r\n    if (typeof window !== 'undefined' && window.Math === Math) {\r\n        return window;\r\n    }\r\n    // eslint-disable-next-line no-new-func\r\n    return Function('return this')();\r\n})();\n\n/**\r\n * A shim for the requestAnimationFrame which falls back to the setTimeout if\r\n * first one is not supported.\r\n *\r\n * @returns {number} Requests' identifier.\r\n */\r\nvar requestAnimationFrame$1 = (function () {\r\n    if (typeof requestAnimationFrame === 'function') {\r\n        // It's required to use a bounded function because IE sometimes throws\r\n        // an \"Invalid calling object\" error if rAF is invoked without the global\r\n        // object on the left hand side.\r\n        return requestAnimationFrame.bind(global$1);\r\n    }\r\n    return function (callback) { return setTimeout(function () { return callback(Date.now()); }, 1000 / 60); };\r\n})();\n\n// Defines minimum timeout before adding a trailing call.\r\nvar trailingTimeout = 2;\r\n/**\r\n * Creates a wrapper function which ensures that provided callback will be\r\n * invoked only once during the specified delay period.\r\n *\r\n * @param {Function} callback - Function to be invoked after the delay period.\r\n * @param {number} delay - Delay after which to invoke callback.\r\n * @returns {Function}\r\n */\r\nfunction throttle (callback, delay) {\r\n    var leadingCall = false, trailingCall = false, lastCallTime = 0;\r\n    /**\r\n     * Invokes the original callback function and schedules new invocation if\r\n     * the \"proxy\" was called during current request.\r\n     *\r\n     * @returns {void}\r\n     */\r\n    function resolvePending() {\r\n        if (leadingCall) {\r\n            leadingCall = false;\r\n            callback();\r\n        }\r\n        if (trailingCall) {\r\n            proxy();\r\n        }\r\n    }\r\n    /**\r\n     * Callback invoked after the specified delay. It will further postpone\r\n     * invocation of the original function delegating it to the\r\n     * requestAnimationFrame.\r\n     *\r\n     * @returns {void}\r\n     */\r\n    function timeoutCallback() {\r\n        requestAnimationFrame$1(resolvePending);\r\n    }\r\n    /**\r\n     * Schedules invocation of the original function.\r\n     *\r\n     * @returns {void}\r\n     */\r\n    function proxy() {\r\n        var timeStamp = Date.now();\r\n        if (leadingCall) {\r\n            // Reject immediately following calls.\r\n            if (timeStamp - lastCallTime < trailingTimeout) {\r\n                return;\r\n            }\r\n            // Schedule new call to be in invoked when the pending one is resolved.\r\n            // This is important for \"transitions\" which never actually start\r\n            // immediately so there is a chance that we might miss one if change\r\n            // happens amids the pending invocation.\r\n            trailingCall = true;\r\n        }\r\n        else {\r\n            leadingCall = true;\r\n            trailingCall = false;\r\n            setTimeout(timeoutCallback, delay);\r\n        }\r\n        lastCallTime = timeStamp;\r\n    }\r\n    return proxy;\r\n}\n\n// Minimum delay before invoking the update of observers.\r\nvar REFRESH_DELAY = 20;\r\n// A list of substrings of CSS properties used to find transition events that\r\n// might affect dimensions of observed elements.\r\nvar transitionKeys = ['top', 'right', 'bottom', 'left', 'width', 'height', 'size', 'weight'];\r\n// Check if MutationObserver is available.\r\nvar mutationObserverSupported = typeof MutationObserver !== 'undefined';\r\n/**\r\n * Singleton controller class which handles updates of ResizeObserver instances.\r\n */\r\nvar ResizeObserverController = /** @class */ (function () {\r\n    /**\r\n     * Creates a new instance of ResizeObserverController.\r\n     *\r\n     * @private\r\n     */\r\n    function ResizeObserverController() {\r\n        /**\r\n         * Indicates whether DOM listeners have been added.\r\n         *\r\n         * @private {boolean}\r\n         */\r\n        this.connected_ = false;\r\n        /**\r\n         * Tells that controller has subscribed for Mutation Events.\r\n         *\r\n         * @private {boolean}\r\n         */\r\n        this.mutationEventsAdded_ = false;\r\n        /**\r\n         * Keeps reference to the instance of MutationObserver.\r\n         *\r\n         * @private {MutationObserver}\r\n         */\r\n        this.mutationsObserver_ = null;\r\n        /**\r\n         * A list of connected observers.\r\n         *\r\n         * @private {Array<ResizeObserverSPI>}\r\n         */\r\n        this.observers_ = [];\r\n        this.onTransitionEnd_ = this.onTransitionEnd_.bind(this);\r\n        this.refresh = throttle(this.refresh.bind(this), REFRESH_DELAY);\r\n    }\r\n    /**\r\n     * Adds observer to observers list.\r\n     *\r\n     * @param {ResizeObserverSPI} observer - Observer to be added.\r\n     * @returns {void}\r\n     */\r\n    ResizeObserverController.prototype.addObserver = function (observer) {\r\n        if (!~this.observers_.indexOf(observer)) {\r\n            this.observers_.push(observer);\r\n        }\r\n        // Add listeners if they haven't been added yet.\r\n        if (!this.connected_) {\r\n            this.connect_();\r\n        }\r\n    };\r\n    /**\r\n     * Removes observer from observers list.\r\n     *\r\n     * @param {ResizeObserverSPI} observer - Observer to be removed.\r\n     * @returns {void}\r\n     */\r\n    ResizeObserverController.prototype.removeObserver = function (observer) {\r\n        var observers = this.observers_;\r\n        var index = observers.indexOf(observer);\r\n        // Remove observer if it's present in registry.\r\n        if (~index) {\r\n            observers.splice(index, 1);\r\n        }\r\n        // Remove listeners if controller has no connected observers.\r\n        if (!observers.length && this.connected_) {\r\n            this.disconnect_();\r\n        }\r\n    };\r\n    /**\r\n     * Invokes the update of observers. It will continue running updates insofar\r\n     * it detects changes.\r\n     *\r\n     * @returns {void}\r\n     */\r\n    ResizeObserverController.prototype.refresh = function () {\r\n        var changesDetected = this.updateObservers_();\r\n        // Continue running updates if changes have been detected as there might\r\n        // be future ones caused by CSS transitions.\r\n        if (changesDetected) {\r\n            this.refresh();\r\n        }\r\n    };\r\n    /**\r\n     * Updates every observer from observers list and notifies them of queued\r\n     * entries.\r\n     *\r\n     * @private\r\n     * @returns {boolean} Returns \"true\" if any observer has detected changes in\r\n     *      dimensions of it's elements.\r\n     */\r\n    ResizeObserverController.prototype.updateObservers_ = function () {\r\n        // Collect observers that have active observations.\r\n        var activeObservers = this.observers_.filter(function (observer) {\r\n            return observer.gatherActive(), observer.hasActive();\r\n        });\r\n        // Deliver notifications in a separate cycle in order to avoid any\r\n        // collisions between observers, e.g. when multiple instances of\r\n        // ResizeObserver are tracking the same element and the callback of one\r\n        // of them changes content dimensions of the observed target. Sometimes\r\n        // this may result in notifications being blocked for the rest of observers.\r\n        activeObservers.forEach(function (observer) { return observer.broadcastActive(); });\r\n        return activeObservers.length > 0;\r\n    };\r\n    /**\r\n     * Initializes DOM listeners.\r\n     *\r\n     * @private\r\n     * @returns {void}\r\n     */\r\n    ResizeObserverController.prototype.connect_ = function () {\r\n        // Do nothing if running in a non-browser environment or if listeners\r\n        // have been already added.\r\n        if (!isBrowser || this.connected_) {\r\n            return;\r\n        }\r\n        // Subscription to the \"Transitionend\" event is used as a workaround for\r\n        // delayed transitions. This way it's possible to capture at least the\r\n        // final state of an element.\r\n        document.addEventListener('transitionend', this.onTransitionEnd_);\r\n        window.addEventListener('resize', this.refresh);\r\n        if (mutationObserverSupported) {\r\n            this.mutationsObserver_ = new MutationObserver(this.refresh);\r\n            this.mutationsObserver_.observe(document, {\r\n                attributes: true,\r\n                childList: true,\r\n                characterData: true,\r\n                subtree: true\r\n            });\r\n        }\r\n        else {\r\n            document.addEventListener('DOMSubtreeModified', this.refresh);\r\n            this.mutationEventsAdded_ = true;\r\n        }\r\n        this.connected_ = true;\r\n    };\r\n    /**\r\n     * Removes DOM listeners.\r\n     *\r\n     * @private\r\n     * @returns {void}\r\n     */\r\n    ResizeObserverController.prototype.disconnect_ = function () {\r\n        // Do nothing if running in a non-browser environment or if listeners\r\n        // have been already removed.\r\n        if (!isBrowser || !this.connected_) {\r\n            return;\r\n        }\r\n        document.removeEventListener('transitionend', this.onTransitionEnd_);\r\n        window.removeEventListener('resize', this.refresh);\r\n        if (this.mutationsObserver_) {\r\n            this.mutationsObserver_.disconnect();\r\n        }\r\n        if (this.mutationEventsAdded_) {\r\n            document.removeEventListener('DOMSubtreeModified', this.refresh);\r\n        }\r\n        this.mutationsObserver_ = null;\r\n        this.mutationEventsAdded_ = false;\r\n        this.connected_ = false;\r\n    };\r\n    /**\r\n     * \"Transitionend\" event handler.\r\n     *\r\n     * @private\r\n     * @param {TransitionEvent} event\r\n     * @returns {void}\r\n     */\r\n    ResizeObserverController.prototype.onTransitionEnd_ = function (_a) {\r\n        var _b = _a.propertyName, propertyName = _b === void 0 ? '' : _b;\r\n        // Detect whether transition may affect dimensions of an element.\r\n        var isReflowProperty = transitionKeys.some(function (key) {\r\n            return !!~propertyName.indexOf(key);\r\n        });\r\n        if (isReflowProperty) {\r\n            this.refresh();\r\n        }\r\n    };\r\n    /**\r\n     * Returns instance of the ResizeObserverController.\r\n     *\r\n     * @returns {ResizeObserverController}\r\n     */\r\n    ResizeObserverController.getInstance = function () {\r\n        if (!this.instance_) {\r\n            this.instance_ = new ResizeObserverController();\r\n        }\r\n        return this.instance_;\r\n    };\r\n    /**\r\n     * Holds reference to the controller's instance.\r\n     *\r\n     * @private {ResizeObserverController}\r\n     */\r\n    ResizeObserverController.instance_ = null;\r\n    return ResizeObserverController;\r\n}());\n\n/**\r\n * Defines non-writable/enumerable properties of the provided target object.\r\n *\r\n * @param {Object} target - Object for which to define properties.\r\n * @param {Object} props - Properties to be defined.\r\n * @returns {Object} Target object.\r\n */\r\nvar defineConfigurable = (function (target, props) {\r\n    for (var _i = 0, _a = Object.keys(props); _i < _a.length; _i++) {\r\n        var key = _a[_i];\r\n        Object.defineProperty(target, key, {\r\n            value: props[key],\r\n            enumerable: false,\r\n            writable: false,\r\n            configurable: true\r\n        });\r\n    }\r\n    return target;\r\n});\n\n/**\r\n * Returns the global object associated with provided element.\r\n *\r\n * @param {Object} target\r\n * @returns {Object}\r\n */\r\nvar getWindowOf = (function (target) {\r\n    // Assume that the element is an instance of Node, which means that it\r\n    // has the \"ownerDocument\" property from which we can retrieve a\r\n    // corresponding global object.\r\n    var ownerGlobal = target && target.ownerDocument && target.ownerDocument.defaultView;\r\n    // Return the local global object if it's not possible extract one from\r\n    // provided element.\r\n    return ownerGlobal || global$1;\r\n});\n\n// Placeholder of an empty content rectangle.\r\nvar emptyRect = createRectInit(0, 0, 0, 0);\r\n/**\r\n * Converts provided string to a number.\r\n *\r\n * @param {number|string} value\r\n * @returns {number}\r\n */\r\nfunction toFloat(value) {\r\n    return parseFloat(value) || 0;\r\n}\r\n/**\r\n * Extracts borders size from provided styles.\r\n *\r\n * @param {CSSStyleDeclaration} styles\r\n * @param {...string} positions - Borders positions (top, right, ...)\r\n * @returns {number}\r\n */\r\nfunction getBordersSize(styles) {\r\n    var positions = [];\r\n    for (var _i = 1; _i < arguments.length; _i++) {\r\n        positions[_i - 1] = arguments[_i];\r\n    }\r\n    return positions.reduce(function (size, position) {\r\n        var value = styles['border-' + position + '-width'];\r\n        return size + toFloat(value);\r\n    }, 0);\r\n}\r\n/**\r\n * Extracts paddings sizes from provided styles.\r\n *\r\n * @param {CSSStyleDeclaration} styles\r\n * @returns {Object} Paddings box.\r\n */\r\nfunction getPaddings(styles) {\r\n    var positions = ['top', 'right', 'bottom', 'left'];\r\n    var paddings = {};\r\n    for (var _i = 0, positions_1 = positions; _i < positions_1.length; _i++) {\r\n        var position = positions_1[_i];\r\n        var value = styles['padding-' + position];\r\n        paddings[position] = toFloat(value);\r\n    }\r\n    return paddings;\r\n}\r\n/**\r\n * Calculates content rectangle of provided SVG element.\r\n *\r\n * @param {SVGGraphicsElement} target - Element content rectangle of which needs\r\n *      to be calculated.\r\n * @returns {DOMRectInit}\r\n */\r\nfunction getSVGContentRect(target) {\r\n    var bbox = target.getBBox();\r\n    return createRectInit(0, 0, bbox.width, bbox.height);\r\n}\r\n/**\r\n * Calculates content rectangle of provided HTMLElement.\r\n *\r\n * @param {HTMLElement} target - Element for which to calculate the content rectangle.\r\n * @returns {DOMRectInit}\r\n */\r\nfunction getHTMLElementContentRect(target) {\r\n    // Client width & height properties can't be\r\n    // used exclusively as they provide rounded values.\r\n    var clientWidth = target.clientWidth, clientHeight = target.clientHeight;\r\n    // By this condition we can catch all non-replaced inline, hidden and\r\n    // detached elements. Though elements with width & height properties less\r\n    // than 0.5 will be discarded as well.\r\n    //\r\n    // Without it we would need to implement separate methods for each of\r\n    // those cases and it's not possible to perform a precise and performance\r\n    // effective test for hidden elements. E.g. even jQuery's ':visible' filter\r\n    // gives wrong results for elements with width & height less than 0.5.\r\n    if (!clientWidth && !clientHeight) {\r\n        return emptyRect;\r\n    }\r\n    var styles = getWindowOf(target).getComputedStyle(target);\r\n    var paddings = getPaddings(styles);\r\n    var horizPad = paddings.left + paddings.right;\r\n    var vertPad = paddings.top + paddings.bottom;\r\n    // Computed styles of width & height are being used because they are the\r\n    // only dimensions available to JS that contain non-rounded values. It could\r\n    // be possible to utilize the getBoundingClientRect if only it's data wasn't\r\n    // affected by CSS transformations let alone paddings, borders and scroll bars.\r\n    var width = toFloat(styles.width), height = toFloat(styles.height);\r\n    // Width & height include paddings and borders when the 'border-box' box\r\n    // model is applied (except for IE).\r\n    if (styles.boxSizing === 'border-box') {\r\n        // Following conditions are required to handle Internet Explorer which\r\n        // doesn't include paddings and borders to computed CSS dimensions.\r\n        //\r\n        // We can say that if CSS dimensions + paddings are equal to the \"client\"\r\n        // properties then it's either IE, and thus we don't need to subtract\r\n        // anything, or an element merely doesn't have paddings/borders styles.\r\n        if (Math.round(width + horizPad) !== clientWidth) {\r\n            width -= getBordersSize(styles, 'left', 'right') + horizPad;\r\n        }\r\n        if (Math.round(height + vertPad) !== clientHeight) {\r\n            height -= getBordersSize(styles, 'top', 'bottom') + vertPad;\r\n        }\r\n    }\r\n    // Following steps can't be applied to the document's root element as its\r\n    // client[Width/Height] properties represent viewport area of the window.\r\n    // Besides, it's as well not necessary as the <html> itself neither has\r\n    // rendered scroll bars nor it can be clipped.\r\n    if (!isDocumentElement(target)) {\r\n        // In some browsers (only in Firefox, actually) CSS width & height\r\n        // include scroll bars size which can be removed at this step as scroll\r\n        // bars are the only difference between rounded dimensions + paddings\r\n        // and \"client\" properties, though that is not always true in Chrome.\r\n        var vertScrollbar = Math.round(width + horizPad) - clientWidth;\r\n        var horizScrollbar = Math.round(height + vertPad) - clientHeight;\r\n        // Chrome has a rather weird rounding of \"client\" properties.\r\n        // E.g. for an element with content width of 314.2px it sometimes gives\r\n        // the client width of 315px and for the width of 314.7px it may give\r\n        // 314px. And it doesn't happen all the time. So just ignore this delta\r\n        // as a non-relevant.\r\n        if (Math.abs(vertScrollbar) !== 1) {\r\n            width -= vertScrollbar;\r\n        }\r\n        if (Math.abs(horizScrollbar) !== 1) {\r\n            height -= horizScrollbar;\r\n        }\r\n    }\r\n    return createRectInit(paddings.left, paddings.top, width, height);\r\n}\r\n/**\r\n * Checks whether provided element is an instance of the SVGGraphicsElement.\r\n *\r\n * @param {Element} target - Element to be checked.\r\n * @returns {boolean}\r\n */\r\nvar isSVGGraphicsElement = (function () {\r\n    // Some browsers, namely IE and Edge, don't have the SVGGraphicsElement\r\n    // interface.\r\n    if (typeof SVGGraphicsElement !== 'undefined') {\r\n        return function (target) { return target instanceof getWindowOf(target).SVGGraphicsElement; };\r\n    }\r\n    // If it's so, then check that element is at least an instance of the\r\n    // SVGElement and that it has the \"getBBox\" method.\r\n    // eslint-disable-next-line no-extra-parens\r\n    return function (target) { return (target instanceof getWindowOf(target).SVGElement &&\r\n        typeof target.getBBox === 'function'); };\r\n})();\r\n/**\r\n * Checks whether provided element is a document element (<html>).\r\n *\r\n * @param {Element} target - Element to be checked.\r\n * @returns {boolean}\r\n */\r\nfunction isDocumentElement(target) {\r\n    return target === getWindowOf(target).document.documentElement;\r\n}\r\n/**\r\n * Calculates an appropriate content rectangle for provided html or svg element.\r\n *\r\n * @param {Element} target - Element content rectangle of which needs to be calculated.\r\n * @returns {DOMRectInit}\r\n */\r\nfunction getContentRect(target) {\r\n    if (!isBrowser) {\r\n        return emptyRect;\r\n    }\r\n    if (isSVGGraphicsElement(target)) {\r\n        return getSVGContentRect(target);\r\n    }\r\n    return getHTMLElementContentRect(target);\r\n}\r\n/**\r\n * Creates rectangle with an interface of the DOMRectReadOnly.\r\n * Spec: https://drafts.fxtf.org/geometry/#domrectreadonly\r\n *\r\n * @param {DOMRectInit} rectInit - Object with rectangle's x/y coordinates and dimensions.\r\n * @returns {DOMRectReadOnly}\r\n */\r\nfunction createReadOnlyRect(_a) {\r\n    var x = _a.x, y = _a.y, width = _a.width, height = _a.height;\r\n    // If DOMRectReadOnly is available use it as a prototype for the rectangle.\r\n    var Constr = typeof DOMRectReadOnly !== 'undefined' ? DOMRectReadOnly : Object;\r\n    var rect = Object.create(Constr.prototype);\r\n    // Rectangle's properties are not writable and non-enumerable.\r\n    defineConfigurable(rect, {\r\n        x: x, y: y, width: width, height: height,\r\n        top: y,\r\n        right: x + width,\r\n        bottom: height + y,\r\n        left: x\r\n    });\r\n    return rect;\r\n}\r\n/**\r\n * Creates DOMRectInit object based on the provided dimensions and the x/y coordinates.\r\n * Spec: https://drafts.fxtf.org/geometry/#dictdef-domrectinit\r\n *\r\n * @param {number} x - X coordinate.\r\n * @param {number} y - Y coordinate.\r\n * @param {number} width - Rectangle's width.\r\n * @param {number} height - Rectangle's height.\r\n * @returns {DOMRectInit}\r\n */\r\nfunction createRectInit(x, y, width, height) {\r\n    return { x: x, y: y, width: width, height: height };\r\n}\n\n/**\r\n * Class that is responsible for computations of the content rectangle of\r\n * provided DOM element and for keeping track of it's changes.\r\n */\r\nvar ResizeObservation = /** @class */ (function () {\r\n    /**\r\n     * Creates an instance of ResizeObservation.\r\n     *\r\n     * @param {Element} target - Element to be observed.\r\n     */\r\n    function ResizeObservation(target) {\r\n        /**\r\n         * Broadcasted width of content rectangle.\r\n         *\r\n         * @type {number}\r\n         */\r\n        this.broadcastWidth = 0;\r\n        /**\r\n         * Broadcasted height of content rectangle.\r\n         *\r\n         * @type {number}\r\n         */\r\n        this.broadcastHeight = 0;\r\n        /**\r\n         * Reference to the last observed content rectangle.\r\n         *\r\n         * @private {DOMRectInit}\r\n         */\r\n        this.contentRect_ = createRectInit(0, 0, 0, 0);\r\n        this.target = target;\r\n    }\r\n    /**\r\n     * Updates content rectangle and tells whether it's width or height properties\r\n     * have changed since the last broadcast.\r\n     *\r\n     * @returns {boolean}\r\n     */\r\n    ResizeObservation.prototype.isActive = function () {\r\n        var rect = getContentRect(this.target);\r\n        this.contentRect_ = rect;\r\n        return (rect.width !== this.broadcastWidth ||\r\n            rect.height !== this.broadcastHeight);\r\n    };\r\n    /**\r\n     * Updates 'broadcastWidth' and 'broadcastHeight' properties with a data\r\n     * from the corresponding properties of the last observed content rectangle.\r\n     *\r\n     * @returns {DOMRectInit} Last observed content rectangle.\r\n     */\r\n    ResizeObservation.prototype.broadcastRect = function () {\r\n        var rect = this.contentRect_;\r\n        this.broadcastWidth = rect.width;\r\n        this.broadcastHeight = rect.height;\r\n        return rect;\r\n    };\r\n    return ResizeObservation;\r\n}());\n\nvar ResizeObserverEntry = /** @class */ (function () {\r\n    /**\r\n     * Creates an instance of ResizeObserverEntry.\r\n     *\r\n     * @param {Element} target - Element that is being observed.\r\n     * @param {DOMRectInit} rectInit - Data of the element's content rectangle.\r\n     */\r\n    function ResizeObserverEntry(target, rectInit) {\r\n        var contentRect = createReadOnlyRect(rectInit);\r\n        // According to the specification following properties are not writable\r\n        // and are also not enumerable in the native implementation.\r\n        //\r\n        // Property accessors are not being used as they'd require to define a\r\n        // private WeakMap storage which may cause memory leaks in browsers that\r\n        // don't support this type of collections.\r\n        defineConfigurable(this, { target: target, contentRect: contentRect });\r\n    }\r\n    return ResizeObserverEntry;\r\n}());\n\nvar ResizeObserverSPI = /** @class */ (function () {\r\n    /**\r\n     * Creates a new instance of ResizeObserver.\r\n     *\r\n     * @param {ResizeObserverCallback} callback - Callback function that is invoked\r\n     *      when one of the observed elements changes it's content dimensions.\r\n     * @param {ResizeObserverController} controller - Controller instance which\r\n     *      is responsible for the updates of observer.\r\n     * @param {ResizeObserver} callbackCtx - Reference to the public\r\n     *      ResizeObserver instance which will be passed to callback function.\r\n     */\r\n    function ResizeObserverSPI(callback, controller, callbackCtx) {\r\n        /**\r\n         * Collection of resize observations that have detected changes in dimensions\r\n         * of elements.\r\n         *\r\n         * @private {Array<ResizeObservation>}\r\n         */\r\n        this.activeObservations_ = [];\r\n        /**\r\n         * Registry of the ResizeObservation instances.\r\n         *\r\n         * @private {Map<Element, ResizeObservation>}\r\n         */\r\n        this.observations_ = new MapShim();\r\n        if (typeof callback !== 'function') {\r\n            throw new TypeError('The callback provided as parameter 1 is not a function.');\r\n        }\r\n        this.callback_ = callback;\r\n        this.controller_ = controller;\r\n        this.callbackCtx_ = callbackCtx;\r\n    }\r\n    /**\r\n     * Starts observing provided element.\r\n     *\r\n     * @param {Element} target - Element to be observed.\r\n     * @returns {void}\r\n     */\r\n    ResizeObserverSPI.prototype.observe = function (target) {\r\n        if (!arguments.length) {\r\n            throw new TypeError('1 argument required, but only 0 present.');\r\n        }\r\n        // Do nothing if current environment doesn't have the Element interface.\r\n        if (typeof Element === 'undefined' || !(Element instanceof Object)) {\r\n            return;\r\n        }\r\n        if (!(target instanceof getWindowOf(target).Element)) {\r\n            throw new TypeError('parameter 1 is not of type \"Element\".');\r\n        }\r\n        var observations = this.observations_;\r\n        // Do nothing if element is already being observed.\r\n        if (observations.has(target)) {\r\n            return;\r\n        }\r\n        observations.set(target, new ResizeObservation(target));\r\n        this.controller_.addObserver(this);\r\n        // Force the update of observations.\r\n        this.controller_.refresh();\r\n    };\r\n    /**\r\n     * Stops observing provided element.\r\n     *\r\n     * @param {Element} target - Element to stop observing.\r\n     * @returns {void}\r\n     */\r\n    ResizeObserverSPI.prototype.unobserve = function (target) {\r\n        if (!arguments.length) {\r\n            throw new TypeError('1 argument required, but only 0 present.');\r\n        }\r\n        // Do nothing if current environment doesn't have the Element interface.\r\n        if (typeof Element === 'undefined' || !(Element instanceof Object)) {\r\n            return;\r\n        }\r\n        if (!(target instanceof getWindowOf(target).Element)) {\r\n            throw new TypeError('parameter 1 is not of type \"Element\".');\r\n        }\r\n        var observations = this.observations_;\r\n        // Do nothing if element is not being observed.\r\n        if (!observations.has(target)) {\r\n            return;\r\n        }\r\n        observations.delete(target);\r\n        if (!observations.size) {\r\n            this.controller_.removeObserver(this);\r\n        }\r\n    };\r\n    /**\r\n     * Stops observing all elements.\r\n     *\r\n     * @returns {void}\r\n     */\r\n    ResizeObserverSPI.prototype.disconnect = function () {\r\n        this.clearActive();\r\n        this.observations_.clear();\r\n        this.controller_.removeObserver(this);\r\n    };\r\n    /**\r\n     * Collects observation instances the associated element of which has changed\r\n     * it's content rectangle.\r\n     *\r\n     * @returns {void}\r\n     */\r\n    ResizeObserverSPI.prototype.gatherActive = function () {\r\n        var _this = this;\r\n        this.clearActive();\r\n        this.observations_.forEach(function (observation) {\r\n            if (observation.isActive()) {\r\n                _this.activeObservations_.push(observation);\r\n            }\r\n        });\r\n    };\r\n    /**\r\n     * Invokes initial callback function with a list of ResizeObserverEntry\r\n     * instances collected from active resize observations.\r\n     *\r\n     * @returns {void}\r\n     */\r\n    ResizeObserverSPI.prototype.broadcastActive = function () {\r\n        // Do nothing if observer doesn't have active observations.\r\n        if (!this.hasActive()) {\r\n            return;\r\n        }\r\n        var ctx = this.callbackCtx_;\r\n        // Create ResizeObserverEntry instance for every active observation.\r\n        var entries = this.activeObservations_.map(function (observation) {\r\n            return new ResizeObserverEntry(observation.target, observation.broadcastRect());\r\n        });\r\n        this.callback_.call(ctx, entries, ctx);\r\n        this.clearActive();\r\n    };\r\n    /**\r\n     * Clears the collection of active observations.\r\n     *\r\n     * @returns {void}\r\n     */\r\n    ResizeObserverSPI.prototype.clearActive = function () {\r\n        this.activeObservations_.splice(0);\r\n    };\r\n    /**\r\n     * Tells whether observer has active observations.\r\n     *\r\n     * @returns {boolean}\r\n     */\r\n    ResizeObserverSPI.prototype.hasActive = function () {\r\n        return this.activeObservations_.length > 0;\r\n    };\r\n    return ResizeObserverSPI;\r\n}());\n\n// Registry of internal observers. If WeakMap is not available use current shim\r\n// for the Map collection as it has all required methods and because WeakMap\r\n// can't be fully polyfilled anyway.\r\nvar observers = typeof WeakMap !== 'undefined' ? new WeakMap() : new MapShim();\r\n/**\r\n * ResizeObserver API. Encapsulates the ResizeObserver SPI implementation\r\n * exposing only those methods and properties that are defined in the spec.\r\n */\r\nvar ResizeObserver = /** @class */ (function () {\r\n    /**\r\n     * Creates a new instance of ResizeObserver.\r\n     *\r\n     * @param {ResizeObserverCallback} callback - Callback that is invoked when\r\n     *      dimensions of the observed elements change.\r\n     */\r\n    function ResizeObserver(callback) {\r\n        if (!(this instanceof ResizeObserver)) {\r\n            throw new TypeError('Cannot call a class as a function.');\r\n        }\r\n        if (!arguments.length) {\r\n            throw new TypeError('1 argument required, but only 0 present.');\r\n        }\r\n        var controller = ResizeObserverController.getInstance();\r\n        var observer = new ResizeObserverSPI(callback, controller, this);\r\n        observers.set(this, observer);\r\n    }\r\n    return ResizeObserver;\r\n}());\r\n// Expose public methods of ResizeObserver.\r\n[\r\n    'observe',\r\n    'unobserve',\r\n    'disconnect'\r\n].forEach(function (method) {\r\n    ResizeObserver.prototype[method] = function () {\r\n        var _a;\r\n        return (_a = observers.get(this))[method].apply(_a, arguments);\r\n    };\r\n});\n\nvar index = (function () {\r\n    // Export existing implementation if available.\r\n    if (typeof global$1.ResizeObserver !== 'undefined') {\r\n        return global$1.ResizeObserver;\r\n    }\r\n    return ResizeObserver;\r\n})();\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (index);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/resize-observer-polyfill/dist/ResizeObserver.es.js\n"));

/***/ }),

/***/ "./node_modules/string-convert/camel2hyphen.js":
/*!*****************************************************!*\
  !*** ./node_modules/string-convert/camel2hyphen.js ***!
  \*****************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

eval(__webpack_require__.ts("var camel2hyphen = function (str) {\n  return str\n          .replace(/[A-Z]/g, function (match) {\n            return '-' + match.toLowerCase();\n          })\n          .toLowerCase();\n};\n\nmodule.exports = camel2hyphen;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvc3RyaW5nLWNvbnZlcnQvY2FtZWwyaHlwaGVuLmpzLmpzIiwibWFwcGluZ3MiOiJBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsV0FBVztBQUNYO0FBQ0E7O0FBRUEiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9fTl9FLy4vbm9kZV9tb2R1bGVzL3N0cmluZy1jb252ZXJ0L2NhbWVsMmh5cGhlbi5qcz82ZTgwIl0sInNvdXJjZXNDb250ZW50IjpbInZhciBjYW1lbDJoeXBoZW4gPSBmdW5jdGlvbiAoc3RyKSB7XG4gIHJldHVybiBzdHJcbiAgICAgICAgICAucmVwbGFjZSgvW0EtWl0vZywgZnVuY3Rpb24gKG1hdGNoKSB7XG4gICAgICAgICAgICByZXR1cm4gJy0nICsgbWF0Y2gudG9Mb3dlckNhc2UoKTtcbiAgICAgICAgICB9KVxuICAgICAgICAgIC50b0xvd2VyQ2FzZSgpO1xufTtcblxubW9kdWxlLmV4cG9ydHMgPSBjYW1lbDJoeXBoZW47Il0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/string-convert/camel2hyphen.js\n"));

/***/ })

}]);